/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.core.tests;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.internal.core.model.IncludeEntry;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IOptionPathConverter;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.tests.TestPathConverter1;
import org.eclipse.cdt.managedbuilder.core.tests.TestPathConverter2;
import org.eclipse.cdt.managedbuilder.core.tests.TestPathConverter3;
import org.eclipse.cdt.managedbuilder.core.tests.TestPathConverter4;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.testplugin.ManagedBuildTestHelper;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;

public class PathConverterTest
extends TestCase {
    public PathConverterTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(PathConverterTest.class.getName());
        suite.addTest((Test)new PathConverterTest("testPathConversionInProject"));
        suite.addTest((Test)new PathConverterTest("testPathConverterConfigurations"));
        return suite;
    }

    protected Class getExpectedToolConverterClass(String configId) {
        boolean hasToolConverter = false;
        boolean hasToolInheritedConverter = false;
        int toolInfoAt = configId.indexOf("to");
        String toolinfo = configId.substring(toolInfoAt + 2, toolInfoAt + 4);
        hasToolConverter = toolinfo.charAt(0) == 'y';
        hasToolInheritedConverter = toolinfo.charAt(1) == 'y';
        Class toolConverterClass = this.getExpectedToolchainConverterClass(configId);
        if (hasToolInheritedConverter) {
            toolConverterClass = TestPathConverter2.class;
        }
        if (hasToolConverter) {
            toolConverterClass = TestPathConverter4.class;
        }
        return toolConverterClass;
    }

    protected Class getExpectedToolchainConverterClass(String configId) {
        boolean hasToolchainConverter = false;
        boolean hasToolchainInheritedConverter = false;
        int toolchainInfoAt = configId.indexOf("tc");
        String toolchaininfo = configId.substring(toolchainInfoAt + 2, toolchainInfoAt + 4);
        hasToolchainConverter = toolchaininfo.charAt(0) == 'y';
        hasToolchainInheritedConverter = toolchaininfo.charAt(1) == 'y';
        Class<TestPathConverter1> toolConverterClass = null;
        if (hasToolchainInheritedConverter) {
            toolConverterClass = TestPathConverter1.class;
        }
        if (hasToolchainConverter) {
            toolConverterClass = TestPathConverter3.class;
        }
        return toolConverterClass;
    }

    public void testPathConverterConfigurations() {
        IProjectType[] projTypes = ManagedBuildManager.getDefinedProjectTypes();
        PathConverterTest.assertNotNull((String)"Project types were not loaded!", (Object)projTypes);
        IProjectType projType = ManagedBuildManager.getProjectType((String)"pathconvertertest.projecttype");
        PathConverterTest.assertNotNull((String)"Projecttype should have been loaded!", (Object)projType);
        IConfiguration[] configurations = projType.getConfigurations();
        PathConverterTest.assertTrue((String)"There should be some configurations!", (configurations.length > 0 ? 1 : 0) != 0);
        int i = 0;
        while (i < configurations.length) {
            IConfiguration configuration = configurations[i];
            IToolChain toolchain = configuration.getToolChain();
            Class expectedToolchainConverterClass = this.getExpectedToolchainConverterClass(configuration.getId());
            IOptionPathConverter toolchainPathConverter = toolchain.getOptionPathConverter();
            if (expectedToolchainConverterClass == null) {
                PathConverterTest.assertNull((String)"null pathConverter expected for toolchain!", (Object)toolchainPathConverter);
            } else {
                PathConverterTest.assertEquals((String)"Unexpected pathConverter type for toolchain", (Object)expectedToolchainConverterClass, toolchainPathConverter.getClass());
            }
            ITool tool = toolchain.getTools()[0];
            Class expectedToolConverterClass = this.getExpectedToolConverterClass(configuration.getId());
            IOptionPathConverter toolPathConverter = tool.getOptionPathConverter();
            if (expectedToolConverterClass == null) {
                PathConverterTest.assertNull((String)"null pathConverter expected for tool!", (Object)toolPathConverter);
            } else {
                PathConverterTest.assertEquals((String)"Unexpected pathConverter type for tool", (Object)expectedToolConverterClass, toolPathConverter.getClass());
            }
            ++i;
        }
    }

    public void testPathConversionInProject() throws Exception {
        IProjectType type = ManagedBuildManager.getProjectType((String)"pathconvertertest.projecttype");
        IProject project = ManagedBuildTestHelper.createProject("pathconverter01", type.getId());
        IManagedBuildInfo iinfo = ManagedBuildManager.getBuildInfo((IResource)project);
        PathConverterTest.assertNotNull((String)"build info could not be obtained", (Object)iinfo);
        ManagedBuildInfo info = (ManagedBuildInfo)iinfo;
        boolean isConfigurationSet = info.setDefaultConfiguration("config toolchain-yy, tool-yy");
        PathConverterTest.assertTrue((String)"Configuration could not be set", (boolean)isConfigurationSet);
        IPathEntry[] pathEntries = info.getManagedBuildValues();
        PathConverterTest.assertEquals((String)"Unexpected number of path entries", (int)1, (int)pathEntries.length);
        IncludeEntry entry = (IncludeEntry)pathEntries[0];
        IPath path = entry.getIncludePath();
        String pathText = path.toString();
        PathConverterTest.assertEquals((String)"Unexpected value for include path", (String)"/usr/local/include", (String)pathText);
    }
}

