/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.core.tests;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.projectconverter.UpdateManagedProjectManager;
import org.eclipse.cdt.managedbuilder.testplugin.CTestPlugin;
import org.eclipse.cdt.managedbuilder.testplugin.ManagedBuildTestHelper;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.dialogs.IOverwriteQuery;

public class ManagedProjectUpdateTests
extends TestCase {
    public ManagedProjectUpdateTests(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(ManagedProjectUpdateTests.class.getName());
        suite.addTest((Test)new ManagedProjectUpdateTests("testProjectUpdate12_Update"));
        suite.addTest((Test)new ManagedProjectUpdateTests("testProjectUpdate21_Update"));
        suite.addTest((Test)new ManagedProjectUpdateTests("testProjectUpdate21CPP_Update"));
        return suite;
    }

    private File getVersionProjectsDir(String version) {
        return CTestPlugin.getFileInPlugin((IPath)new Path("resources/oldTypeProjects/" + version));
    }

    private IProject[] createVersionProjects(String version) {
        File file = this.getVersionProjectsDir(version);
        if (file == null) {
            ManagedProjectUpdateTests.fail((String)"Test project directory is missing.");
            return null;
        }
        File[] projectZips = file.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return !pathname.isDirectory();
            }
        });
        ArrayList<IProject> projectList = new ArrayList<IProject>(projectZips.length);
        int i = 0;
        while (i < projectZips.length) {
            try {
                IProject project;
                String projectName = projectZips[i].getName();
                if (projectName.endsWith(".zip") && (projectName = projectName.substring(0, projectName.length() - ".zip".length())).length() != 0 && (project = ManagedBuildTestHelper.createProject(projectName, projectZips[i], null, null)) != null) {
                    projectList.add(project);
                }
            }
            catch (Exception exception) {}
            ++i;
        }
        if (projectList.size() == 0) {
            ManagedProjectUpdateTests.fail((String)("No projects found in test project directory " + file.getName() + ".  The .zip file may be missing or corrupt."));
            return null;
        }
        return projectList.toArray(new IProject[projectList.size()]);
    }

    private void doTestProjectUpdate(String version, boolean updateProject, boolean overwriteBackupFiles, IPath[] files) {
        IOverwriteQuery queryALL = new IOverwriteQuery(){

            public String queryOverwrite(String file) {
                return "ALL";
            }
        };
        IOverwriteQuery queryNOALL = new IOverwriteQuery(){

            public String queryOverwrite(String file) {
                return "NOALL";
            }
        };
        UpdateManagedProjectManager.setBackupFileOverwriteQuery((IOverwriteQuery)(overwriteBackupFiles ? queryALL : queryNOALL));
        UpdateManagedProjectManager.setUpdateProjectQuery((IOverwriteQuery)(updateProject ? queryALL : queryNOALL));
        IProject[] projects = this.createVersionProjects(version);
        if (projects == null || projects.length == 0) {
            return;
        }
        int i = 0;
        while (i < projects.length) {
            final IProject curProject = projects[i];
            IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)curProject);
            boolean isCompatible = UpdateManagedProjectManager.isCompatibleProject((IManagedBuildInfo)info);
            ManagedProjectUpdateTests.assertTrue((boolean)isCompatible);
            if (isCompatible) {
                if (updateProject && (info == null || info.getManagedProject() == null || !info.getManagedProject().isValid())) {
                    ManagedProjectUpdateTests.fail((String)("the project \"" + curProject.getName() + "\" was not properly converted"));
                }
                IWorkspace wsp = ResourcesPlugin.getWorkspace();
                ISchedulingRule rule = wsp.getRuleFactory().buildRule();
                Job buildJob = new Job("project build job"){

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            curProject.build(10, null);
                        }
                        catch (CoreException e) {
                            ManagedProjectUpdateTests.fail((String)e.getStatus().getMessage());
                        }
                        catch (OperationCanceledException e) {
                            ManagedProjectUpdateTests.fail((String)("the project \"" + curProject.getName() + "\" build was cancelled, exception message: " + e.getMessage()));
                        }
                        return new Status(0, "org.eclipse.cdt.managedbuilder.core.tests", 0, new String(), null);
                    }
                };
                buildJob.setRule(rule);
                buildJob.schedule();
                try {
                    buildJob.join();
                }
                catch (InterruptedException e) {
                    ManagedProjectUpdateTests.fail((String)("the build job for the project \"" + curProject.getName() + "\" was interrupted, exception message: " + e.getMessage()));
                }
                IStatus status = buildJob.getResult();
                if (status.getCode() != 0) {
                    ManagedProjectUpdateTests.fail((String)("the build job for the project \"" + curProject.getName() + "\" failed, status message: " + status.getMessage()));
                }
                if (files != null && files.length > 0 && i == 0) {
                    String configName = info.getDefaultConfiguration().getName();
                    IPath buildDir = Path.fromOSString((String)configName);
                    ManagedBuildTestHelper.compareBenchmarks(curProject, buildDir, files);
                }
            }
            ++i;
        }
        i = 0;
        while (i < projects.length) {
            ManagedBuildTestHelper.removeProject(projects[i].getName());
            ++i;
        }
    }

    public void testProjectUpdate12_Update() {
        IPath[] makefiles = new IPath[]{Path.fromOSString((String)"makefile"), Path.fromOSString((String)"objects.mk"), Path.fromOSString((String)"sources.mk"), Path.fromOSString((String)"subdir.mk")};
        this.doTestProjectUpdate("1.2", true, true, makefiles);
    }

    public void testProjectUpdate20_Update() {
        IPath[] makefiles = new IPath[]{Path.fromOSString((String)"makefile"), Path.fromOSString((String)"objects.mk"), Path.fromOSString((String)"sources.mk"), Path.fromOSString((String)"subdir.mk")};
        this.doTestProjectUpdate("2.0", true, true, makefiles);
    }

    public void testProjectUpdate21_Update() {
        IPath[] makefiles = new IPath[]{Path.fromOSString((String)"makefile"), Path.fromOSString((String)"objects.mk"), Path.fromOSString((String)"sources.mk"), Path.fromOSString((String)"subdir.mk"), Path.fromOSString((String)"Functions/subdir.mk")};
        this.doTestProjectUpdate("2.1", true, true, makefiles);
    }

    public void testProjectUpdate21CPP_Update() {
        IPath[] makefiles = new IPath[]{Path.fromOSString((String)"makefile"), Path.fromOSString((String)"objects.mk"), Path.fromOSString((String)"sources.mk"), Path.fromOSString((String)"subdir.mk"), Path.fromOSString((String)"Functions/subdir.mk")};
        this.doTestProjectUpdate("2.1CPP", true, true, makefiles);
    }

    public void testProjectUpdate12_NoUpdate() {
        this.doTestProjectUpdate("1.2", false, true, null);
    }

    public void testProjectUpdate20_NoUpdate() {
        this.doTestProjectUpdate("2.0", false, true, null);
    }

    public void testProjectUpdate21_NoUpdate() {
        this.doTestProjectUpdate("2.1", false, true, null);
    }
}

