/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.core.tests;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.tests.ManagedBuildMacrosTests;
import org.eclipse.cdt.managedbuilder.core.tests.TestMacro;

public class ManagedBuildTCSupportedTest
extends TestCase {
    public ManagedBuildTCSupportedTest() {
    }

    public ManagedBuildTCSupportedTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(ManagedBuildTCSupportedTest.class.getName());
        suite.addTest((Test)new ManagedBuildTCSupportedTest("testIsSupported"));
        return suite;
    }

    public void testIsSupported() {
        ManagedBuildMacrosTests.createManagedProject("Merde");
        IManagedProject mproj = ManagedBuildMacrosTests.mproj;
        ManagedBuildTCSupportedTest.assertNotNull((Object)mproj);
        IProjectType pt = mproj.getProjectType();
        ManagedBuildTCSupportedTest.assertNotNull((Object)pt);
        IConfiguration[] cfgs = mproj.getConfigurations();
        ManagedBuildTCSupportedTest.assertNotNull((Object)cfgs);
        IToolChain tc = cfgs[0].getToolChain();
        ManagedBuildTCSupportedTest.assertNotNull((Object)tc);
        int i = 0;
        while (i < cfgs.length) {
            TestMacro.supported[i] = false;
            ++i;
        }
        i = 0;
        while (i < cfgs.length) {
            ManagedBuildTCSupportedTest.assertFalse((boolean)cfgs[i].getToolChain().isSupported());
            ManagedBuildTCSupportedTest.assertFalse((boolean)cfgs[i].isSupported());
            ++i;
        }
        ManagedBuildTCSupportedTest.assertFalse((boolean)pt.isSupported());
        TestMacro.supported[0] = true;
        ManagedBuildTCSupportedTest.assertTrue((boolean)tc.isSupported());
        ManagedBuildTCSupportedTest.assertTrue((boolean)cfgs[0].isSupported());
        i = 1;
        while (i < cfgs.length) {
            ManagedBuildTCSupportedTest.assertFalse((boolean)cfgs[i].isSupported());
            ++i;
        }
        ManagedBuildTCSupportedTest.assertTrue((boolean)pt.isSupported());
        i = 0;
        while (i < cfgs.length) {
            TestMacro.supported[i] = true;
            ++i;
        }
        i = 0;
        while (i < 4) {
            ManagedBuildTCSupportedTest.assertTrue((boolean)cfgs[i].isSupported());
            ++i;
        }
        ManagedBuildTCSupportedTest.assertFalse((boolean)cfgs[4].isSupported());
        ManagedBuildTCSupportedTest.assertTrue((boolean)pt.isSupported());
    }
}

