/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.core.tests;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.CIncludePathEntry;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICFolderDescription;
import org.eclipse.cdt.core.settings.model.ICLanguageSetting;
import org.eclipse.cdt.core.settings.model.ICLanguageSettingEntry;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionManager;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IFolderInfo;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.OptionStringValue;
import org.eclipse.cdt.managedbuilder.internal.core.Tool;
import org.eclipse.cdt.managedbuilder.testplugin.BuildSystemTestHelper;
import org.eclipse.cdt.managedbuilder.testplugin.CTestPlugin;
import org.eclipse.cdt.managedbuilder.testplugin.ManagedBuildTestHelper;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.dialogs.IOverwriteQuery;

public class BuildSystem40Tests
extends TestCase {
    private IProject p1;

    public static Test suite() {
        TestSuite suite = new TestSuite(BuildSystem40Tests.class);
        return suite;
    }

    public void test40() throws Exception {
        String[] makefiles = new String[]{"makefile", "objects.mk", "sources.mk", "subdir.mk"};
        IProject[] projects = this.createProjects("test_40", null, null, true);
        ICProjectDescriptionManager mngr = CoreModel.getDefault().getProjectDescriptionManager();
        ICProjectDescription des = mngr.getProjectDescription(projects[0]);
        ICConfigurationDescription cfgDes = des.getConfigurationByName("dbg 2");
        BuildSystem40Tests.assertNotNull((Object)cfgDes);
        des.setActiveConfiguration(cfgDes);
        mngr.setProjectDescription(projects[0], des);
        this.buildProjects(projects, makefiles);
        des = mngr.getProjectDescription(projects[0]);
        cfgDes = des.getConfigurationByName("Test 4.0 ConfigName.Dbg");
        BuildSystem40Tests.assertNotNull((Object)cfgDes);
        des.setActiveConfiguration(cfgDes);
        mngr.setProjectDescription(projects[0], des);
        this.buildProjects(projects, makefiles);
        des = mngr.getProjectDescription(projects[0]);
        cfgDes = des.getConfigurationByName("dbg 3");
        IConfiguration cfg = ManagedBuildManager.getConfigurationForDescription((ICConfigurationDescription)cfgDes);
        ICFolderDescription foDes = cfgDes.getRootFolderDescription();
        ICLanguageSetting ls = foDes.getLanguageSettingForFile("foo.cpp");
        IFolderInfo foInfo = cfg.getRootFolderInfo();
        Tool tool = (Tool)foInfo.getToolFromInputExtension("cpp");
        IOption option = tool.getOptionsOfType(4)[0];
        Object[] value = option.getBasicStringListValueElements();
        Object[] entries = ls.getSettingEntries(1);
        Object[] expectedEntries = new ICLanguageSettingEntry[]{new CIncludePathEntry("dbg 3/rel/path", 0), new CIncludePathEntry("proj/rel/path", 0), new CIncludePathEntry("/abs/path", 0), new CIncludePathEntry("c:/abs/path", 0), new CIncludePathEntry("/test_40/dir1/dir2/dir3", 8), new CIncludePathEntry("/test_40", 8), new CIncludePathEntry("D:\\docs\\incs", 0)};
        BuildSystem40Tests.assertTrue((boolean)Arrays.equals(entries, expectedEntries));
        ls.setSettingEntries(1, (ICLanguageSettingEntry[])entries);
        entries = ls.getSettingEntries(1);
        BuildSystem40Tests.assertTrue((boolean)Arrays.equals(entries, expectedEntries));
        option = tool.getOptionsOfType(4)[0];
        Object[] modifiedValue = option.getBasicStringListValueElements();
        BuildSystem40Tests.assertTrue((boolean)Arrays.equals(modifiedValue, value));
        ArrayList<Object> list = new ArrayList<Object>();
        list.addAll(Arrays.asList(entries));
        list.add(new CIncludePathEntry("E:\\tmp\\w", 0));
        entries = list.toArray(new ICLanguageSettingEntry[0]);
        ls.setSettingEntries(1, (ICLanguageSettingEntry[])entries);
        expectedEntries = entries;
        entries = ls.getSettingEntries(1);
        BuildSystem40Tests.assertTrue((boolean)Arrays.equals(entries, expectedEntries));
        list = new ArrayList();
        list.addAll(Arrays.asList(value));
        list.add(new OptionStringValue("\"E:\\tmp\\w\""));
        value = list.toArray(new OptionStringValue[0]);
        option = tool.getOptionsOfType(4)[0];
        modifiedValue = option.getBasicStringListValueElements();
        BuildSystem40Tests.assertTrue((boolean)Arrays.equals(value, modifiedValue));
        foDes = (ICFolderDescription)cfgDes.getResourceDescription((IPath)new Path("d1/d2"), true);
        foInfo = (IFolderInfo)cfg.getResourceInfo((IPath)new Path("d1/d2"), true);
        ls = foDes.getLanguageSettingForFile("foo.cpp");
        tool = (Tool)foInfo.getToolFromInputExtension("cpp");
        option = tool.getOptionsOfType(4)[0];
        expectedEntries = new ICLanguageSettingEntry[]{new CIncludePathEntry("dbg 3/d2_rel/path", 0), new CIncludePathEntry("d2_proj/rel/path", 0), new CIncludePathEntry("/d2_abs/path", 0), new CIncludePathEntry("c:/d2_abs/path", 0), new CIncludePathEntry("dbg 3/d1_rel/path", 0), new CIncludePathEntry("d1_proj/rel/path", 0), new CIncludePathEntry("/d1_abs/path", 0), new CIncludePathEntry("c:/d1_abs/path", 0), new CIncludePathEntry("dbg 3/rel/path", 0), new CIncludePathEntry("proj/rel/path", 0), new CIncludePathEntry("/abs/path", 0), new CIncludePathEntry("c:/abs/path", 0), new CIncludePathEntry("/test_40/dir1/dir2/dir3", 8), new CIncludePathEntry("/test_40", 8), new CIncludePathEntry("D:\\docs\\incs", 0), new CIncludePathEntry("E:\\tmp\\w", 0), new CIncludePathEntry("D:\\d1_docs\\incs", 0), new CIncludePathEntry("D:\\d2_docs\\incs", 0)};
        entries = ls.getSettingEntries(1);
        BuildSystemTestHelper.checkDiff(expectedEntries, entries);
        Object[] expectedValue = new OptionStringValue[]{new OptionStringValue("d2_rel/path"), new OptionStringValue("../d2_proj/rel/path"), new OptionStringValue("/d2_abs/path"), new OptionStringValue("c:/d2_abs/path"), new OptionStringValue("${IncludeDefaults}"), new OptionStringValue("\"D:\\d2_docs\\incs\"")};
        value = option.getBasicStringListValueElements();
        BuildSystemTestHelper.checkDiff(expectedValue, value);
        ls.setSettingEntries(1, (ICLanguageSettingEntry[])entries);
        value = option.getBasicStringListValueElements();
        entries = ls.getSettingEntries(1);
        BuildSystemTestHelper.checkDiff(expectedValue, value);
        BuildSystemTestHelper.checkDiff(expectedEntries, entries);
        list = new ArrayList<Object>(Arrays.asList(entries));
        list.remove(6);
        expectedEntries = list.toArray(new ICLanguageSettingEntry[0]);
        ls.setSettingEntries(1, list);
        option = tool.getOptionsOfType(4)[0];
        expectedValue = new OptionStringValue[]{new OptionStringValue("d2_rel/path"), new OptionStringValue("../d2_proj/rel/path"), new OptionStringValue("/d2_abs/path"), new OptionStringValue("c:/d2_abs/path"), new OptionStringValue("d1_rel/path"), new OptionStringValue("../d1_proj/rel/path"), new OptionStringValue("c:/d1_abs/path"), new OptionStringValue("rel/path"), new OptionStringValue("../proj/rel/path"), new OptionStringValue("/abs/path"), new OptionStringValue("c:/abs/path"), new OptionStringValue("\"${workspace_loc:/test_40/dir1/dir2/dir3}\""), new OptionStringValue("\"${workspace_loc:/test_40}\""), new OptionStringValue("\"D:\\docs\\incs\""), new OptionStringValue("\"E:\\tmp\\w\""), new OptionStringValue("\"D:\\d1_docs\\incs\""), new OptionStringValue("\"D:\\d2_docs\\incs\"")};
        value = option.getBasicStringListValueElements();
        BuildSystemTestHelper.checkDiff(expectedValue, value);
        entries = ls.getSettingEntries(1);
        BuildSystemTestHelper.checkDiff(expectedEntries, entries);
        foDes = cfgDes.getRootFolderDescription();
        foInfo = cfg.getRootFolderInfo();
        ls = foDes.getLanguageSettingForFile("foo.cpp");
        tool = (Tool)foInfo.getToolFromInputExtension("cpp");
        option = tool.getOptionsOfType(4)[0];
        list = new ArrayList<OptionStringValue>(Arrays.asList(option.getBasicStringListValueElements()));
        BuildSystem40Tests.assertTrue((boolean)list.remove(new OptionStringValue("${IncludeDefaults}")));
        list.add(0, new OptionStringValue("${IncludeDefaults}"));
        expectedValue = list.toArray(new OptionStringValue[0]);
        option = foInfo.setOption((IHoldsOptions)tool, option, list.toArray(new OptionStringValue[0]));
        value = option.getBasicStringListValueElements();
        expectedEntries = new ICLanguageSettingEntry[]{new CIncludePathEntry("dbg 3/rel/path", 0), new CIncludePathEntry("proj/rel/path", 0), new CIncludePathEntry("/abs/path", 0), new CIncludePathEntry("c:/abs/path", 0), new CIncludePathEntry("/test_40/dir1/dir2/dir3", 8), new CIncludePathEntry("/test_40", 8), new CIncludePathEntry("D:\\docs\\incs", 0), new CIncludePathEntry("E:\\tmp\\w", 0)};
        entries = ls.getSettingEntries(1);
        BuildSystemTestHelper.checkDiff(expectedValue, value);
        BuildSystemTestHelper.checkDiff(expectedEntries, entries);
        ls.setSettingEntries(1, (ICLanguageSettingEntry[])entries);
        BuildSystem40Tests.assertTrue((option == tool.getOptionsOfType(4)[0] ? 1 : 0) != 0);
        value = option.getBasicStringListValueElements();
        entries = ls.getSettingEntries(1);
        BuildSystemTestHelper.checkDiff(expectedValue, value);
        BuildSystemTestHelper.checkDiff(expectedEntries, entries);
        list = new ArrayList<OptionStringValue>(Arrays.asList(option.getBasicStringListValueElements()));
        BuildSystem40Tests.assertTrue((boolean)list.remove(new OptionStringValue("${IncludeDefaults}")));
        list.add(list.size(), new OptionStringValue("${IncludeDefaults}"));
        expectedValue = list.toArray(new OptionStringValue[0]);
        option = foInfo.setOption((IHoldsOptions)tool, option, list.toArray(new OptionStringValue[0]));
        value = option.getBasicStringListValueElements();
        expectedEntries = new ICLanguageSettingEntry[]{new CIncludePathEntry("dbg 3/rel/path", 0), new CIncludePathEntry("proj/rel/path", 0), new CIncludePathEntry("/abs/path", 0), new CIncludePathEntry("c:/abs/path", 0), new CIncludePathEntry("/test_40/dir1/dir2/dir3", 8), new CIncludePathEntry("/test_40", 8), new CIncludePathEntry("D:\\docs\\incs", 0), new CIncludePathEntry("E:\\tmp\\w", 0)};
        entries = ls.getSettingEntries(1);
        BuildSystemTestHelper.checkDiff(expectedValue, value);
        BuildSystemTestHelper.checkDiff(expectedEntries, entries);
        ls.setSettingEntries(1, (ICLanguageSettingEntry[])entries);
        BuildSystem40Tests.assertTrue((option == tool.getOptionsOfType(4)[0] ? 1 : 0) != 0);
        value = option.getBasicStringListValueElements();
        entries = ls.getSettingEntries(1);
        BuildSystemTestHelper.checkDiff(expectedValue, value);
        BuildSystemTestHelper.checkDiff(expectedEntries, entries);
        int i = 0;
        while (i < projects.length) {
            projects[i].delete(true, null);
            BuildSystem40Tests.assertNull((Object)mngr.getProjectDescription(projects[i]));
            BuildSystem40Tests.assertNull((Object)mngr.getProjectDescription(projects[i], false));
            BuildSystem40Tests.assertNull((Object)ManagedBuildManager.getBuildInfo((IResource)projects[i]));
            ++i;
        }
    }

    public void test40_pathconverter() throws Exception {
        IProject[] projects = this.createProjects("test_40_pathconverter", null, null, true);
        ICProjectDescriptionManager mngr = CoreModel.getDefault().getProjectDescriptionManager();
        ICProjectDescription des = mngr.getProjectDescription(projects[0]);
        ICConfigurationDescription cfgDes = des.getConfigurationByName("Test 4.0 ConfigName.Dbg");
        IConfiguration cfg = ManagedBuildManager.getConfigurationForDescription((ICConfigurationDescription)cfgDes);
        ICFolderDescription foDes = cfgDes.getRootFolderDescription();
        ICLanguageSetting ls = foDes.getLanguageSettingForFile("foo.cpp");
        IFolderInfo foInfo = cfg.getRootFolderInfo();
        Tool tool = (Tool)foInfo.getToolFromInputExtension("cpp");
        IOption option = tool.getOptionsOfType(4)[0];
        Object[] value = option.getBasicStringListValueElements();
        Object[] entries = ls.getSettingEntries(1);
        Object[] expectedValue = new OptionStringValue[]{new OptionStringValue("../rel"), new OptionStringValue("/abs")};
        Object[] expectedEntries = new ICLanguageSettingEntry[]{new CIncludePathEntry("rel", 0), new CIncludePathEntry("/test/abs", 0)};
        BuildSystemTestHelper.checkDiff(expectedValue, value);
        BuildSystemTestHelper.checkDiff(expectedEntries, entries);
        ls.setSettingEntries(1, (ICLanguageSettingEntry[])entries);
        BuildSystem40Tests.assertTrue((option == tool.getOptionsOfType(4)[0] ? 1 : 0) != 0);
        value = option.getBasicStringListValueElements();
        entries = ls.getSettingEntries(1);
        BuildSystemTestHelper.checkDiff(expectedValue, value);
        BuildSystemTestHelper.checkDiff(expectedEntries, entries);
        ArrayList<Object> list = new ArrayList<Object>();
        list.addAll(Arrays.asList(entries));
        list.add(new CIncludePathEntry("/test/another/abs", 0));
        expectedEntries = list.toArray(new ICLanguageSettingEntry[0]);
        expectedValue = new OptionStringValue[]{new OptionStringValue("../rel"), new OptionStringValue("/abs"), new OptionStringValue("/another/abs")};
        ls.setSettingEntries(1, list);
        BuildSystem40Tests.assertTrue((option == tool.getOptionsOfType(4)[0] ? 1 : 0) != 0);
        value = option.getBasicStringListValueElements();
        entries = ls.getSettingEntries(1);
        BuildSystemTestHelper.checkDiff(expectedValue, value);
        BuildSystemTestHelper.checkDiff(expectedEntries, entries);
        ls = foDes.getLanguageSettingForFile("foo.c");
        tool = (Tool)foInfo.getToolFromInputExtension("c");
        option = tool.getOptionsOfType(4)[0];
        value = option.getBasicStringListValueElements();
        entries = ls.getSettingEntries(1);
        expectedValue = new OptionStringValue[]{new OptionStringValue("../rel"), new OptionStringValue("/abs")};
        expectedEntries = new ICLanguageSettingEntry[]{new CIncludePathEntry("rel", 0), new CIncludePathEntry("/test/abs", 0)};
        BuildSystemTestHelper.checkDiff(expectedValue, value);
        BuildSystemTestHelper.checkDiff(expectedEntries, entries);
        ls.setSettingEntries(1, (ICLanguageSettingEntry[])entries);
        BuildSystem40Tests.assertTrue((option == tool.getOptionsOfType(4)[0] ? 1 : 0) != 0);
        value = option.getBasicStringListValueElements();
        entries = ls.getSettingEntries(1);
        BuildSystemTestHelper.checkDiff(expectedValue, value);
        BuildSystemTestHelper.checkDiff(expectedEntries, entries);
        list = new ArrayList();
        list.addAll(Arrays.asList(entries));
        list.add(new CIncludePathEntry("/another/abs", 0));
        expectedEntries = new ICLanguageSettingEntry[]{new CIncludePathEntry("rel", 0), new CIncludePathEntry("/test/abs", 0), new CIncludePathEntry("/test/another/abs", 0)};
        expectedValue = new OptionStringValue[]{new OptionStringValue("../rel"), new OptionStringValue("/abs"), new OptionStringValue("/another/abs")};
        ls.setSettingEntries(1, list);
        BuildSystem40Tests.assertTrue((option == tool.getOptionsOfType(4)[0] ? 1 : 0) != 0);
        value = option.getBasicStringListValueElements();
        entries = ls.getSettingEntries(1);
        BuildSystemTestHelper.checkDiff(expectedValue, value);
        BuildSystemTestHelper.checkDiff(expectedEntries, entries);
        int i = 0;
        while (i < projects.length) {
            projects[i].delete(true, null);
            BuildSystem40Tests.assertNull((Object)mngr.getProjectDescription(projects[i]));
            BuildSystem40Tests.assertNull((Object)mngr.getProjectDescription(projects[i], false));
            BuildSystem40Tests.assertNull((Object)ManagedBuildManager.getBuildInfo((IResource)projects[i]));
            ++i;
        }
    }

    private void doTest(String projName, String cfgName) throws Exception {
        String[] makefiles = new String[]{"makefile", "objects.mk", "sources.mk", "subdir.mk"};
        IProject[] projects = this.createProjects(projName, null, null, true);
        ICProjectDescriptionManager mngr = CoreModel.getDefault().getProjectDescriptionManager();
        ICProjectDescription d = mngr.getProjectDescription(projects[0]);
        ICConfigurationDescription cfg = d.getConfigurationByName(cfgName);
        BuildSystem40Tests.assertNotNull((Object)cfg);
        d.setActiveConfiguration(cfg);
        mngr.setProjectDescription(projects[0], d);
        this.buildProjects(projects, makefiles);
    }

    private void buildProjects(IProject[] projects, String[] files) {
        this.buildProjectsWorker(projects, files, true);
    }

    private void buildProjectsWorker(IProject[] projects, String[] files, boolean compareBenchmark) {
        if (projects == null || projects.length == 0) {
            return;
        }
        int i = 0;
        while (i < projects.length) {
            IProject curProject = projects[i];
            IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)curProject);
            boolean isCompatible = true;
            if (isCompatible) {
                try {
                    curProject.build(10, null);
                }
                catch (CoreException e) {
                    BuildSystem40Tests.fail((String)e.getStatus().getMessage());
                }
                catch (OperationCanceledException e) {
                    BuildSystem40Tests.fail((String)("the project \"" + curProject.getName() + "\" build was cancelled, exception message: " + e.getMessage()));
                }
                if (files != null && files.length > 0 && i == 0) {
                    String configName = info.getDefaultConfiguration().getName();
                    IPath buildDir = Path.fromOSString((String)configName);
                    if (compareBenchmark) {
                        ManagedBuildTestHelper.compareBenchmarks(curProject, buildDir, files);
                    }
                }
            }
            ++i;
        }
    }

    private IProject[] createProjects(String projName, IPath location, String projectTypeId, boolean containsZip) {
        new IOverwriteQuery(){

            public String queryOverwrite(String file) {
                return "ALL";
            }
        };
        new IOverwriteQuery(){

            public String queryOverwrite(String file) {
                return "NOALL";
            }
        };
        IProject[] projects = this.createProject(projName, location, projectTypeId, containsZip);
        return projects;
    }

    private IProject[] createProject(String projName, IPath location, String projectTypeId, boolean containsZip) {
        ArrayList<IProject> projectList = null;
        if (containsZip) {
            File testDir = CTestPlugin.getFileInPlugin((IPath)new Path("resources/test40Projects/" + projName));
            if (testDir == null) {
                BuildSystem40Tests.fail((String)("Test project directory " + projName + " is missing."));
                return null;
            }
            File[] projectZips = testDir.listFiles(new FileFilter(){

                public boolean accept(File pathname) {
                    return !pathname.isDirectory();
                }
            });
            projectList = new ArrayList(projectZips.length);
            int i = 0;
            while (i < projectZips.length) {
                try {
                    IProject project;
                    String projectName = projectZips[i].getName();
                    if (projectName.endsWith(".zip") && (projectName = projectName.substring(0, projectName.length() - ".zip".length())).length() != 0 && (project = ManagedBuildTestHelper.createProject(projectName, projectZips[i], location, projectTypeId)) != null) {
                        projectList.add(project);
                    }
                }
                catch (Exception exception) {}
                ++i;
            }
            if (projectList.size() == 0) {
                BuildSystem40Tests.fail((String)("No projects found in test project directory " + testDir.getName() + ".  The .zip file may be missing or corrupt."));
                return null;
            }
        } else {
            try {
                IProject project = ManagedBuildTestHelper.createProject(projName, null, location, projectTypeId);
                if (project != null) {
                    projectList = new ArrayList<IProject>(1);
                }
                projectList.add(project);
            }
            catch (Exception exception) {}
        }
        return projectList.toArray(new IProject[projectList.size()]);
    }
}

