/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core;

import java.util.Map;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.ICBreakpointListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;

public class CBreakpointNotifier
implements ICBreakpointListener {
    private static CBreakpointNotifier fInstance;

    public static CBreakpointNotifier getInstance() {
        if (fInstance == null) {
            fInstance = new CBreakpointNotifier();
        }
        return fInstance;
    }

    public boolean installingBreakpoint(IDebugTarget target, IBreakpoint breakpoint) {
        boolean result = true;
        Object[] listeners = CDebugCorePlugin.getDefault().getCBreakpointListeners();
        int i = 0;
        while (i < listeners.length) {
            if (!((ICBreakpointListener)listeners[i]).installingBreakpoint(target, breakpoint)) {
                result = false;
            }
            ++i;
        }
        return result;
    }

    public void breakpointInstalled(IDebugTarget target, IBreakpoint breakpoint) {
        Object[] listeners = CDebugCorePlugin.getDefault().getCBreakpointListeners();
        int i = 0;
        while (i < listeners.length) {
            ((ICBreakpointListener)listeners[i]).breakpointInstalled(target, breakpoint);
            ++i;
        }
    }

    public void breakpointChanged(IDebugTarget target, IBreakpoint breakpoint, Map attributes) {
        Object[] listeners = CDebugCorePlugin.getDefault().getCBreakpointListeners();
        int i = 0;
        while (i < listeners.length) {
            ((ICBreakpointListener)listeners[i]).breakpointChanged(target, breakpoint, attributes);
            ++i;
        }
    }

    public void breakpointsRemoved(IDebugTarget target, IBreakpoint[] breakpoints) {
        Object[] listeners = CDebugCorePlugin.getDefault().getCBreakpointListeners();
        int i = 0;
        while (i < listeners.length) {
            ((ICBreakpointListener)listeners[i]).breakpointsRemoved(target, breakpoints);
            ++i;
        }
    }
}

