/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.core.executables;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.debug.core.executables.ExecutablesManager;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.ExternalTranslationUnit;
import org.eclipse.cdt.internal.core.model.TranslationUnit;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;

public class Executable
extends PlatformObject {
    private final IPath executablePath;
    private final IProject project;
    private final String name;
    private final IResource resource;
    private final Map<ITranslationUnit, String> remappedPaths;
    private final ArrayList<ITranslationUnit> sourceFiles;
    private boolean refreshSourceFiles;

    public static boolean isExecutableFile(IPath path) {
        if (path.toFile().isDirectory()) {
            return false;
        }
        String ext = path.getFileExtension();
        if (ext != null) {
            boolean isNumber = true;
            int i = 0;
            while (i < ext.length()) {
                if (!Character.isDigit(ext.charAt(i))) {
                    isNumber = false;
                    break;
                }
                ++i;
            }
            if (!isNumber) {
                boolean isBinary = false;
                IContentTypeManager ctm = Platform.getContentTypeManager();
                IContentType ctbin = ctm.getContentType("org.eclipse.cdt.core.binaryFile");
                IContentType[] cts = ctm.findContentTypesFor(path.toFile().getName());
                int i2 = 0;
                while (!isBinary && i2 < cts.length) {
                    isBinary = cts[i2].isKindOf(ctbin);
                    ++i2;
                }
                if (!isBinary) {
                    return false;
                }
            }
        }
        return true;
    }

    public boolean equals(Object arg0) {
        if (arg0 instanceof Executable) {
            Executable exe = (Executable)((Object)arg0);
            return exe.getPath().equals((Object)this.getPath());
        }
        return super.equals(arg0);
    }

    public IPath getPath() {
        return this.executablePath;
    }

    public IProject getProject() {
        return this.project;
    }

    public Executable(IPath path, IProject project, IResource resource) {
        this.executablePath = path;
        this.project = project;
        this.name = new File(path.toOSString()).getName();
        this.resource = resource;
        this.remappedPaths = new HashMap<ITranslationUnit, String>();
        this.sourceFiles = new ArrayList();
        this.refreshSourceFiles = true;
    }

    public IResource getResource() {
        return this.resource;
    }

    public String toString() {
        return this.executablePath.toString();
    }

    public String getName() {
        return this.name;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(IResource.class)) {
            if (this.getResource() != null) {
                return this.getResource();
            }
            return this.getProject();
        }
        return super.getAdapter(adapter);
    }

    public TranslationUnit[] getSourceFiles(IProgressMonitor monitor) {
        if (!this.refreshSourceFiles) {
            return this.sourceFiles.toArray(new TranslationUnit[this.sourceFiles.size()]);
        }
        this.remappedPaths.clear();
        this.sourceFiles.clear();
        CModelManager factory = CModelManager.getDefault();
        ICProject cproject = factory.create(this.project);
        String[] symReaderSources = ExecutablesManager.getExecutablesManager().getSourceFiles(this, monitor);
        if (symReaderSources != null && symReaderSources.length > 0) {
            int i = 0;
            while (i < symReaderSources.length) {
                String id;
                String filename;
                String orgPath = filename = symReaderSources[i];
                filename = ExecutablesManager.getExecutablesManager().remapSourceFile(this, filename);
                boolean fileExists = false;
                try {
                    File file = new File(filename);
                    fileExists = file.exists();
                    if (fileExists) {
                        filename = file.getCanonicalPath();
                    } else if (filename.startsWith(".")) {
                        file = new File(this.executablePath.removeLastSegments(1).toOSString(), filename);
                        filename = file.getCanonicalPath();
                    }
                }
                catch (IOException iOException) {}
                IFile wkspFile = null;
                IFile sourceFile = this.getProject().getFile(filename);
                Path sourcePath = new Path(filename);
                if (fileExists) {
                    if (sourceFile.exists()) {
                        wkspFile = sourceFile;
                    } else {
                        IFile[] filesInWP = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation((IPath)sourcePath);
                        int j = 0;
                        while (j < filesInWP.length) {
                            if (filesInWP[j].isAccessible()) {
                                wkspFile = filesInWP[j];
                                break;
                            }
                            ++j;
                        }
                    }
                }
                if ((id = CoreModel.getRegistedContentTypeId((IProject)sourceFile.getProject(), (String)sourceFile.getName())) != null) {
                    Object tu = wkspFile != null ? new TranslationUnit((ICElement)cproject, wkspFile, id) : new ExternalTranslationUnit((ICElement)cproject, URIUtil.toURI((IPath)sourcePath), id);
                    this.sourceFiles.add((ITranslationUnit)tu);
                    if (!orgPath.equals(filename)) {
                        this.remappedPaths.put((ITranslationUnit)tu, orgPath);
                    }
                }
                ++i;
            }
        }
        this.refreshSourceFiles = false;
        return this.sourceFiles.toArray(new TranslationUnit[this.sourceFiles.size()]);
    }

    public void setRefreshSourceFiles(boolean refreshSourceFiles) {
        this.refreshSourceFiles = refreshSourceFiles;
    }

    public String getOriginalLocation(ITranslationUnit tu) {
        String orgLocation = this.remappedPaths.get(tu);
        if (orgLocation == null) {
            orgLocation = tu.getLocation().toOSString();
        }
        return orgLocation;
    }
}

