/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.sourcelookup;

import java.util.Iterator;
import org.eclipse.cdt.debug.internal.ui.sourcelookup.SourceContainerAction;
import org.eclipse.cdt.debug.internal.ui.sourcelookup.SourceLookupUIMessages;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceContainerType;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.sourcelookup.ISourceContainerBrowser;
import org.eclipse.jface.viewers.IStructuredSelection;

public class EditContainerAction
extends SourceContainerAction {
    private ISourceLookupDirector fDirector;
    private ISourceContainer[] fContainers;
    private ISourceContainerBrowser fBrowser;

    public EditContainerAction() {
        super(SourceLookupUIMessages.getString("EditContainerAction.0"));
    }

    public void run() {
        ISourceContainer[] replacements = this.fBrowser.editSourceContainers(this.getShell(), this.fDirector, this.fContainers);
        int j = 0;
        ISourceContainer[] existing = this.getViewer().getEntries();
        int i = 0;
        while (i < existing.length && j < replacements.length) {
            ISourceContainer container = existing[i];
            ISourceContainer toBeReplaced = this.fContainers[j];
            if (container.equals(toBeReplaced)) {
                existing[i] = replacements[j];
                ++j;
            }
            ++i;
        }
        this.getViewer().setEntries(existing);
    }

    public void setSourceLookupDirector(ISourceLookupDirector director) {
        this.fDirector = director;
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        if (selection == null || selection.isEmpty()) {
            return false;
        }
        if (this.getViewer().getTree().getSelection()[0].getParentItem() == null) {
            this.fContainers = new ISourceContainer[selection.size()];
            Iterator iterator = selection.iterator();
            ISourceContainer container = (ISourceContainer)iterator.next();
            ISourceContainerType type = container.getType();
            this.fContainers[0] = container;
            int i = 1;
            while (iterator.hasNext()) {
                this.fContainers[i] = container = (ISourceContainer)iterator.next();
                ++i;
                if (container.getType().equals(type)) continue;
                return false;
            }
            this.fBrowser = DebugUITools.getSourceContainerBrowser((String)type.getId());
            if (this.fBrowser != null) {
                return this.fBrowser.canEditSourceContainers(this.fDirector, this.fContainers);
            }
        }
        return false;
    }
}

