/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.elements.adapters;

import java.math.BigInteger;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.model.ICLineBreakpoint;
import org.eclipse.cdt.debug.core.model.ICStackFrame;
import org.eclipse.cdt.debug.core.model.IDisassemblyInstruction;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.cdt.debug.internal.core.model.DisassemblyRetrieval;
import org.eclipse.cdt.debug.internal.ui.views.disassembly.DisassemblyInstructionPointerAnnotation;
import org.eclipse.cdt.debug.ui.disassembly.IDocumentElementAnnotationProvider;
import org.eclipse.cdt.debug.ui.disassembly.IDocumentElementAnnotationUpdate;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.ui.texteditor.MarkerAnnotation;

public class DisassemblyElementAnnotationProvider
implements IDocumentElementAnnotationProvider {
    public void update(final IDocumentElementAnnotationUpdate[] updates) {
        Job job = new Job("Annotations update"){

            protected IStatus run(IProgressMonitor monitor) {
                int i = 0;
                while (i < updates.length) {
                    IDocumentElementAnnotationUpdate update = updates[i];
                    if (!update.isCanceled()) {
                        DisassemblyElementAnnotationProvider.this.retrieveAnnotations(update);
                    }
                    update.done();
                    ++i;
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    protected void retrieveAnnotations(IDocumentElementAnnotationUpdate update) {
        this.retrieveInstructionPointers(update);
        this.retrieveBreakpoints(update);
    }

    private void retrieveInstructionPointers(IDocumentElementAnnotationUpdate update) {
        ICStackFrame frame;
        BigInteger frameAddress;
        BigInteger address;
        Object element;
        DisassemblyRetrieval retrieval;
        Object input;
        Object root = update.getRootElement();
        if (root instanceof DisassemblyRetrieval && (input = (retrieval = (DisassemblyRetrieval)root).getInput()) instanceof ICStackFrame && (element = update.getElement()) instanceof IDisassemblyInstruction && (address = ((IDisassemblyInstruction)element).getAdress().getValue()).equals(frameAddress = (frame = (ICStackFrame)input).getAddress().getValue())) {
            IThread thread = frame.getThread();
            try {
                boolean topFrame = frame == thread.getTopStackFrame();
                update.addAnnotation(new DisassemblyInstructionPointerAnnotation(frame, topFrame));
            }
            catch (DebugException debugException) {}
        }
    }

    private void retrieveBreakpoints(IDocumentElementAnnotationUpdate update) {
        IBreakpoint[] breakpoints;
        IBreakpoint[] iBreakpointArray = breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints(CDebugCorePlugin.getUniqueIdentifier());
        int n = breakpoints.length;
        int n2 = 0;
        while (n2 < n) {
            IBreakpoint b = iBreakpointArray[n2];
            if (b instanceof ICLineBreakpoint) {
                try {
                    Object element;
                    Object root = update.getRootElement();
                    if (root instanceof DisassemblyRetrieval && (element = update.getElement()) instanceof IDisassemblyInstruction) {
                        IDisassemblyInstruction instruction = (IDisassemblyInstruction)element;
                        BigInteger address = ((CDebugTarget)((DisassemblyRetrieval)root).getDebugTarget()).getBreakpointAddress((ICLineBreakpoint)b).getValue();
                        BigInteger instrAddress = instruction.getAdress().getValue();
                        if (address != null && instrAddress != null && instrAddress.compareTo(address) == 0) {
                            update.addAnnotation((Annotation)new MarkerAnnotation(b.getMarker()));
                        }
                    }
                }
                catch (CoreException coreException) {
                }
                catch (NumberFormatException numberFormatException) {}
            }
            ++n2;
        }
    }
}

