/*
 * Decompiled with CFR 0.152.
 */
package cbviewer;

import cbviewer.CBViewer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class CBPage
extends JPanel {
    private JLabel jLabel1;
    private boolean scaleing = false;
    private boolean notimage = false;
    private Dimension originalSize = new Dimension(0, 0);
    private CBViewer theApp;
    private String defaultImage = "cbviewer08.jpg";
    private String notAnImage = "notanimage.png";
    private FileInputStream fin;
    private ZipInputStream zin;
    private ImageInputStream iin;
    private ZipEntry currentEntry;
    private ImageReader imageReader;
    private BufferedImage tempimage;
    private BufferedImage buffimage = null;
    private ImageIcon anIcon = new ImageIcon();
    private ImageIcon unScaledIcon = new ImageIcon();

    public CBPage(CBViewer cBViewer) {
        this.initComponents();
        this.theApp = cBViewer;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.setLayout(new BorderLayout());
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setIcon(new ImageIcon(this.getClass().getResource(this.defaultImage)));
        this.add((Component)this.jLabel1, "Center");
        this.jLabel1.getAccessibleContext().setAccessibleName("cbpage01");
        this.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                CBPage.this.handleKeyPressed(keyEvent);
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }
        });
    }

    public void handleKeyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 38) {
            // empty if block
        }
        if (keyEvent.getKeyCode() == 40) {
            // empty if block
        }
        if (keyEvent.getKeyCode() == 39) {
            // empty if block
        }
        if (keyEvent.getKeyCode() == 37) {
            // empty if block
        }
        if (keyEvent.getKeyCode() == 32) {
            if (this.theApp.pageStuff.getCurrentPage() != this.theApp.pageStuff.getLastPage()) {
                this.theApp.pageStuff.setCurrentPage(this.theApp.pageStuff.getCurrentPage() + 1);
            }
            this.theApp.controls.processButtons();
        }
        if (keyEvent.getKeyCode() == 66) {
            if (this.theApp.pageStuff.getCurrentPage() != 0) {
                this.theApp.pageStuff.setCurrentPage(this.theApp.pageStuff.getCurrentPage() - 1);
            }
            this.theApp.controls.processButtons();
        }
        if (keyEvent.getKeyCode() == 83) {
            if (this.theApp.pageStuff.getScale()) {
                this.theApp.pageStuff.setScale(false);
            } else {
                this.theApp.pageStuff.setScale(true);
            }
            this.theApp.pageStuff.setCurrentPage(this.theApp.pageStuff.getCurrentPage());
            this.theApp.controls.processButtons();
        }
        if (keyEvent.getKeyCode() == 77) {
            this.theApp.fileStuff.getNextArchive();
            this.theApp.controls.processButtons();
        }
        if (keyEvent.getKeyCode() == 78) {
            this.theApp.fileStuff.getPreviousArchive();
            this.theApp.controls.processButtons();
        }
    }

    @Override
    public boolean isFocusable() {
        return true;
    }

    public void setPage(String string) {
        Object object;
        if (!this.theApp.fileStuff.getZipFlag()) {
            try {
                this.fin = new FileInputStream(string);
                this.iin = ImageIO.createImageInputStream(this.fin);
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println("Problem finding: " + string);
                System.err.println("Error: " + fileNotFoundException);
            }
            catch (IOException iOException) {
                System.err.println("Problem with IO in CBPage: " + iOException);
            }
            this.imageReader = null;
            this.tempimage = null;
            object = null;
            if (string.toLowerCase().endsWith("jpg") || string.toLowerCase().endsWith("jpeg")) {
                object = ImageIO.getImageReadersBySuffix("jpg");
                this.imageReader = object.next();
            }
            if (string.toLowerCase().endsWith("png")) {
                object = ImageIO.getImageReadersBySuffix("png");
                this.imageReader = object.next();
            }
            if (string.toLowerCase().endsWith("bmp")) {
                object = ImageIO.getImageReadersBySuffix("bmp");
                this.imageReader = object.next();
            }
            if (object == null) {
                System.err.println("This is not an image file:" + string);
                return;
            }
            this.imageReader.setInput(this.iin, false);
            try {
                this.tempimage = this.imageReader.read(0);
            }
            catch (IOException iOException) {
                System.err.println("IO problem reading image file: " + iOException);
            }
            this.jLabel1.setIcon(null);
            this.anIcon.setImage(this.tempimage);
            this.jLabel1.setIcon(this.anIcon);
            this.imageReader = null;
            object = null;
            this.tempimage.flush();
            this.tempimage = null;
            try {
                this.iin.flush();
                this.fin.close();
                this.iin.close();
            }
            catch (IOException iOException) {
                System.err.println("Problem closing streams: " + iOException);
            }
        } else {
            if (this.buffimage == null) {
                System.out.println("No image in buffer, loading buffer");
                if (!this.loadBuffImage(string)) {
                    return;
                }
            }
            this.jLabel1.setIcon(null);
            this.anIcon.setImage(this.buffimage);
            this.jLabel1.setIcon(this.anIcon);
            this.theApp.frame.getContentPane().validate();
        }
        this.originalSize = this.jLabel1.getSize();
        if (this.scaleing) {
            this.unScaledIcon.setImage(this.anIcon.getImage());
            object = this.unScaledIcon.getImage().getScaledInstance(-1, this.theApp.scrollPane.getViewport().getExtentSize().height, 8);
            this.jLabel1.setIcon(null);
            this.anIcon.setImage((Image)object);
            this.jLabel1.setIcon(this.anIcon);
            this.theApp.frame.getContentPane().validate();
        }
        this.repaint();
        this.requestFocus();
    }

    public boolean loadBuffImage(String string) {
        if (this.theApp.fileStuff.getZipFlag()) {
            this.fin = null;
            this.iin = null;
            this.zin = null;
            try {
                this.fin = new FileInputStream(this.theApp.fileStuff.getZipName());
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println("Zip File not found in CBPage : " + fileNotFoundException);
            }
            this.zin = new ZipInputStream(this.fin);
            this.currentEntry = null;
            try {
                this.currentEntry = this.zin.getNextEntry();
                while (!this.currentEntry.getName().equals(string)) {
                    this.zin.closeEntry();
                    this.currentEntry = this.zin.getNextEntry();
                }
            }
            catch (IOException iOException) {
                System.err.println("problem with zip file in CBPage : " + iOException);
            }
            try {
                this.iin = ImageIO.createImageInputStream(this.zin);
            }
            catch (IOException iOException) {
                System.err.println("Problem with IO in CBPage : " + iOException);
            }
            this.imageReader = null;
            this.buffimage = null;
            Iterator<ImageReader> iterator = null;
            if (this.currentEntry.getName().toLowerCase().endsWith("jpg") || this.currentEntry.getName().toLowerCase().endsWith("jpeg")) {
                iterator = ImageIO.getImageReadersBySuffix("jpg");
                this.imageReader = iterator.next();
            }
            if (this.currentEntry.getName().toLowerCase().endsWith("png")) {
                iterator = ImageIO.getImageReadersBySuffix("png");
                this.imageReader = iterator.next();
            }
            if (iterator == null) {
                System.err.println("This file is not a bmp, jpg or png file");
                System.err.println(this.currentEntry.getName());
                this.jLabel1.setIcon(new ImageIcon(CBPage.class.getResource(this.notAnImage)));
                return false;
            }
            this.imageReader.setInput(this.iin, false);
            try {
                this.buffimage = this.imageReader.read(0);
            }
            catch (IOException iOException) {
                System.err.println("Problem with IO in CBPage : " + iOException);
            }
            this.imageReader = null;
            iterator = null;
            try {
                this.iin.flush();
                this.zin.closeEntry();
                this.fin.close();
                this.zin.close();
                this.iin.close();
            }
            catch (IOException iOException) {
                System.err.println("Problem closing streams in CBPage while loading buffimage: " + iOException);
                return false;
            }
            return true;
        }
        return false;
    }

    public void setDefault() {
        System.err.println(this.defaultImage);
        this.jLabel1.setIcon(new ImageIcon(CBPage.class.getResource(this.defaultImage)));
        this.originalSize = this.jLabel1.getSize();
        this.theApp.utils.setMainTitle("");
        this.repaint();
    }

    public void setScale(boolean bl) {
        this.scaleing = bl;
    }

    public boolean getScale() {
        return this.scaleing;
    }

    public void clearBuffImage() {
        this.buffimage = null;
    }
}

