/*
 * Decompiled with CFR 0.152.
 */
package cbviewer;

import cbviewer.CBViewer;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;

public class CBFileStuff {
    CBViewer theApp;
    private String archiveDir = null;
    private String[] archives;
    private int currArchiveNumber = 0;
    private boolean zipFlag = false;
    private boolean tempDirFlag = false;
    private File tempDir;
    public ArrayList zipEntries = new ArrayList();

    public CBFileStuff(CBViewer cBViewer) {
        this.theApp = cBViewer;
    }

    public void setArchiveDir(String string) {
        this.archiveDir = string;
        this.populateArchiveList();
    }

    public String getArchiveDir() {
        return this.archiveDir;
    }

    private void populateArchiveList() {
        File file = new File(this.getArchiveDir());
        this.archives = null;
        this.archives = file.list();
        Arrays.sort(this.archives, String.CASE_INSENSITIVE_ORDER);
    }

    public void getNextArchive() {
        if (this.currArchiveNumber != this.archives.length - 1) {
            ++this.currArchiveNumber;
            this.theApp.loader.openArchive(1, this.getArchiveDir() + System.getProperty("file.separator") + this.archives[this.currArchiveNumber]);
        }
    }

    public void getPreviousArchive() {
        if (this.currArchiveNumber != 0) {
            --this.currArchiveNumber;
            this.theApp.loader.openArchive(1, this.getArchiveDir() + System.getProperty("file.separator") + this.archives[this.currArchiveNumber]);
        }
    }

    public void setCurrentArchive(String string) {
        for (int i = 0; i < this.archives.length; ++i) {
            if (!string.equals(this.archives[i])) continue;
            this.currArchiveNumber = i;
        }
    }

    public String getCurrentArchive() {
        return this.archives[this.currArchiveNumber];
    }

    protected boolean isFirstArchive() {
        return this.currArchiveNumber == 0;
    }

    protected boolean isLastArchive() {
        return this.currArchiveNumber == this.archives.length - 1;
    }

    protected boolean delDir(File file) {
        if (!file.exists()) {
            System.err.println("Doesn't exist : " + file);
            return false;
        }
        if (!file.isDirectory()) {
            System.err.println("Not a directory : " + file);
            return false;
        }
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            System.out.println("del : " + fileArray[i]);
            if (fileArray[i].isDirectory()) {
                this.delDir(fileArray[i]);
                continue;
            }
            fileArray[i].delete();
        }
        file.delete();
        return true;
    }

    public boolean getZipFlag() {
        return this.zipFlag;
    }

    public void setZipFlag(boolean bl) {
        this.zipFlag = bl;
    }

    public String getTempPath() {
        return this.tempDir.getPath();
    }

    public boolean getTempDirFlag() {
        return this.tempDirFlag;
    }

    public void setTempDirFlag(boolean bl) {
        this.tempDirFlag = bl;
    }

    public File getZipName() {
        return (File)this.zipEntries.get(0);
    }

    public File getTempDir() {
        return this.tempDir;
    }

    public void setTempDir(File file) {
        this.tempDir = file;
    }
}

