/*
 * Decompiled with CFR 0.152.
 */
package cbviewer;

import cbviewer.CBViewer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class CBControls
extends JPanel {
    private JButton prevPageButton;
    private JButton firstPageButton;
    private JButton lastPageButton;
    private JButton nextPageButton;
    private JButton prevArchiveButton;
    private JButton nextArchiveButton;
    private JButton scaleButton;
    private JLabel fileLabel;
    private String defaultLabel = new String("No File Loaded");
    private CBViewer theApp;
    private ImageIcon[] buttons = new ImageIcon[24];

    public CBControls(CBViewer cBViewer) {
        this.initComponents();
        this.theApp = cBViewer;
    }

    private void initComponents() {
        this.loadButtonIcons();
        this.prevPageButton = new JButton();
        this.firstPageButton = new JButton();
        this.prevArchiveButton = new JButton();
        this.lastPageButton = new JButton();
        this.nextPageButton = new JButton();
        this.nextArchiveButton = new JButton();
        this.scaleButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.setMaximumSize(new Dimension(50, 60));
        this.setMinimumSize(new Dimension(50, 60));
        this.setPreferredSize(new Dimension(50, 60));
        this.prevArchiveButton.setIcon(this.buttons[0]);
        this.prevArchiveButton.setPressedIcon(this.buttons[1]);
        this.prevArchiveButton.setDisabledIcon(this.buttons[2]);
        this.prevArchiveButton.setBorderPainted(false);
        this.prevArchiveButton.setToolTipText("Go to Previous archive");
        this.prevArchiveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CBControls.this.previousArchiveButtonPressed(actionEvent);
            }
        });
        this.add((Component)this.prevArchiveButton, new GridBagConstraints());
        this.prevPageButton.setIcon(this.buttons[3]);
        this.prevPageButton.setPressedIcon(this.buttons[4]);
        this.prevPageButton.setDisabledIcon(this.buttons[5]);
        this.prevPageButton.setBorderPainted(false);
        this.prevPageButton.setToolTipText("Go to previous page");
        this.prevPageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CBControls.this.previousButtonPressed(actionEvent);
            }
        });
        this.add((Component)this.prevPageButton, new GridBagConstraints());
        this.firstPageButton.setIcon(this.buttons[6]);
        this.firstPageButton.setPressedIcon(this.buttons[7]);
        this.firstPageButton.setDisabledIcon(this.buttons[8]);
        this.firstPageButton.setBorderPainted(false);
        this.firstPageButton.setToolTipText("Go to first page");
        this.firstPageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CBControls.this.firstButtonPressed(actionEvent);
            }
        });
        this.add((Component)this.firstPageButton, new GridBagConstraints());
        this.scaleButton.setIcon(this.buttons[9]);
        this.scaleButton.setPressedIcon(this.buttons[10]);
        this.scaleButton.setDisabledIcon(this.buttons[11]);
        this.scaleButton.setBorderPainted(false);
        this.scaleButton.setToolTipText("Scale page to screen");
        this.scaleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CBControls.this.scaleButtonPressed(actionEvent);
            }
        });
        this.add((Component)this.scaleButton, new GridBagConstraints());
        this.lastPageButton.setIcon(this.buttons[15]);
        this.lastPageButton.setPressedIcon(this.buttons[16]);
        this.lastPageButton.setDisabledIcon(this.buttons[17]);
        this.lastPageButton.setBorderPainted(false);
        this.lastPageButton.setToolTipText("Go to last page");
        this.lastPageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CBControls.this.lastButtonPressed(actionEvent);
            }
        });
        this.add((Component)this.lastPageButton, new GridBagConstraints());
        this.nextPageButton.setIcon(this.buttons[18]);
        this.nextPageButton.setPressedIcon(this.buttons[19]);
        this.nextPageButton.setDisabledIcon(this.buttons[20]);
        this.nextPageButton.setBorderPainted(false);
        this.nextPageButton.setToolTipText("Go to next page");
        this.nextPageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CBControls.this.nextButtonPressed(actionEvent);
            }
        });
        this.add((Component)this.nextPageButton, new GridBagConstraints());
        this.nextArchiveButton.setIcon(this.buttons[21]);
        this.nextArchiveButton.setPressedIcon(this.buttons[22]);
        this.nextArchiveButton.setDisabledIcon(this.buttons[23]);
        this.nextArchiveButton.setBorderPainted(false);
        this.nextArchiveButton.setToolTipText("Go to next archive");
        this.nextArchiveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CBControls.this.nextArchiveButtonPressed(actionEvent);
            }
        });
        this.add((Component)this.nextArchiveButton, new GridBagConstraints());
        this.prevArchiveButton.setEnabled(false);
        this.nextArchiveButton.setEnabled(false);
        this.prevPageButton.setEnabled(false);
        this.nextPageButton.setEnabled(false);
        this.scaleButton.setEnabled(false);
        this.firstPageButton.setEnabled(false);
        this.lastPageButton.setEnabled(false);
    }

    private void previousArchiveButtonPressed(ActionEvent actionEvent) {
        this.theApp.fileStuff.getPreviousArchive();
        this.processButtons();
        this.giveBackFocus();
    }

    private void nextArchiveButtonPressed(ActionEvent actionEvent) {
        this.theApp.fileStuff.getNextArchive();
        this.processButtons();
        this.giveBackFocus();
    }

    private void scaleButtonPressed(ActionEvent actionEvent) {
        if (this.theApp.pageStuff.getScale()) {
            this.theApp.pageStuff.setScale(false);
        } else {
            this.theApp.pageStuff.setScale(true);
        }
        this.theApp.pageStuff.setCurrentPage(this.theApp.pageStuff.getCurrentPage());
        this.processButtons();
        this.giveBackFocus();
    }

    private void nextButtonPressed(ActionEvent actionEvent) {
        if (this.theApp.pageStuff.getCurrentPage() != this.theApp.pageStuff.getLastPage()) {
            this.theApp.pageStuff.setCurrentPage(this.theApp.pageStuff.getCurrentPage() + 1);
        }
        this.processButtons();
        this.giveBackFocus();
    }

    private void lastButtonPressed(ActionEvent actionEvent) {
        this.theApp.pageStuff.setCurrentPage(this.theApp.pageStuff.getLastPage());
        this.giveBackFocus();
    }

    private void previousButtonPressed(ActionEvent actionEvent) {
        if (this.theApp.pageStuff.getCurrentPage() != 0) {
            this.theApp.pageStuff.setCurrentPage(this.theApp.pageStuff.getCurrentPage() - 1);
        }
        this.processButtons();
        this.giveBackFocus();
    }

    private void firstButtonPressed(ActionEvent actionEvent) {
        this.theApp.pageStuff.setCurrentPage(0);
        this.processButtons();
        this.giveBackFocus();
    }

    protected void changeFileLabel(String string) {
        this.fileLabel.setText(string);
    }

    protected void processButtons() {
        this.prevArchiveButton.setEnabled(true);
        this.prevPageButton.setEnabled(true);
        this.firstPageButton.setEnabled(true);
        this.scaleButton.setEnabled(true);
        this.lastPageButton.setEnabled(true);
        this.nextPageButton.setEnabled(true);
        this.nextArchiveButton.setEnabled(true);
        if (this.theApp.pageStuff.getCurrentPage() == 0) {
            this.firstPageButton.setEnabled(false);
            this.prevPageButton.setEnabled(false);
        }
        if (this.theApp.pageStuff.getCurrentPage() == this.theApp.pageStuff.getLastPage()) {
            this.nextPageButton.setEnabled(false);
            this.lastPageButton.setEnabled(false);
        }
        if (this.theApp.fileStuff.isFirstArchive()) {
            this.prevArchiveButton.setEnabled(false);
        }
        if (this.theApp.fileStuff.isLastArchive()) {
            this.nextArchiveButton.setEnabled(false);
        }
        if (this.theApp.pageStuff.getScale()) {
            this.scaleButton.setIcon(this.buttons[9]);
            this.scaleButton.setPressedIcon(this.buttons[10]);
            this.scaleButton.setDisabledIcon(this.buttons[11]);
        } else {
            this.scaleButton.setIcon(this.buttons[12]);
            this.scaleButton.setPressedIcon(this.buttons[13]);
            this.scaleButton.setDisabledIcon(this.buttons[14]);
        }
    }

    protected void disableButtons() {
        this.prevArchiveButton.setEnabled(false);
        this.prevPageButton.setEnabled(false);
        this.firstPageButton.setEnabled(false);
        this.scaleButton.setEnabled(false);
        this.lastPageButton.setEnabled(false);
        this.nextPageButton.setEnabled(false);
        this.nextArchiveButton.setEnabled(false);
    }

    private void giveBackFocus() {
        this.theApp.thePage.requestFocus();
    }

    private void loadButtonIcons() {
        this.buttons[0] = new ImageIcon(CBControls.class.getResource("prevarchive.gif"));
        this.buttons[1] = new ImageIcon(CBControls.class.getResource("prevarchive_c.gif"));
        this.buttons[2] = new ImageIcon(CBControls.class.getResource("prevarchive_d.gif"));
        this.buttons[3] = new ImageIcon(CBControls.class.getResource("prevpage.gif"));
        this.buttons[4] = new ImageIcon(CBControls.class.getResource("prevpage_c.gif"));
        this.buttons[5] = new ImageIcon(CBControls.class.getResource("prevpage_d.gif"));
        this.buttons[6] = new ImageIcon(CBControls.class.getResource("firstpage.gif"));
        this.buttons[7] = new ImageIcon(CBControls.class.getResource("firstpage_c.gif"));
        this.buttons[8] = new ImageIcon(CBControls.class.getResource("firstpage_d.gif"));
        this.buttons[9] = new ImageIcon(CBControls.class.getResource("mag+.gif"));
        this.buttons[10] = new ImageIcon(CBControls.class.getResource("mag+_c.gif"));
        this.buttons[11] = new ImageIcon(CBControls.class.getResource("mag+_d.gif"));
        this.buttons[12] = new ImageIcon(CBControls.class.getResource("mag-.gif"));
        this.buttons[13] = new ImageIcon(CBControls.class.getResource("mag-_c.gif"));
        this.buttons[14] = new ImageIcon(CBControls.class.getResource("mag-_d.gif"));
        this.buttons[15] = new ImageIcon(CBControls.class.getResource("lastpage.gif"));
        this.buttons[16] = new ImageIcon(CBControls.class.getResource("lastpage_c.gif"));
        this.buttons[17] = new ImageIcon(CBControls.class.getResource("lastpage_d.gif"));
        this.buttons[18] = new ImageIcon(CBControls.class.getResource("nextpage.gif"));
        this.buttons[19] = new ImageIcon(CBControls.class.getResource("nextpage_c.gif"));
        this.buttons[20] = new ImageIcon(CBControls.class.getResource("nextpage_d.gif"));
        this.buttons[21] = new ImageIcon(CBControls.class.getResource("nextarchive.gif"));
        this.buttons[22] = new ImageIcon(CBControls.class.getResource("nextarchive_c.gif"));
        this.buttons[23] = new ImageIcon(CBControls.class.getResource("nextarchive_d.gif"));
    }
}

