/*
 * Decompiled with CFR 0.152.
 */
package cbviewer;

import cbviewer.CBSortStuff;
import cbviewer.CBViewer;
import cbviewer.cbFileFilter;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import javax.swing.JFileChooser;

public class CBArchiveLoader {
    private CBViewer theApp;
    private boolean inZip = false;
    private CBSortStuff sortStuff = new CBSortStuff();
    private String pictureDir;
    protected String tempDirName = ".cbtemp";
    private String workingDir;
    private ArrayList fileEntries = new ArrayList();

    public CBArchiveLoader(CBViewer cBViewer) {
        this.theApp = cBViewer;
    }

    protected void openArchive(int n, String string) {
        Object object;
        Runtime runtime = Runtime.getRuntime();
        Process process = null;
        int n2 = 0;
        boolean bl = false;
        if (n == 0 && (n2 = this.getCBFile()) == 1) {
            this.theApp.fileStuff.setArchiveDir((String)this.fileEntries.get(2));
            this.theApp.fileStuff.setCurrentArchive((String)this.fileEntries.get(1));
        }
        if (n == 1) {
            object = new File(string);
            this.fileEntries.clear();
            this.fileEntries.trimToSize();
            this.fileEntries.add(((File)object).getPath());
            this.fileEntries.add(((File)object).getName());
            this.fileEntries.add(((File)object).getParent());
            this.fileEntries.add(object);
            n2 = 1;
        }
        this.theApp.frame.setCursor(new Cursor(3));
        if (n2 == 1) {
            Object object2;
            object = (String)this.fileEntries.get(0);
            String string2 = (String)this.fileEntries.get(1);
            if ((string2.toLowerCase().endsWith(".cbr") || string2.toLowerCase().endsWith(".rar")) && !this.inZip) {
                this.theApp.fileStuff.setZipFlag(false);
                if (this.theApp.fileStuff.getTempDirFlag()) {
                    this.removeTempDir();
                }
                switch (this.theApp.utils.checkOS()) {
                    case 0: 
                    case 2: {
                        this.handleRarLinux((String)object, string2, runtime, process);
                        break;
                    }
                    case 1: {
                        this.handleRarWindows((String)object, string2, runtime, process);
                        break;
                    }
                    default: {
                        System.err.println("This OS is not currently supported by CBViewer for rar files");
                    }
                }
            }
            if (string2.toLowerCase().endsWith(".cbz") || string2.toLowerCase().endsWith(".zip") || this.inZip) {
                this.theApp.thePage.clearBuffImage();
                this.theApp.fileStuff.setZipFlag(true);
                this.theApp.fileStuff.zipEntries.clear();
                this.theApp.fileStuff.zipEntries.trimToSize();
                this.theApp.fileStuff.zipEntries.add((File)this.fileEntries.get(3));
                object2 = null;
                try {
                    object2 = new ZipInputStream(new FileInputStream((File)this.theApp.fileStuff.zipEntries.get(0)));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    System.err.println("The Zip file was not found properly" + fileNotFoundException);
                }
                ZipEntry zipEntry = null;
                try {
                    zipEntry = ((ZipInputStream)object2).getNextEntry();
                    while (zipEntry != null) {
                        if (zipEntry.getName().toLowerCase().endsWith(".jpg") || zipEntry.getName().toLowerCase().endsWith(".jpeg") || zipEntry.getName().toLowerCase().endsWith(".png")) {
                            this.theApp.fileStuff.zipEntries.add(zipEntry.getName());
                        }
                        ((ZipInputStream)object2).closeEntry();
                        zipEntry = ((ZipInputStream)object2).getNextEntry();
                    }
                    ((ZipInputStream)object2).close();
                }
                catch (IOException iOException) {
                    System.err.println("Problem reading the zip file" + iOException);
                }
            }
            if (!this.theApp.fileStuff.getZipFlag()) {
                this.pictureDir = this.workingDir + File.separatorChar + this.tempDirName;
                this.theApp.fileStuff.setTempDir(new File(this.pictureDir));
                this.theApp.pageStuff.pictures = this.theApp.fileStuff.getTempDir().list();
                object2 = new File(this.theApp.fileStuff.getTempPath(), this.theApp.pageStuff.pictures[0]);
                if (((File)object2).isDirectory()) {
                    this.pictureDir = ((File)object2).getPath();
                    this.theApp.fileStuff.setTempDir(new File(this.pictureDir));
                    this.theApp.pageStuff.pictures = this.theApp.fileStuff.getTempDir().list();
                    object2 = new File(this.theApp.fileStuff.getTempPath(), this.theApp.pageStuff.pictures[0]);
                }
            }
            if (!this.theApp.fileStuff.getZipFlag()) {
                this.theApp.pageStuff.setLastPage(this.theApp.pageStuff.pictures.length - 1);
                this.theApp.pageStuff.pictures = this.sortStuff.sortMethodOne(this.theApp.pageStuff.pictures);
                this.theApp.menu.jumpMenu.regenMenu(this.theApp.pageStuff.pictures);
            }
            if (this.theApp.fileStuff.getZipFlag()) {
                this.theApp.pageStuff.setLastPage(this.theApp.fileStuff.zipEntries.size() - 1);
                this.theApp.fileStuff.zipEntries = this.sortStuff.sortMethodTwo(this.theApp.fileStuff.zipEntries);
                object2 = new String[this.theApp.fileStuff.zipEntries.size() - 1];
                for (int i = 1; i < this.theApp.fileStuff.zipEntries.size(); ++i) {
                    object2[i - 1] = (String)this.theApp.fileStuff.zipEntries.get(i);
                }
                this.theApp.menu.jumpMenu.regenMenu((String[])object2);
            }
            this.theApp.pageStuff.setCurrentPage(0);
            this.theApp.controls.processButtons();
            this.theApp.frame.getContentPane().validate();
        }
        this.inZip = false;
        this.theApp.frame.setCursor(new Cursor(0));
        this.theApp.menu.enableCloseArchive(true);
    }

    private void handleRarWindows(String string, String string2, Runtime runtime, Process process) {
        Closeable closeable;
        this.workingDir = System.getProperty("user.home");
        File file = new File(this.workingDir + System.getProperty("file.separator") + this.tempDirName);
        file.mkdir();
        this.theApp.fileStuff.setTempDirFlag(true);
        boolean bl = true;
        try {
            closeable = new ZipFile(string);
        }
        catch (ZipException zipException) {
            bl = false;
        }
        catch (IOException iOException) {
            System.err.println("IOException: " + iOException);
        }
        if (bl) {
            this.inZip = true;
            this.removeTempDir();
            this.openArchive(1, string);
            return;
        }
        try {
            System.out.println("filename = " + string);
            System.out.println("output = " + this.workingDir + System.getProperty("file.separator") + this.tempDirName);
            process = runtime.exec("cmd /C unrar e -y -ep \"" + string + "\"", null, new File(this.workingDir + System.getProperty("file.separator") + this.tempDirName));
            closeable = process.getInputStream();
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)closeable);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String string3 = null;
            while ((string3 = bufferedReader.readLine()) != null) {
                System.out.println(string3);
            }
            System.out.println("Waiting for process to complete");
            process.waitFor();
            System.out.println("Process complete");
            process = runtime.exec("cmd /C del *.nfo", null, new File(this.workingDir + System.getProperty("file.separator") + this.tempDirName));
            closeable = process.getInputStream();
            while ((string3 = bufferedReader.readLine()) != null) {
                System.out.println(string3);
            }
            process.waitFor();
            process = runtime.exec("cmd /C del *.sfv", null, new File(this.workingDir + System.getProperty("file.separator") + this.tempDirName));
            closeable = process.getInputStream();
            while ((string3 = bufferedReader.readLine()) != null) {
                System.out.println(string3);
            }
            process.waitFor();
            process = runtime.exec("cmd /C del *.md5", null, new File(this.workingDir + System.getProperty("file.separator") + this.tempDirName));
            closeable = process.getInputStream();
            while ((string3 = bufferedReader.readLine()) != null) {
                System.out.println(string3);
            }
            process.waitFor();
            process = runtime.exec("cmd /C del *.db", null, new File(this.workingDir + System.getProperty("file.separator") + this.tempDirName));
            closeable = process.getInputStream();
            while ((string3 = bufferedReader.readLine()) != null) {
                System.out.println(string3);
            }
            process.waitFor();
        }
        catch (IOException iOException) {
            System.err.println("Problem unraring the file");
        }
        catch (InterruptedException interruptedException) {
            System.err.println("Problem unraring the file");
        }
    }

    public void removeTempDir() {
        Runtime runtime = Runtime.getRuntime();
        switch (this.theApp.utils.checkOS()) {
            case 0: {
                this.theApp.fileStuff.delDir(new File(this.workingDir + System.getProperty("file.separator") + this.tempDirName));
                this.theApp.fileStuff.setTempDirFlag(false);
                break;
            }
            case 1: 
            case 2: {
                this.theApp.fileStuff.delDir(new File(System.getProperty("user.home") + System.getProperty("file.separator") + this.tempDirName));
                this.theApp.fileStuff.setTempDirFlag(false);
            }
        }
    }

    private int getCBFile() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setCurrentDirectory(new File(System.getProperty("user.home")));
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setFileFilter(new cbFileFilter());
        int n = jFileChooser.showOpenDialog(this.theApp.frame);
        if (n == 0) {
            this.fileEntries.clear();
            this.fileEntries.trimToSize();
            this.fileEntries.add(jFileChooser.getSelectedFile().getPath());
            this.fileEntries.add(jFileChooser.getSelectedFile().getName());
            this.fileEntries.add(jFileChooser.getSelectedFile().getParent());
            this.fileEntries.add(jFileChooser.getSelectedFile());
            this.theApp.fileStuff.setArchiveDir(jFileChooser.getSelectedFile().getParent());
            return 1;
        }
        return 0;
    }

    private void handleRarLinux(String string, String string2, Runtime runtime, Process process) {
        Object object;
        System.out.println(string);
        System.out.println(string2);
        boolean bl = true;
        try {
            object = new ZipFile(string);
        }
        catch (ZipException zipException) {
            bl = false;
        }
        catch (IOException iOException) {
            System.err.println("Problem testing cbr file: " + iOException);
        }
        if (bl) {
            this.inZip = true;
            this.openArchive(1, string);
            return;
        }
        object = new File(System.getProperty("user.home") + System.getProperty("file.separator") + this.tempDirName);
        ((File)object).mkdir();
        this.theApp.fileStuff.setTempDirFlag(true);
        if (string.indexOf(" ") != -1 || string.indexOf("#") != -1) {
            string = "\"" + string + "\"";
            this.createShellScript(string, 0, this.workingDir, this.tempDirName);
            System.out.println("fileToWorkOn " + string2 + "workingDir " + this.workingDir + "tempDirName " + this.tempDirName);
        } else {
            try {
                process = runtime.exec("unrar e -y " + string, null, new File(System.getProperty("user.home") + System.getProperty("file.separator") + this.tempDirName));
                InputStream inputStream = process.getInputStream();
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                String string3 = null;
                while ((string3 = bufferedReader.readLine()) != null) {
                    System.out.println(string3);
                }
                process.waitFor();
            }
            catch (InterruptedException interruptedException) {
                System.err.println("Problem unraring the archive" + interruptedException);
            }
            catch (IOException iOException) {
                System.err.println("IOException: " + iOException);
            }
        }
        this.workingDir = System.getProperty("user.home");
    }

    public void createShellScript(String string, int n, String string2, String string3) {
        Process process;
        String string4 = " ";
        if (n == 0) {
            string4 = "unrar e -y " + string;
            System.out.println(string4);
        }
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new FileOutputStream(System.getProperty("user.home") + File.separatorChar + this.tempDirName + File.separatorChar + "tempscript.sh"));
            printWriter.println(string4);
            printWriter.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("Problem opening the shell script");
        }
        Runtime runtime = Runtime.getRuntime();
        try {
            process = runtime.exec("sh tempscript.sh", null, new File(System.getProperty("user.home") + File.separatorChar + this.tempDirName));
            InputStream inputStream = process.getInputStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String string5 = null;
            while ((string5 = bufferedReader.readLine()) != null) {
                System.out.println(string5);
            }
            process.waitFor();
        }
        catch (IOException iOException) {
            System.err.println("problem executing script");
        }
        catch (InterruptedException interruptedException) {
            System.err.println("problem executing shell script");
        }
        try {
            process = runtime.exec("rm tempscript.sh", null, new File(System.getProperty("user.home") + File.separatorChar + this.tempDirName));
            process.waitFor();
        }
        catch (IOException iOException) {
            System.err.println("problem removing script");
        }
        catch (InterruptedException interruptedException) {
            System.err.println("problem removing the shell script");
        }
        this.theApp.fileStuff.setTempDirFlag(true);
    }

    protected void closeArchive(ActionEvent actionEvent) {
        if (this.theApp.fileStuff.getTempDirFlag()) {
            this.removeTempDir();
            this.theApp.thePage.setDefault();
        } else if (this.theApp.fileStuff.getZipFlag()) {
            this.theApp.fileStuff.setZipFlag(false);
            this.theApp.thePage.setDefault();
        } else {
            System.err.println("There is no archive to close\n");
        }
        this.theApp.controls.disableButtons();
        this.theApp.menu.jumpMenu.clearMenu();
        this.theApp.menu.enableCloseArchive(false);
    }
}

