/*
 * Decompiled with CFR 0.152.
 */
package cbviewer;

import cbviewer.CBArchiveLoader;
import cbviewer.CBControls;
import cbviewer.CBFileStuff;
import cbviewer.CBFrame;
import cbviewer.CBMenu;
import cbviewer.CBPage;
import cbviewer.CBPageStuff;
import cbviewer.CBUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.util.prefs.Preferences;
import javax.swing.JScrollPane;

public class CBViewer {
    public CBArchiveLoader loader;
    public CBFrame frame;
    public CBFileStuff fileStuff;
    public CBPageStuff pageStuff;
    public CBPage thePage;
    public CBUtils utils;
    public CBMenu menu;
    public CBControls controls;
    public Preferences prefs = Preferences.userNodeForPackage(this.getClass());
    public JScrollPane scrollPane = new JScrollPane();
    private int prefScrollx = 640;
    private int prefScrolly = 480;
    private int minScrollx = 640;
    private int minScrolly = 480;

    public CBViewer() {
        this.frame = new CBFrame(this);
        this.fileStuff = new CBFileStuff(this);
        this.pageStuff = new CBPageStuff(this);
        this.loader = new CBArchiveLoader(this);
        this.utils = new CBUtils(this);
        this.menu = new CBMenu(this);
        this.controls = new CBControls(this);
        if (new File(System.getProperty("user.home") + System.getProperty("file.separator") + this.loader.tempDirName).exists()) {
            this.loader.removeTempDir();
        }
        this.frame.setJMenuBar(this.menu);
        this.frame.setVisible(true);
        if (this.prefs.getBoolean("toolbar_visible", true)) {
            this.frame.getContentPane().add((Component)this.controls, "South");
        }
        this.thePage = new CBPage(this);
        if (this.prefs.getBoolean("scrollbars_visible", true)) {
            this.scrollPane.setHorizontalScrollBarPolicy(32);
            this.scrollPane.setVerticalScrollBarPolicy(22);
        } else {
            this.scrollPane.setHorizontalScrollBarPolicy(31);
            this.scrollPane.setVerticalScrollBarPolicy(21);
        }
        this.scrollPane.setDoubleBuffered(true);
        this.scrollPane.setMinimumSize(new Dimension(this.minScrollx, this.minScrolly));
        this.scrollPane.setPreferredSize(new Dimension(this.prefScrollx, this.prefScrolly));
        this.scrollPane.setViewportView(this.thePage);
        this.scrollPane.getVerticalScrollBar().setValue(0);
        this.scrollPane.getHorizontalScrollBar().setValue(0);
        this.frame.getContentPane().add((Component)this.scrollPane, "Center");
        this.frame.getContentPane().validate();
    }

    public static void main(String[] stringArray) {
        new CBViewer();
    }

    public void redrawCBViewer() {
        if (this.prefs.getBoolean("toolbar_visible", true)) {
            this.frame.getContentPane().add((Component)this.controls, "South");
        } else {
            this.frame.getContentPane().remove(this.controls);
        }
        if (this.prefs.getBoolean("scrollbars_visible", true)) {
            this.scrollPane.setHorizontalScrollBarPolicy(32);
            this.scrollPane.setVerticalScrollBarPolicy(22);
        } else {
            this.scrollPane.setHorizontalScrollBarPolicy(31);
            this.scrollPane.setVerticalScrollBarPolicy(21);
        }
        this.frame.getContentPane().validate();
    }

    public void exitCBViewer() {
        if (this.fileStuff.getTempDirFlag()) {
            this.loader.removeTempDir();
        }
        System.exit(0);
    }
}

