#include <stdio.h>
#include "ansi.h"
#include "format.h"

extern FILE *cur_unit_fd;

#undef NULL
#define NULL	0

static int indentation = START_INDENT;
static int line_num;

int
output_line()
{
	return line_num;
}

int
reset_output_line()
{
	line_num = 1;
}

static void
put(c)
	char c;
{
	fputc(c, cur_unit_fd);

	if (c == '\n') {
		line_num++;
		reset_indent();
	}
	else {
		indentation++;
	}
}

void
reset_indent()
{
	indentation = START_INDENT;
}

void
put_char(c)
	int c;
{
	put(c);
}

void
new_line()
{
	put('\n');
}

int
cur_indent()
{
	return indentation;
}

void
indent_to(n)
	int n;
{
	while(indentation < n) {
		put(' ');
	}
}

void
put_string(s)
	char *s;
{
	if (s == NULL) s = " <NULL> ";
	while (*s) {
		put(*s++);
	}
}
