/*
 * Routines for dealing with files and file names.
 *
 * The current file and line number during scanning is
 * maintained in a packed int.  This will reduce the
 * size of our IL types.
 */
#ifndef _H_FILES_
#define _H_FILES_

#ifndef _H_HOSTINFO_
#include "hostinfo.h"
#endif

#ifndef FILE_ORD_BITS
#define FILE_ORD_BITS			9
#endif

/*
 * if sizeof(int) < 32 then you're files had better be small :-)
 */
#define LINE_NUMBER_BITS		((SIZEOF_INT * BITS_PER_BYTE) - FILE_ORD_BITS)
#define MAX_UNIQ_FNAMES			(1 << FILE_ORD_BITS)

/*
 * Upper FILE_ORD_BITS specify file ordinal.
 * Rest of integer specifies line number.
 */

typedef unsigned int file_pos_t;

#define line_number(x)			((x) & ((1 << LINE_NUMBER_BITS) - 1))
#define FILE_ORD(x)				((x) >> LINE_NUMBER_BITS)

extern int num_files _ANSI_PROTO_((void));

extern char *file_name _ANSI_PROTO_((file_pos_t pos));
extern char *file_name_from_ord _ANSI_PROTO_((int ord));
extern file_pos_t add_file _ANSI_PROTO_((char *path));
extern file_pos_t set_file_pos _ANSI_PROTO_((char *path, int line));

/* returns -1 if file not found */
extern file_pos_t find_file _ANSI_PROTO_((char *path));

/*
 * File memory mapping routines
 */
extern size_t sizeof_file _ANSI_PROTO_((int fd));
extern void *map_file _ANSI_PROTO_((int fd, size_t fsize));
extern int unmap_file _ANSI_PROTO_((void *addr, size_t len));

#endif /* _H_FILES_ */
