#include <stdio.h>
#include <varargs.h>
#include <errno.h>

int Num_Errors;
int Num_Warnings;

static void
prefix(file, line, msg)
	char *file, *msg;
	int line;
{
	fflush(stdout);

	if (file) {
		fprintf(stderr, "%s, ", file);
	}

	if (line) {
		fprintf(stderr, "line %d, ", line);
	}

	if (msg) {
		fprintf(stderr, "%s: ", msg);
	}
}

static void
endmsg()
{
	fputc('\n', stderr);
	fflush(stderr);
}

void
fatal(f, l, fmt, va_alist)
	char *f, *fmt;
	int l;
	va_dcl
{
	va_list args;

	va_start(args);

	prefix(f,l,"Internal error");
	vfprintf(stderr, fmt, args);
	endmsg();

	va_end(args);

	exit(1);
}

void
error(f, l, fmt, va_alist)
	char *f, *fmt;
	int l;
	va_dcl
{
	va_list args;

	va_start(args);

	Num_Errors++;
	prefix(f,l,"Error");
	vfprintf(stderr, fmt, args);
	endmsg();

	va_end(args);
}

void
warning(f, l, fmt, va_alist)
	char *f, *fmt;
	int l;
	va_dcl
{
	va_list args;

	va_start(args);

	Num_Warnings++;
	prefix(f,l,"Warning");
	vfprintf(stderr, fmt, args);
	endmsg();

	va_end(args);
}

void
inform(f, l, fmt, va_alist)
	char *f, *fmt;
	int l;
	va_dcl
{
	va_list args;

	va_start(args);

	prefix(f,l,"Info");
	vfprintf(stderr, fmt, args);
	endmsg();

	va_end(args);
}

void
assert_failed(f, l, msg)
	char *f, *msg;
	int l;
{
	prefix(f,l,"Assertion Failed");
	fputs(msg, stderr);
	endmsg();
	exit(1);
}

static void
unix_error()
{
	extern char *sys_errlist[];
	extern int sys_nerr;

	if (errno != 0) {
		if (errno > 0 && errno < sys_nerr) {
			fputs(sys_errlist[errno], stderr);
		}
		else {
			fprintf(stderr, "errno = %d", errno);
		}
	}
}

void
syserr(file, line)
	char *file;
	int line;
{
	Num_Errors++;
	prefix(file,line,"Error");
	unix_error();
	endmsg();
}
