/*
 * An expression evaluator
 */
#ifndef _H_CPP_EVAL_
#define _H_CPP_EVAL_

/*
 * eval status
 * to gen Ada we want to grok strings/floats too
 */
typedef enum {
	eval_failed,
	eval_int,
	eval_float,
	eval_string
} cpp_eval_result_kind_t;

typedef struct {
	cpp_eval_result_kind_t	eval_result_kind;
	int						base;
	union {
		host_int_t			ival;
		double				fval;
		char				*sval;
	} eval_result;
} cpp_eval_result_t;

extern cpp_eval_result_t cpp_eval _ANSI_PROTO_((char*));

#define EVAL_FAILED(x)			((x).eval_result_kind == eval_failed)
#define IS_EVAL_INT(x)			((x).eval_result_kind == eval_int)
#define IS_EVAL_FLOAT(x)		((x).eval_result_kind == eval_float)
#define IS_EVAL_STRING(x)		((x).eval_result_kind == eval_string)

#define EVAL_INT(x)				((x).eval_result.ival)
#define EVAL_FLOAT(x)			((x).eval_result.fval)
#define EVAL_STRING(x)			((x).eval_result.sval)

#endif /* _H_CPP_EVAL_ */
