/*
 * Specifications for a C preprocessor
 */

#ifndef _H_CPP_
#define _H_CPP_

/* The structure of a C macro */
typedef struct macro_t {
	char			*macro_name; 		/* name of macro */
	char			*macro_ada_name; 	/* name assigned to Ada constant */
	char			*macro_body;		/* Text of macro body */
	int				 macro_body_len;	/* sizeof macro body */
	int				 macro_params; 		/* number of formal params */
	file_pos_t		 macro_definition;  /* source file:line info */
	struct macro_t	*macro_next; 		/* List of macros for gen() */
	hash_t	 		 macro_hash; 		/* Hash heuristic */
	struct macro_t	*macro_hash_link; 	/* Link for hash table */
} macro_t;

/* A structure to maintain source files */
typedef struct cpp_file_t {
	char				*path;			/* path name of file */
	char				*text;			/* mmap() pointer for file */
	off_t				file_size; 		/* byte size of file */
	int					fd;				/* open file descriptor */
	int					reference_count;/* If nested include only need one mmapped */
	struct cpp_file_t	*next_cpp_file;	/* List of open files */
} cpp_file_t;

/* A structure used while expanding a macro */
typedef struct {
	macro_t		*expand_macro;			/* macro being expanded */
	char		**expand_actuals; 		/* text of actual parameters */
	int			expand_nactuals; 		/* number of actual parameters */
} macro_expansion_t;

/* Enumeration of all possible identities we could be scanning */
typedef enum {
	scan_file,							/* Scanning a file */
	scan_macro_expansion,				/* Expanding a macro */
	scan_text							/* Including some text */
} scan_kind_t;

/* A structure to maintain the current text we are scanning */
typedef struct scan_position_t {
	scan_kind_t				scan_kind;  /* union discriminant */
	union {
		macro_expansion_t	expansion;  /* Current macro being expanded */
		cpp_file_t			*file; 		/* Current file being scanned */
		char				*text; 		/* Current text being scanned */
	}						scan;
	file_pos_t				scan_pos;   /* Current file position */
	int						scan_index;	/* Current text index */
	struct scan_position_t	*scan_next;	/* Dynamic stack */
} scan_position_t;

extern void macro_init _ANSI_PROTO_((int));
extern int  cpp_open _ANSI_PROTO_((char *path));
extern void cpp_cleanup _ANSI_PROTO_((void));
extern int cpp_getc _ANSI_PROTO_((void));
extern void macro_undef _ANSI_PROTO_((char*));
extern void macro_def _ANSI_PROTO_((char*, char*, int, int, file_pos_t));
extern macro_t *macro_find _ANSI_PROTO_((char*));
extern void cpp_search_path _ANSI_PROTO_((char*));
extern void cpp_show_predefines _ANSI_PROTO_((void));

#endif /* _H_CPP_ */
