/*
 * Functions to privide unlimited character buffers
 */
#ifndef _H_BUFFER_
#define _H_BUFFER_

/*
 * MAX_OUTBUF_LEN must be a power of 2 and it should
 * be large enough that overflows are uncommon, but
 * we use many automatic instances of the queues so
 * it shouldn't be so large that our stack grows
 * like Jack's beanstock.
 */
#ifndef MAX_OUTBUF_LEN
#define MAX_OUTBUF_LEN			1024
#endif

typedef struct buffer_t {
	unsigned short head, tail;
	struct buffer_t *next, *last;
	char buf[MAX_OUTBUF_LEN];
} buffer_t;

#define buf_empty(b)	(((b) && (b)->head != (b)->tail) ? 0 : is_buffer_empty(b))

extern int is_buffer_empty _ANSI_PROTO_((buffer_t*));
extern int buf_count _ANSI_PROTO_((buffer_t*));
extern void buf_add _ANSI_PROTO_((buffer_t*, int));
extern void buf_add_str _ANSI_PROTO_((buffer_t*, char*));
extern char buf_get _ANSI_PROTO_((buffer_t*));
extern void buf_init _ANSI_PROTO_((buffer_t*));
extern void buf_destroy _ANSI_PROTO_((buffer_t*));
extern void buf_concat _ANSI_PROTO_((buffer_t*,buffer_t*));
extern void buf_move_to _ANSI_PROTO_((buffer_t*,char*));
extern char *buf_get_str _ANSI_PROTO_((buffer_t*));

#endif /* _H_BUFFER_ */
