//-----------------------------------------------------------------------------
// Overlay
//-----------------------------------------------------------------------------

#ifndef __OVERLAY_H__
#define __OVERLAY_H__

#include "world.h"

static const colour_t text_colors[10]=
{
  { 255, 255, 255, 255 },       // white  0
  { 255,   0,   0, 255 },       // red    1
  {   0, 255,   0, 255 },       // green  2
  {   0,   0, 255, 255 },       // blue   3
  { 255,   0, 255, 255 },       // magenta  4
  { 255, 255,   0, 255 },       // yellow 5
  {   0, 255, 255, 255 },       // cyan   6
  {   0,   0,   0, 255 },       // black  7
  {   0,   0,   0, 255 },       // black  8
  {   0,   0,   0, 255 }        // black  9
};

/**
 * Overlay class.
 * The overlay class permit textual information rendering. It also permits
 * logos (or quads) display. For example, the console uses overlays to
 * display texts.
 * @todo Remake the public gOver overlay. It should have an internal shader
 *       for text.
 */
class Overlay
{
  public:
    void Init(void);
    void Shut(void);

    /**
     * Render the overlay.
     * @param shaders the available shaders for rendering
     */
    void Render(ShaderManager *shaders);

    /**
     * Defines a quad for display.
     * The function does not directly displays the quad. You have to call
     * the Render function to do it.
     * @param shader the shader index that will be used for the quad
     * @param x the position of left side
     * @param y the position of top
     * @param w the quad width
     * @param h the quad height
     * @param repx horizontal tiling
     * @param repy vertical tiling
     */
    void Quad(int shader,
          float x, float y,
          float w, float h,
          float repx = 1, float repy = 1);

    /**
     * Render a string.
     * @param str the string to write
     * @param shader the font shader index
     * @param x the left start position
     * @param y the sart line top position (text is written upper the line)
     * @param xsize the font width
     * @param ysize the font height
     * @param rows the height of a row
     * @param cols the width of a column
     * @param fontstyle the font style for string
     */
    void String(const char *str,
          int shader,
          float x, float y,
          float xsize = 8, float ysize = 16,
          float rows = 16, float cols = 16,
          int fontstyle = 0);

    void SetWorld(World *w);

  private:

    unsigned int num_quads;
    unsigned int num_elems;
    unsigned int num_verts;

    Surface *quads;
    int *elems;
    vertex_t *verts;

    void CreateVerts(void);   /**< Creates the verts buffer */
    void CreateQuads(void);   /**< Creates the quads buffer */
    void CreateElems(void);   /**< Creates the elems buffer */
};

#endif
