//-----------------------------------------------------------------------------
// Frustum
//-----------------------------------------------------------------------------

#ifndef __FRUSTUM_H__
#define __FRUSTUM_H__

#include "types.h"

#define DEBUG_FRUSTUM 0

// BoxInFrustum will return one of this defines according to the position of the box in the frustum
#define COMPLETE_OUT 0
#define INTERSECT    1
#define COMPLETE_IN  2

// This will allow us to create an object to keep track of our frustum
class Frustum
{
  public:
    // Call this every time the camera moves to update the frustum
    void CalculateFrustum();

    // This takes a 3D point and returns TRUE if it's inside of the frustum
    bool PointInFrustum(float x, float y, float z);

    // This takes a 3D point and a radius and returns TRUE if the sphere is inside of the frustum
    bool SphereInFrustum(float x, float y, float z, float radius);

    // This takes the center and half the length of the cube.
    bool CubeInFrustum(float x, float y, float z, float size);

    int BoxInFrustum(bboxf_t box);
    int BoxInFrustum(bbox_t box);

  private:
    // This holds the A B C and D values for each side of our frustum.
    float m_Frustum[6][4];

    float   proj[16];               // This will hold our projection matrix
    float   modl[16];               // This will hold our modelview matrix
    float   clip[16];               // This will hold the clipping planes
};

#endif  /* __FRUSTUM_H__ */
