#ifndef __FRAMEWORK_H__
#define __FRAMEWORK_H__

#include "shader.h"

/**
 * Framework class.
 * The framework class offers methods to modify the current frame. This
 * should be used to display bitmaps, shaders, etc. Framework can be used
 * to display levelshots or levels previews, menu, etc.
 * The framework is reserved to main program. The engine will not render
 * it, and main program is responsible for rendering framework correctly.
 * @todo Evaluate framework useness: the user can manually create and use a
 *       shadermanager.
 * @bug There is a bug at shutting if only one map has been loaded.
 */
class FrameWork
{
  public:
    FrameWork();
    ~FrameWork();

    void Init(void);
    void Shut(void);

    /**
     * Updates the framework shaders.
     */
    void Update(void);
    void Render(void);

    void SetFont(int num, int chartype);
    int GetFont(int chartype);

    ShaderManager shaders;

  private:
    int chars_shader;
    int propfont1_shader;
    int propfont1_glow_shader;
    int propfont2_shader;
};

#endif  /* __FRAMEWORK_H__ */
