//-----------------------------------------------------------------------------
// Definitions header file
//-----------------------------------------------------------------------------

#ifndef __DEFINITIONS_H__
#define __DEFINITIONS_H__

// Here comes some linux compatibility stuff
#ifndef WIN32
  extern char* lstrlwr(char *s);

  #define _strlwr lstrlwr
  #define strlwr lstrlwr
  #define stricmp strcasecmp
  #define strnicmp strncasecmp
#endif

#define MODIF_FOG 0

#define _VERSION_           "cake engine"
#define OUTPUT_FILENAME     "cake_log.html"
#define CONFIG_FILENAME     "config.ini"

#define STR_ASK             "/?"
#define TEXT_STYLE_KEYWORD  ''     /**< Character introducing a style modification. */
#define COMMAND_SEPARATOR   ';'     /**< Character that separate two commands. */
#define COMMAND_PIPE        '|'     /**< Pipe character. */

#define LINESBLOC           64      /**< Number of console lines to allocate at same time */
#define HISTBLOC            32      /**< Number of command history lines to allocate at same time */
#define MAXPROMPTLEN        25      /**< Maximum length for command prompr */
#define RESIZE_SQUARE       12      /**< Size of resize square for console resizing */
#define TAB_LEN             5       /**< Tabulations size */
#define DELETE_CHAR         127     /**< Delete key char */
#define N_LINES_MAX         128     /**< Maximum number of lines for a single message */

#define FILENAME_LENGTH     1025    /**< maximum filename length */
#define PATH_LENGTH         1025    /**< maximum path length */

#define CONSOLE_LINELENGTH  4096    /**< Maximum length for a console line */
#define COMMAND_LINELENGTH  CONSOLE_LINELENGTH

#define MAX_OVERLAY_VERTS   262144  /**< Overlay vertices (should be enough for 1600x1200) */
#define MAX_OVERLAY_ELEMS   1048576 /**< Overlay elements (should be enough for 1600x1200) */
#define MAX_OVERLAY_QUADS   16384   /**< Overlay quads (should be enough for 1600x1200) */
#define MAX_ANIMFRAMES      8       /**< Maximum number of animation frames - should be increased for videos */
#define MAX_PARAMS          8       /**< Maximum number of parameters for a function (vertex or texture modificator) */
#define MAX_LAYERS          8       /**< Maximum number of layers for a shader */
#define MAX_TEXTURE_UNITS   2       /**< Number of texture units supported */
#define BUFFER_SIZE_BLOC    1024    /**< Vertex buffer allocation bloc size */
#define ELEMS_BLOC          4096    /**< Elems buffer allocation bloc size */
#define MAX_DEFORMS         4       /**< Maximum number of simultaneous vertex deformations */
#define MAX_NSHADERS        256     /**< Maximum number of shaders */

#define FOG_TEXTURE_WIDTH   256     /**< Fog texture width */
#define FOG_TEXTURE_HEIGHT  256     /**< Fog texture height */
#define FOG_TEXTURE_BPP     1       /**< Byte per pixel for the fog texture */

/**
 * Following definitions are for bezier patch building and lod.
 * @todo Shall I use fix distance between different tesselations instead
 *       of defining the max and min tesselation distance for all tesselation ?
 */
#define MAX_SUBDIV          4       /**< Maximum dubdivisions */
#define MINLIMIT            2500    /**< Distance corresponding to maximal curve tesselation */
#define MAXLIMIT            20000   /**< Distance corresponding to minimal curve tesselation */

// plane types are used to speed some tests
// 0-2 are axial planes
#define PLANE_X             0
#define PLANE_Y             1
#define PLANE_Z             2

// 3-5 are non-axial planes snapped to the nearest
#define PLANE_ANYX          3
#define PLANE_ANYY          4
#define PLANE_ANYZ          5

#define PLANE_NON_AXIAL     3

// angle indexes
#define PITCH               0   /**< up / down */
#define YAW                 1   /**< left / right */
#define ROLL                2   /**< fall over */

#define MAX_PLAYERNAME_LENGTH     256   /**< Maximum player name string length */

/**
 * Following definitions are for shaders initialisation. If SHADER_USE_REFERENCES is
 * defined, shader files are all parsed at cake start and shaders are stored in a list
 * and start position is stored. If it is not start, shaders are reparsed each time a
 * map is loaded. When SHADER_USE_REFERENCES is set to 1, shader may be wrong parsed
 * if shader files content change during runtime because references are not updated.
 */
#define SHADER_USE_REFERENCES     1     /**< Enable/Disable the reference method */
#define SHADER_ALLOWDUPLICATE     1
#define SHADER_NAME_MAX_LENGTH    512   /**< Maximum shadername length */

// Char type
#define NORMAL_CHAR               1
#define PROPFONT1_CHAR            2
#define PROPFONT1_GLOW_CHAR       3
#define PROPFONT2_CHAR            4

// Font style
#define FONT_BIG                  1
#define FONT_SMALL                2
#define FONT_GIANT                4
#define FONT_SHADOWED             8

#define SMALL_CHAR_WIDTH          8
#define SMALL_CHAR_HEIGHT         16

#define BIG_CHAR_WIDTH            16
#define BIG_CHAR_HEIGHT           16

#define GIANT_CHAR_WIDTH          32
#define GIANT_CHAR_HEIGHT         48

#define PROP_CHAR_HEIGHT          27
#define PROP_SMALL_SCALE          0.75
#define PROP_BIG_SCALE            1
#define PROP_SMALL_SPACING        1.5
#define PROP_BIG_SPACING          1

#define PROP_SMALL_HEIGHT         PROP_CHAR_HEIGHT*PROP_SMALL_SCALE
#define PROP_BIG_HEIGHT           PROP_CHAR_HEIGHT*PROP_BIG_SCALE

#endif  /* __DEFINITIONS_H__ */
