//-----------------------------------------------------------------------------
// Cake Header
//-----------------------------------------------------------------------------

/**
 * \mainpage CAKE Documentation
 * In a few words, cake is the project of a quake 3 map viewer. The base code
 * was taken from the <a href="http://talika.eii.us.es/~titan/titan/index.html">
 * Titan Project</a> and has been reorganized in a more simple architecture.
 * New elements and new shader effects have been added.
 *
 * The engine is now a single library with headers discribing each element
 * of the engine. This documentation is based on the cake library source code
 * and was generated by <a href="http://www.doxygen.org">doxygen</a>.
 */

/**
 * @example main.cpp
 * This is an example for the main program. Note that we use here the GLUT
 * library. Future version will use DirectInput for keyboard and mouse
 * support.
 */

#ifndef __CAKE_H__
#define __CAKE_H__

#ifdef WIN32
  #include <windows.h>      // Header for Windows
  #pragma comment(lib, "opengl32.lib")
  #pragma comment(lib, "glu32.lib")
  #define beep()  Beep(700, 1)
#else
  #include <curses.h>
  #define beep()
#endif

#include <GL/gl.h>          // OpenGL
#include <GL/glu.h>
#include "types.h"

//-----------------------------------------------------------------------------
// Variables globales - les variables sont cres  la cration de App
//-----------------------------------------------------------------------------

extern LogFile*     gLogFile;   // gestion du fichier de log
extern Console*     gConsole;   // console
extern FrameWork*   gFramework;   // framework
extern Vars*      gVars;      // gestion de variables
extern Alias*     gAlias;     // gestion des alias
extern Commands*    gCommands;    // gestion des commandes
extern Render*      gRender;    // Render
extern Overlay*     gOver;      // Overlay

//-----------------------------------------------------------------------------
// Unwanted VC++ level 4 warnings to disable.
//-----------------------------------------------------------------------------
#ifdef WIN32
  //#pragma warning(disable : 4244) /* conversion to float, possible loss of data             */
  //#pragma warning(disable : 4699) /* creating precompiled header                      */
  #pragma warning(disable : 4200) /* Zero-length array item at end of structure, a VC-specific extension  */
  //#pragma warning(disable : 4100) /* unreferenced formal parameter                    */
  //#pragma warning(disable : 4514) /* unreferenced inline function has been removed            */
  //#pragma warning(disable : 4201) /* nonstandard extension used : nameless struct/union         */
  //#pragma warning(disable : 4710) /* inline function not expanded                     */
  //#pragma warning(disable : 4702) /* unreachable code in inline expanded function             */
  //#pragma warning(disable : 4711) /* function selected for autmatic inlining                */
  //#pragma warning(disable : 4725) /* Pentium fdiv bug                           */
  //#pragma warning(disable : 4127) /* Conditional expression is constant                 */
  //#pragma warning(disable : 4512) /* assignment operator could not be generated                           */
  //#pragma warning(disable : 4530) /* C++ exception handler used, but unwind semantics are not enabled     */
  //#pragma warning(disable : 4245) /* conversion from 'enum ' to 'unsigned long', signed/unsigned mismatch */
  //#pragma warning(disable : 4305) /* truncation from 'const double' to 'float'                            */
  //#pragma warning(disable : 4238) /* nonstandard extension used : class rvalue used as lvalue             */
  //#pragma warning(disable : 4251) /* needs to have dll-interface to be used by clients of class 'ULinker' */
  //#pragma warning(disable : 4275) /* non dll-interface class used as base for dll-interface class         */
  //#pragma warning(disable : 4511) /* copy constructor could not be generated                              */
  //#pragma warning(disable : 4284) /* return type is not a UDT or reference to a UDT                       */
  //#pragma warning(disable : 4355) /* this used in base initializer list                                   */
  //#pragma warning(disable : 4097) /* typedef-name '' used as synonym for class-name ''                    */
  //#pragma warning(disable : 4291) /* typedef-name '' used as synonym for class-name ''                    */
#endif

#endif  /*__CAKE_H__*/
