//-----------------------------------------------------------------------------
// BezierPatch
//-----------------------------------------------------------------------------

#ifndef __BEZIERPATCH_H__
#define __BEZIERPATCH_H__

#include "types.h"
#include <string.h>     // for memset
#include <math.h>     // for log
#include <assert.h>     // for assert
#include "console.h"

/**
 * Gets the flatness of a patch depending on its control points.
 */
void Patch_GetFlatness(float maxflat, vec4_t *points, int *patch_cp, int *flat);

/**
 * Generates a patch.
 */
void Patch_Evaluate(vec4_t *p, int *numcp, int *tess, vec4_t *dest);

/**
 * Patches group.
 * The patch group takes together all patches that have same control points.
 * This is done to implement progressive curves optimization and solve the
 * problem that occures when two connected curves have not the same distance
 * to camera. In this case, one curve can be more tesselated than the other,
 * and result is bad looking.
 * PatchesGroups are created during bsp initialization (see code for details).
 * @todo Make distance test (for tesselation level) dependent on group size.
 *       For the moment, if group is very large (exemple in q3dm7 near start
 *       pos 0) and camera is far from center, tesselation will change with
 *       no reason.
 */
class PatchesGroup
{
  public:
    PatchesGroup(void);
    ~PatchesGroup(void);

    /**
     * Adds a surface index in the group.
     * @param val The new surface index that is added to the current group.
     */
    void Add(int val);

    /**
     * Update the LOD for all surfaces.
     * @param val The current test value
     * @param patches A pointer to the BSP patches surfaces array
     */
    void Update(float val, Surface **patches);

    /**
     * Dump properties of all patches of the group
     * @param patches A pointer to the BSP patches surfaces array
     */
    void DumpGroup(Surface **patches);

    int *surfidx;     /**< Index to patches that are elements of the group */
    int nsurf;        /**< Number of surface indexes */
    float middle[3];    /**< Middle point of the group */
    float size;       /**< Size of the group (max length or width or height) */
    bboxf_t bbox;     /**< Group bounding box */
};

#endif  /* __BEZIERPATCH_H__ */
