/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;

public class Strings {
    private static final MessageDigest MESSAGE_DIGEST;
    public static final String[] EMPTY_ARRAY;
    private static final String HEX_CHARS = "0123456789ABCDEF";

    private Strings() {
    }

    public static int compareVersions(String version1, String version2) {
        return version1.compareTo(version2);
    }

    public static boolean isBlank(String text) {
        return text == null || "".equals(text);
    }

    public static int countLines(String text) {
        int lbIdx;
        int startIdx = 0;
        int lineCount = 1;
        while ((lbIdx = text.indexOf(10, startIdx)) != -1) {
            ++lineCount;
            startIdx = lbIdx + 1;
        }
        return lineCount;
    }

    public static boolean isJavaIdentifier(String id2) {
        if (id2 == null) {
            return false;
        }
        int len = id2.length();
        if (len == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(id2.charAt(0))) {
            return false;
        }
        for (int i10 = 1; i10 < len; ++i10) {
            if (Character.isJavaIdentifierPart(id2.charAt(i10))) continue;
            return false;
        }
        return true;
    }

    public static String getTextFromStream(InputStream in2) throws IOException {
        int numRead;
        InputStreamReader reader = new InputStreamReader(in2, "UTF-8");
        char[] buffer = new char[256];
        int offset = 0;
        while ((numRead = ((Reader)reader).read(buffer, offset, buffer.length - offset)) != -1) {
            if ((offset += numRead) < buffer.length * 2 / 3) continue;
            char[] newBuffer = new char[buffer.length * 2];
            System.arraycopy(buffer, 0, newBuffer, 0, offset);
            buffer = newBuffer;
        }
        return new String(buffer, 0, offset);
    }

    public static String getJavaStringLiteral(String text) {
        StringBuffer buf = new StringBuffer();
        buf.append('\"');
        int len = text.length();
        block7: for (int i10 = 0; i10 < len; ++i10) {
            char ch2 = text.charAt(i10);
            switch (ch2) {
                case '\\': {
                    buf.append("\\\\");
                    continue block7;
                }
                case '\n': {
                    buf.append("\\n");
                    continue block7;
                }
                case '\r': {
                    buf.append("\\r");
                    continue block7;
                }
                case '\t': {
                    buf.append("\\t");
                    continue block7;
                }
                case '\"': {
                    buf.append("\\\"");
                    continue block7;
                }
                default: {
                    buf.append(ch2);
                }
            }
        }
        buf.append('\"');
        return buf.toString();
    }

    public static String getJavaIdentifier(String candidateID) {
        int len = candidateID.length();
        StringBuffer buf = new StringBuffer();
        for (int i10 = 0; i10 < len; ++i10) {
            boolean good;
            char ch2 = candidateID.charAt(i10);
            boolean bl2 = good = i10 == 0 ? Character.isJavaIdentifierStart(ch2) : Character.isJavaIdentifierPart(ch2);
            if (good) {
                buf.append(ch2);
                continue;
            }
            buf.append('_');
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMD5(String source) throws UnsupportedEncodingException {
        byte[] result;
        byte[] bytes = source.getBytes("UTF8");
        MessageDigest messageDigest = MESSAGE_DIGEST;
        synchronized (messageDigest) {
            MESSAGE_DIGEST.update(bytes);
            result = MESSAGE_DIGEST.digest();
        }
        char[] resChars = new char[32];
        int len = result.length;
        for (int i10 = 0; i10 < len; ++i10) {
            byte b10 = result[i10];
            int lo4 = b10 & 0xF;
            int hi4 = (b10 & 0xF0) >> 4;
            resChars[i10 * 2] = HEX_CHARS.charAt(hi4);
            resChars[i10 * 2 + 1] = HEX_CHARS.charAt(lo4);
        }
        return new String(resChars);
    }

    public static String getHash32(String source) throws UnsupportedEncodingException {
        String md5 = Strings.getMD5(source);
        return md5.substring(0, 8);
    }

    public static String getHash64(String source) throws UnsupportedEncodingException {
        String md5 = Strings.getMD5(source);
        return md5.substring(0, 16);
    }

    public static int countChars(String text, char ch2) {
        int len = text.length();
        int count = 0;
        for (int i10 = 0; i10 < len; ++i10) {
            if (ch2 != text.charAt(i10)) continue;
            ++count;
        }
        return count;
    }

    public static String unquote(String text) {
        if (text.startsWith("\"") && text.endsWith("\"")) {
            return text.substring(1, text.length() - 2);
        }
        return text;
    }

    public static String[] split(String phrase) {
        int length = phrase.length();
        ArrayList<String> wordList = new ArrayList<String>();
        StringBuffer word = null;
        block3: for (int i10 = 0; i10 < length; ++i10) {
            char ch2 = phrase.charAt(i10);
            switch (ch2) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    if (word == null) continue block3;
                    wordList.add(word.toString());
                    word = null;
                    continue block3;
                }
                default: {
                    if (word == null) {
                        word = new StringBuffer();
                    }
                    word.append(ch2);
                }
            }
        }
        if (word != null) {
            wordList.add(word.toString());
        }
        return wordList.toArray(EMPTY_ARRAY);
    }

    public static String truncate(String text, int maxLength) {
        if (text == null) {
            return null;
        }
        if (text.length() <= maxLength) {
            return text;
        }
        return text.substring(0, Math.max(maxLength - 3, 0)) + "...";
    }

    public static String strictHtmlEncode(String rawText) {
        StringBuffer output = new StringBuffer();
        int length = rawText.length();
        block6: for (int i10 = 0; i10 < length; ++i10) {
            char ch2 = rawText.charAt(i10);
            switch (ch2) {
                case '&': {
                    output.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    output.append("&quot;");
                    continue block6;
                }
                case '<': {
                    output.append("&lt;");
                    continue block6;
                }
                case '>': {
                    output.append("&gt;");
                    continue block6;
                }
                default: {
                    output.append(ch2);
                }
            }
        }
        return output.toString();
    }

    public static String trimForAlphaNumDash(String rawText) {
        int length = rawText.length();
        for (int i10 = 0; i10 < length; ++i10) {
            char ch2 = rawText.charAt(i10);
            if (ch2 >= 'a' && ch2 <= 'z' || ch2 >= 'A' && ch2 <= 'Z' || ch2 >= '0' && ch2 <= '9' || ch2 == '-') continue;
            return rawText.substring(0, i10);
        }
        return rawText;
    }

    static {
        MessageDigest md2;
        EMPTY_ARRAY = new String[0];
        try {
            md2 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException err) {
            throw new IllegalStateException();
        }
        MESSAGE_DIGEST = md2;
    }
}

