/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.style;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.util.HashMap;
import java.util.Map;
import org.lobobrowser.html.style.RenderState;
import org.lobobrowser.html.style.RenderStateDelegator;
import org.lobobrowser.html.style.WordInfo;

public class FontSizeRenderState
extends RenderStateDelegator {
    private final float fontSize;
    private final int fontStyle;
    private Font iFont;
    private FontMetrics iFontMetrics;
    Map iWordInfoMap = null;

    public FontSizeRenderState(RenderState prevRenderState, float fontSize, int fontStyle) {
        super(prevRenderState);
        this.fontSize = fontSize;
        this.fontStyle = fontStyle;
    }

    public FontSizeRenderState(RenderState prevRenderState, float fontSize) {
        super(prevRenderState);
        this.fontSize = fontSize;
        this.fontStyle = 0;
    }

    public Font getFont() {
        Font f10 = this.iFont;
        if (f10 != null) {
            return f10;
        }
        Font parentFont = this.prevRenderState.getFont();
        f10 = parentFont.deriveFont(this.fontSize);
        this.iFont = f10 = f10.deriveFont(this.fontStyle | f10.getStyle());
        return f10;
    }

    public FontMetrics getFontMetrics() {
        FontMetrics fm2 = this.iFontMetrics;
        if (fm2 == null) {
            this.iFontMetrics = fm2 = Toolkit.getDefaultToolkit().getFontMetrics(this.getFont());
        }
        return fm2;
    }

    public void invalidate() {
        this.prevRenderState.invalidate();
        this.iFont = null;
        this.iFontMetrics = null;
        Map map = this.iWordInfoMap;
        if (map != null) {
            map.clear();
        }
    }

    public final WordInfo getWordInfo(String word) {
        FontMetrics fm2;
        WordInfo wi2;
        HashMap<String, WordInfo> map = this.iWordInfoMap;
        if (map == null) {
            this.iWordInfoMap = map = new HashMap<String, WordInfo>(1);
        }
        if ((wi2 = (WordInfo)map.get(word)) != null) {
            return wi2;
        }
        wi2 = new WordInfo();
        wi2.fontMetrics = fm2 = this.getFontMetrics();
        wi2.ascentPlusLeading = fm2.getAscent() + fm2.getLeading();
        wi2.descent = fm2.getDescent();
        wi2.height = fm2.getHeight();
        wi2.width = fm2.stringWidth(word);
        map.put(word, wi2);
        return wi2;
    }
}

