/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.renderer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.util.Iterator;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.domimpl.ModelNode;
import org.lobobrowser.html.domimpl.NodeImpl;
import org.lobobrowser.html.domimpl.UINode;
import org.lobobrowser.html.renderer.BaseElementRenderable;
import org.lobobrowser.html.renderer.FrameContext;
import org.lobobrowser.html.renderer.RBlockViewport;
import org.lobobrowser.html.renderer.RElement;
import org.lobobrowser.html.renderer.RenderableContainer;
import org.lobobrowser.html.renderer.RenderableSpot;
import org.lobobrowser.html.renderer.UIControl;
import org.lobobrowser.html.style.RenderState;

class RUIControl
extends BaseElementRenderable
implements RElement {
    public final UIControl widget;
    private final ModelNode modelNode;
    private final FrameContext frameContext;
    private int lastAvailWidth = -1;
    private int lastAvailHeight = -1;
    private int declaredWidth = -1;
    private int declaredHeight = -1;

    public RUIControl(ModelNode me2, UIControl widget, RenderableContainer container, FrameContext frameContext, UserAgentContext ucontext) {
        super(container, me2, ucontext);
        this.modelNode = me2;
        this.widget = widget;
        this.frameContext = frameContext;
        widget.setRUIControl(this);
    }

    public void focus() {
        super.focus();
        Component c10 = this.widget.getComponent();
        c10.requestFocus();
    }

    public final void invalidateLayoutLocal() {
        super.invalidateLayoutLocal();
        this.widget.invalidate();
        this.lastAvailHeight = -1;
        this.lastAvailWidth = -1;
    }

    public int getVAlign() {
        return this.widget.getVAlign();
    }

    public final void paint(Graphics g10) {
        this.widget.paint(g10);
        super.paint(g10);
    }

    public void invalidateRenderStyle() {
    }

    public void repaint(ModelNode modelNode) {
        UIControl widget = this.widget;
        if (widget instanceof UINode) {
            ((UINode)((Object)widget)).repaint(modelNode);
        } else {
            this.repaint();
        }
    }

    public void updateWidgetBounds(int guiX, int guiY) {
        super.updateWidgetBounds(guiX, guiY);
        this.widget.setBounds(guiX, guiY, this.width, this.height);
    }

    public Color getBlockBackgroundColor() {
        return this.widget.getBackgroundColor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean paintSelection(Graphics g10, boolean inSelection, RenderableSpot startPoint, RenderableSpot endPoint) {
        Color over;
        if ((inSelection = super.paintSelection(g10, inSelection, startPoint, endPoint)) && (over = new Color(0, 0, 255, 50)) != null) {
            Color oldColor = g10.getColor();
            try {
                g10.setColor(over);
                g10.fillRect(0, 0, this.width, this.height);
            }
            finally {
                g10.setColor(oldColor);
            }
        }
        return inSelection;
    }

    public boolean extractSelectionText(StringBuffer buffer, boolean inSelection, RenderableSpot startPoint, RenderableSpot endPoint) {
        return inSelection;
    }

    public RenderableSpot getLowestRenderableSpot(int x10, int y10) {
        return new RenderableSpot(this, x10, y10);
    }

    public void doLayout(int availWidth, int availHeight, boolean expandWidth, boolean expandHeight) {
        if (availWidth != this.lastAvailWidth || availHeight != this.lastAvailHeight) {
            this.applyStyle();
            this.lastAvailWidth = availWidth;
            this.lastAvailHeight = availHeight;
            UIControl widget = this.widget;
            widget.reset(availWidth, availHeight);
            RenderState renderState = this.modelNode.getRenderState();
            int dw2 = this.getDeclaredWidth(renderState, availWidth);
            int dh2 = this.getDeclaredHeight(renderState, availHeight);
            this.declaredWidth = dw2;
            this.declaredHeight = dh2;
            if (dw2 == -1 || dh2 == -1) {
                Dimension size = widget.getPreferredSize();
                if (dw2 == -1) {
                    dw2 = size.width;
                }
                if (dh2 == -1) {
                    dh2 = size.height;
                }
            }
            this.width = dw2;
            this.height = dh2;
        }
    }

    public final void preferredSizeInvalidated() {
        int dw2 = this.declaredWidth;
        int dh2 = this.declaredHeight;
        if (dw2 == -1 || dh2 == -1) {
            this.frameContext.delayedRelayout((NodeImpl)this.modelNode);
        } else {
            this.repaint();
        }
    }

    public Iterator getRenderables() {
        return null;
    }

    public Color getPaintedBackgroundColor() {
        return this.container.getPaintedBackgroundColor();
    }

    public Insets getInsets() {
        return RBlockViewport.ZERO_INSETS;
    }
}

