/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.renderer;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.lobobrowser.html.domimpl.ModelNode;
import org.lobobrowser.html.renderer.BaseRCollection;
import org.lobobrowser.html.renderer.BoundableRenderable;
import org.lobobrowser.html.renderer.MarkupUtilities;
import org.lobobrowser.html.renderer.OverflowException;
import org.lobobrowser.html.renderer.RBlank;
import org.lobobrowser.html.renderer.RElement;
import org.lobobrowser.html.renderer.RSpacing;
import org.lobobrowser.html.renderer.RStyleChanger;
import org.lobobrowser.html.renderer.RWord;
import org.lobobrowser.html.renderer.Renderable;
import org.lobobrowser.html.renderer.RenderableContainer;
import org.lobobrowser.html.renderer.RenderableSpot;
import org.lobobrowser.html.style.RenderState;

class RLine
extends BaseRCollection {
    private final ArrayList renderables = new ArrayList(8);
    private int baseLineOffset;
    private int desiredMaxWidth;

    public RLine(ModelNode modelNode, RenderableContainer container, int x10, int y10, int desiredMaxWidth, int height) {
        super(container, modelNode);
        this.x = x10;
        this.y = y10;
        this.width = 0;
        this.height = height;
        this.desiredMaxWidth = desiredMaxWidth;
        this.layoutUpTreeCanBeInvalidated = true;
    }

    public int getBaselineOffset() {
        return this.baseLineOffset;
    }

    protected void invalidateLayoutLocal() {
        this.layoutUpTreeCanBeInvalidated = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g10) {
        Iterator i10;
        RenderState rs2 = this.modelNode.getRenderState();
        if (rs2 != null) {
            Color textColor = rs2.getColor();
            g10.setColor(textColor);
            Font font = rs2.getFont();
            g10.setFont(font);
        }
        if ((i10 = this.renderables.iterator()) != null) {
            while (i10.hasNext()) {
                Object r10 = i10.next();
                if (r10 instanceof RElement) {
                    RElement relement = (RElement)r10;
                    Graphics newG = g10.create(relement.getX(), relement.getY(), relement.getWidth(), relement.getHeight());
                    try {
                        relement.paint(newG);
                        continue;
                    }
                    finally {
                        newG.dispose();
                        continue;
                    }
                }
                if (r10 instanceof BoundableRenderable) {
                    BoundableRenderable br2 = (BoundableRenderable)r10;
                    br2.paintTranslated(g10);
                    continue;
                }
                ((Renderable)r10).paint(g10);
            }
        }
    }

    public final void addStyleChanger(RStyleChanger sc2) {
        this.renderables.add(sc2);
    }

    public final void add(Renderable renderable, boolean allowOverflow) throws OverflowException {
        if (renderable instanceof RWord) {
            this.addWord((RWord)renderable, allowOverflow);
        } else if (renderable instanceof RBlank) {
            this.addBlank((RBlank)renderable);
        } else if (renderable instanceof RElement) {
            this.addElement((RElement)renderable, allowOverflow);
        } else if (renderable instanceof RSpacing) {
            this.addSpacing((RSpacing)renderable);
        } else if (renderable instanceof RStyleChanger) {
            this.addStyleChanger((RStyleChanger)renderable);
        } else {
            throw new IllegalArgumentException("Can't add " + renderable);
        }
    }

    public final void addWord(RWord rword, boolean allowOverflow) throws OverflowException {
        int maxAscentPlusLeading;
        int offset = this.width;
        int wiwidth = rword.width;
        if (!allowOverflow && offset != 0 && offset + wiwidth > this.desiredMaxWidth) {
            Renderable renderable;
            ArrayList renderables = this.renderables;
            ArrayList<RWord> overflow = null;
            boolean cancel = false;
            int i10 = renderables.size();
            while (--i10 >= 0 && ((renderable = (Renderable)renderables.get(i10)) instanceof RWord || !(renderable instanceof BoundableRenderable))) {
                if (overflow == null) {
                    overflow = new ArrayList<RWord>();
                }
                if (renderable != rword && renderable instanceof RWord && ((RWord)renderable).getX() == 0) {
                    cancel = true;
                    break;
                }
                if (renderable instanceof RWord) {
                    int newOffset;
                    this.width = newOffset = ((RWord)renderable).getBounds().x;
                }
                overflow.add(0, (RWord)renderable);
                renderables.remove(i10);
            }
            if (!cancel) {
                if (overflow == null) {
                    throw new OverflowException(Collections.singleton(rword));
                }
                overflow.add(rword);
                throw new OverflowException(overflow);
            }
        }
        int extraHeight = 0;
        int maxDescent = this.height - this.baseLineOffset;
        if (rword.descent > maxDescent) {
            extraHeight += rword.descent - maxDescent;
        }
        if (rword.ascentPlusLeading > (maxAscentPlusLeading = this.baseLineOffset)) {
            extraHeight += rword.ascentPlusLeading - maxAscentPlusLeading;
        }
        if (extraHeight > 0) {
            int newHeight = this.height + extraHeight;
            this.adjustHeight(newHeight, newHeight, 4);
        }
        this.renderables.add(rword);
        rword.setParent(this);
        int x10 = offset;
        this.width = offset += wiwidth;
        rword.setOrigin(x10, this.baseLineOffset - rword.ascentPlusLeading);
    }

    public final void addBlank(RBlank rblank) {
        int x10 = this.width;
        int width = rblank.width;
        rblank.setOrigin(x10, this.baseLineOffset - rblank.ascentPlusLeading);
        this.renderables.add(rblank);
        rblank.setParent(this);
        this.width = x10 + width;
    }

    public final void addSpacing(RSpacing rblank) {
        int x10 = this.width;
        int width = rblank.width;
        rblank.setOrigin(x10, (this.height - rblank.height) / 2);
        this.renderables.add(rblank);
        rblank.setParent(this);
        this.width = x10 + width;
    }

    private final void setElementY(RElement relement, int elementHeight, int valign) {
        int yoffset;
        switch (valign) {
            case 4: {
                yoffset = this.height - elementHeight;
                break;
            }
            case 3: {
                yoffset = (this.height - elementHeight) / 2;
                break;
            }
            case 2: 
            case 5: {
                yoffset = this.baseLineOffset - elementHeight;
                break;
            }
            case 1: {
                yoffset = this.baseLineOffset - elementHeight / 2;
                break;
            }
            case 0: {
                yoffset = 0;
                break;
            }
            default: {
                yoffset = this.baseLineOffset - elementHeight;
            }
        }
        relement.setY(yoffset);
    }

    public final void addElement(RElement relement, boolean allowOverflow) throws OverflowException {
        int newX;
        int requiredHeight;
        int boundsw = this.width;
        int desiredMaxWidth = this.desiredMaxWidth;
        int pw2 = relement.getWidth();
        int offset = boundsw;
        if (!allowOverflow && offset != 0 && offset + pw2 > desiredMaxWidth) {
            throw new OverflowException(Collections.singleton(relement));
        }
        int boundsh = this.height;
        int ph2 = relement.getHeight();
        int valign = relement.getVAlign();
        switch (valign) {
            case 2: 
            case 5: {
                requiredHeight = ph2 + (boundsh - this.baseLineOffset);
                break;
            }
            case 1: {
                requiredHeight = Math.max(ph2, ph2 / 2 + (boundsh - this.baseLineOffset));
                break;
            }
            default: {
                requiredHeight = ph2;
            }
        }
        if (requiredHeight > boundsh) {
            this.adjustHeight(requiredHeight, ph2, valign);
        }
        this.renderables.add(relement);
        relement.setParent(this);
        relement.setX(offset);
        this.setElementY(relement, ph2, valign);
        this.width = newX = offset + pw2;
    }

    private void adjustHeight(int newHeight, int elementHeight, int valign) {
        int baseline;
        this.height = newHeight;
        ArrayList renderables = this.renderables;
        FontMetrics firstFm = this.modelNode.getRenderState().getFontMetrics();
        int maxDescent = firstFm.getDescent();
        int maxAscentPlusLeading = firstFm.getAscent() + firstFm.getLeading();
        Iterator i10 = renderables.iterator();
        while (i10.hasNext()) {
            int ascentPlusLeading;
            Object r10 = i10.next();
            if (!(r10 instanceof RStyleChanger)) continue;
            RStyleChanger rstyleChanger = (RStyleChanger)r10;
            FontMetrics fm2 = rstyleChanger.getModelNode().getRenderState().getFontMetrics();
            int descent = fm2.getDescent();
            if (descent > maxDescent) {
                maxDescent = descent;
            }
            if ((ascentPlusLeading = fm2.getAscent() + fm2.getLeading()) <= maxAscentPlusLeading) continue;
            maxAscentPlusLeading = ascentPlusLeading;
        }
        int textHeight = maxDescent + maxAscentPlusLeading;
        switch (valign) {
            case 4: {
                baseline = newHeight - maxDescent;
                break;
            }
            case 3: {
                baseline = (newHeight + textHeight) / 2 - maxDescent;
                break;
            }
            case 2: 
            case 5: {
                baseline = elementHeight;
                break;
            }
            case 1: {
                baseline = newHeight / 2;
                break;
            }
            case 0: {
                baseline = maxAscentPlusLeading;
                break;
            }
            default: {
                baseline = elementHeight;
            }
        }
        this.baseLineOffset = baseline;
        Iterator i11 = renderables.iterator();
        while (i11.hasNext()) {
            Object r11 = i11.next();
            if (r11 instanceof RWord) {
                RWord rword = (RWord)r11;
                rword.setY(baseline - rword.ascentPlusLeading);
                continue;
            }
            if (r11 instanceof RBlank) {
                RBlank rblank = (RBlank)r11;
                rblank.setY(baseline - rblank.ascentPlusLeading);
                continue;
            }
            if (!(r11 instanceof RElement)) continue;
            RElement relement = (RElement)r11;
            this.setElementY(relement, relement.getHeight(), relement.getVAlign());
        }
    }

    public RenderableSpot getLowestRenderableSpot(int x10, int y10) {
        Renderable[] rarray = this.renderables.toArray(Renderable.EMPTY_ARRAY);
        BoundableRenderable br2 = MarkupUtilities.findRenderable(rarray, x10, y10, false);
        if (br2 != null) {
            Rectangle rbounds = br2.getBounds();
            return br2.getLowestRenderableSpot(x10 - rbounds.x, y10 - rbounds.y);
        }
        return new RenderableSpot(this, x10, y10);
    }

    public Color getBlockBackgroundColor() {
        return this.container.getPaintedBackgroundColor();
    }

    public final void adjustHorizontalBounds(int newX, int newMaxWidth) throws OverflowException {
        this.x = newX;
        this.desiredMaxWidth = newMaxWidth;
        int topX = newX + newMaxWidth;
        ArrayList renderables = this.renderables;
        int size = renderables.size();
        ArrayList overflown = null;
        Rectangle lastInLine = null;
        for (int i10 = 0; i10 < size; ++i10) {
            Object r10 = renderables.get(i10);
            if (overflown == null && r10 instanceof BoundableRenderable) {
                BoundableRenderable br2 = (BoundableRenderable)r10;
                Rectangle brb2 = br2.getBounds();
                int x22 = brb2.x + brb2.width;
                if (x22 > topX) {
                    overflown = new ArrayList(1);
                } else {
                    lastInLine = brb2;
                }
            }
            if (overflown == null) continue;
            overflown.add(r10);
            renderables.remove(i10--);
            --size;
        }
        if (overflown != null) {
            if (lastInLine != null) {
                this.width = lastInLine.x + lastInLine.width;
            }
            throw new OverflowException(overflown);
        }
    }

    public Iterator getRenderables() {
        return this.renderables.iterator();
    }
}

