/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.renderer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.ImageObserver;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import org.lobobrowser.html.HttpRequest;
import org.lobobrowser.html.ReadyStateChangeListener;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.domimpl.HTMLDocumentImpl;
import org.lobobrowser.html.domimpl.HTMLElementImpl;
import org.lobobrowser.html.domimpl.ModelNode;
import org.lobobrowser.html.renderer.BaseRCollection;
import org.lobobrowser.html.renderer.DelayedPair;
import org.lobobrowser.html.renderer.RCollection;
import org.lobobrowser.html.renderer.RElement;
import org.lobobrowser.html.renderer.RenderableContainer;
import org.lobobrowser.html.style.BackgroundInfo;
import org.lobobrowser.html.style.CSS2PropertiesImpl;
import org.lobobrowser.html.style.HtmlValues;
import org.lobobrowser.html.style.RenderState;
import org.lobobrowser.util.gui.ColorFactory;

abstract class BaseElementRenderable
extends BaseRCollection
implements RElement,
RenderableContainer,
ImageObserver {
    public static final int OVERFLOW_NONE = 0;
    public static final int OVERFLOW_SCROLL = 1;
    public static final int OVERFLOW_AUTO = 2;
    public static final int OVERFLOW_HIDDEN = 3;
    public static final int OVERFLOW_VISIBLE = 4;
    public static final int OVERFLOW_VERTICAL = 5;
    private Collection guiComponents = null;
    protected Collection delayedPairs = null;
    protected Color backgroundColor;
    protected volatile Image backgroundImage;
    protected int zIndex;
    protected Color borderTopColor;
    protected Color borderLeftColor;
    protected Color borderBottomColor;
    protected Color borderRightColor;
    protected Insets borderInsets;
    protected String lastBackgroundImageUri;
    protected Insets defaultMarginInsets;
    private int cachedOverflow = -1;
    protected final UserAgentContext userAgentContext;
    protected boolean layoutDeepCanBeInvalidated = false;
    protected static final int SCROLL_BAR_THICKNESS = 16;

    public BaseElementRenderable(RenderableContainer container, ModelNode modelNode, UserAgentContext ucontext) {
        super(container, modelNode);
        this.userAgentContext = ucontext;
    }

    public float getAlignmentX() {
        return 0.0f;
    }

    public float getAlignmentY() {
        return 0.0f;
    }

    public final void invalidateLayoutDeep() {
        if (this.layoutDeepCanBeInvalidated) {
            this.layoutDeepCanBeInvalidated = false;
            this.invalidateLayoutLocal();
            Iterator i10 = this.getRenderables();
            if (i10 != null) {
                while (i10.hasNext()) {
                    Object r10 = i10.next();
                    if (!(r10 instanceof RCollection)) continue;
                    ((RCollection)r10).invalidateLayoutDeep();
                }
            }
        }
    }

    protected void invalidateLayoutLocal() {
        this.cachedOverflow = -1;
    }

    protected int getDeclaredWidth(RenderState renderState, int availWidth) {
        ModelNode rootNode = this.modelNode;
        if (rootNode instanceof HTMLElementImpl) {
            HTMLElementImpl element = (HTMLElementImpl)rootNode;
            CSS2PropertiesImpl props = element.getCurrentStyle();
            if (props == null) {
                return -1;
            }
            String widthText = props.getWidth();
            if (widthText == null || "".equals(widthText)) {
                return -1;
            }
            return HtmlValues.getPixelSize(widthText, renderState, -1, availWidth);
        }
        return -1;
    }

    protected int getDeclaredHeight(RenderState renderState, int availHeight) {
        ModelNode rootNode = this.modelNode;
        if (rootNode instanceof HTMLElementImpl) {
            HTMLElementImpl element = (HTMLElementImpl)rootNode;
            CSS2PropertiesImpl props = element.getCurrentStyle();
            if (props == null) {
                return -1;
            }
            String heightText = props.getHeight();
            if (heightText == null || "".equals(heightText)) {
                return -1;
            }
            return HtmlValues.getPixelSize(heightText, renderState, -1, availHeight);
        }
        return -1;
    }

    protected int getOverflow() {
        String overflowTextTL;
        String overflowText;
        HTMLElementImpl element;
        CSS2PropertiesImpl props;
        int co2 = this.cachedOverflow;
        if (co2 != -1) {
            return co2;
        }
        ModelNode rootNode = this.modelNode;
        co2 = rootNode instanceof HTMLElementImpl ? ((props = (element = (HTMLElementImpl)rootNode).getCurrentStyle()) == null ? 0 : ((overflowText = props.getOverflow()) == null ? 0 : ("scroll".equals(overflowTextTL = overflowText.toLowerCase()) ? 1 : ("auto".equals(overflowTextTL) ? 2 : ("vertical".equals(overflowTextTL) ? 5 : ("hidden".equals(overflowTextTL) ? 3 : ("visible".equals(overflowTextTL) ? 4 : 0))))))) : 0;
        this.cachedOverflow = co2;
        return co2;
    }

    public void paint(Graphics g10) {
    }

    public final void layout(int availWidth, int availHeight) {
        this.layout(availWidth, availHeight, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void layout(int availWidth, int availHeight, boolean expandWidth, boolean expandHeight) {
        try {
            this.doLayout(availWidth, availHeight, expandWidth, expandHeight);
        }
        finally {
            this.layoutUpTreeCanBeInvalidated = true;
            this.layoutDeepCanBeInvalidated = true;
        }
    }

    protected abstract void doLayout(int var1, int var2, boolean var3, boolean var4);

    protected final void sendGUIComponentsToParent() {
        Collection gc2 = this.guiComponents;
        int count = 0;
        if (gc2 != null) {
            RenderableContainer rc2 = this.container;
            Iterator i10 = gc2.iterator();
            while (i10.hasNext()) {
                ++count;
                rc2.add((Component)i10.next());
            }
        }
    }

    protected final void clearGUIComponents() {
        Collection gc2 = this.guiComponents;
        if (gc2 != null) {
            gc2.clear();
        }
    }

    public Component add(Component component) {
        HashSet<Component> gc2 = this.guiComponents;
        if (gc2 == null) {
            this.guiComponents = gc2 = new HashSet<Component>(1);
        }
        gc2.add(component);
        return component;
    }

    public void updateAllWidgetBounds() {
        this.container.updateAllWidgetBounds();
    }

    public void updateWidgetBounds() {
        Point guiPoint = this.getGUIPoint(0, 0);
        this.updateWidgetBounds(guiPoint.x, guiPoint.y);
    }

    protected void applyStyle() {
        String backgroundImageUri;
        HTMLElementImpl rootElement;
        ModelNode rootNode = this.modelNode;
        if (rootNode instanceof HTMLDocumentImpl) {
            HTMLDocumentImpl doc = (HTMLDocumentImpl)rootNode;
            rootElement = (HTMLElementImpl)doc.getBody();
        } else {
            rootElement = (HTMLElementImpl)rootNode;
        }
        if (rootElement == null) {
            this.clearStyle();
            this.backgroundColor = null;
            this.backgroundImage = null;
            this.lastBackgroundImageUri = null;
            return;
        }
        RenderState rs2 = rootElement.getRenderState();
        if (rs2 == null) {
            throw new IllegalStateException("Element without render state: " + rootElement + "; parent=" + rootElement.getParentNode());
        }
        BackgroundInfo binfo = rs2.getBackgroundInfo();
        this.backgroundColor = binfo == null ? null : binfo.backgroundColor;
        String string = backgroundImageUri = binfo == null ? null : binfo.backgroundImage;
        if (backgroundImageUri == null) {
            this.backgroundImage = null;
            this.lastBackgroundImageUri = null;
        } else if (!backgroundImageUri.equals(this.lastBackgroundImageUri)) {
            this.lastBackgroundImageUri = backgroundImageUri;
            this.loadBackgroundImage(backgroundImageUri);
        }
        CSS2PropertiesImpl props = rootElement.getCurrentStyle();
        if (props == null) {
            this.clearStyle();
        } else {
            String zIndex;
            String borderRightColorText;
            String borderBottomColorText;
            String borderLeftColorText;
            String borderTopColorText;
            this.borderInsets = null;
            this.borderTopColor = null;
            this.borderLeftColor = null;
            this.borderBottomColor = null;
            this.borderRightColor = null;
            String border = props.getBorder();
            if (border != null) {
                this.applyBorder(rs2, border);
            }
            this.borderInsets = HtmlValues.getBorderInsets(this.borderInsets, props, rs2);
            String borderColorText = props.getBorderColor();
            if (borderColorText != null) {
                Color[] colorsArray = HtmlValues.getColors(borderColorText);
                this.borderTopColor = colorsArray[0];
                this.borderLeftColor = colorsArray[1];
                this.borderBottomColor = colorsArray[2];
                this.borderRightColor = colorsArray[3];
            }
            if ((borderTopColorText = props.getBorderTopColor()) != null) {
                this.borderTopColor = ColorFactory.getInstance().getColor(borderTopColorText);
            }
            if ((borderLeftColorText = props.getBorderLeftColor()) != null) {
                this.borderLeftColor = ColorFactory.getInstance().getColor(borderLeftColorText);
            }
            if ((borderBottomColorText = props.getBorderBottomColor()) != null) {
                this.borderBottomColor = ColorFactory.getInstance().getColor(borderBottomColorText);
            }
            if ((borderRightColorText = props.getBorderRightColor()) != null) {
                this.borderRightColor = ColorFactory.getInstance().getColor(borderRightColorText);
            }
            if ((zIndex = props.getZIndex()) != null) {
                try {
                    this.zIndex = Integer.parseInt(zIndex);
                }
                catch (NumberFormatException err) {
                    this.zIndex = 0;
                }
            } else {
                this.zIndex = 0;
            }
        }
    }

    protected void loadBackgroundImage(String uri) {
        ModelNode rc2 = this.modelNode;
        UserAgentContext ctx = this.userAgentContext;
        if (ctx != null) {
            final HttpRequest request = ctx.createHttpRequest();
            request.addReadyStateChangeListener(new ReadyStateChangeListener(){

                public void readyStateChanged() {
                    int status;
                    int readyState = request.getReadyState();
                    if (readyState == 4 && ((status = request.getStatus()) == 200 || status == 0)) {
                        Image img;
                        BaseElementRenderable.this.backgroundImage = img = request.getResponseImage();
                        int w10 = img.getWidth(BaseElementRenderable.this);
                        int h10 = img.getHeight(BaseElementRenderable.this);
                        if (w10 != -1 && h10 != -1) {
                            BaseElementRenderable.this.repaint();
                        }
                    }
                }
            });
            try {
                final URL fullUrl = rc2.getFullURL(uri);
                SecurityManager sm2 = System.getSecurityManager();
                if (sm2 == null) {
                    request.open("GET", fullUrl);
                } else {
                    AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            request.open("GET", fullUrl);
                            return null;
                        }
                    });
                }
            }
            catch (MalformedURLException mfu) {
                rc2.warn("Bad image URI: [" + uri + "]", mfu);
            }
        }
    }

    public int getZIndex() {
        return this.zIndex;
    }

    void applyBorder(RenderState renderState, String border) {
        String[] tokens = HtmlValues.splitCssValue(border);
        for (int i10 = 0; i10 < tokens.length; ++i10) {
            Insets bi2;
            String token = tokens[i10];
            if (HtmlValues.isLength(token)) {
                Insets bi3;
                int pixelSize = HtmlValues.getPixelSize(token, renderState, 0);
                this.borderInsets = bi3 = new Insets(pixelSize, pixelSize, pixelSize, pixelSize);
                continue;
            }
            if (ColorFactory.getInstance().isColor(token)) {
                Color color;
                this.borderLeftColor = color = ColorFactory.getInstance().getColor(token);
                this.borderRightColor = color;
                this.borderTopColor = color;
                this.borderBottomColor = color;
                continue;
            }
            if (!HtmlValues.isBorderStyle(token) || !"solid".equalsIgnoreCase(token) && !"dashed".equalsIgnoreCase(token) || (bi2 = this.borderInsets) != null) continue;
            this.borderInsets = bi2 = new Insets(4, 4, 4, 4);
        }
    }

    private Color getBorderTopColor() {
        Color c10 = this.borderTopColor;
        return c10 == null ? Color.black : c10;
    }

    private Color getBorderLeftColor() {
        Color c10 = this.borderLeftColor;
        return c10 == null ? Color.black : c10;
    }

    private Color getBorderBottomColor() {
        Color c10 = this.borderBottomColor;
        return c10 == null ? Color.black : c10;
    }

    private Color getBorderRightColor() {
        Color c10 = this.borderRightColor;
        return c10 == null ? Color.black : c10;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void prePaint(Graphics g10) {
        Insets borderInsets;
        int startWidth = this.width;
        int startHeight = this.height;
        int totalWidth = startWidth;
        int totalHeight = startHeight;
        int startX = 0;
        int startY = 0;
        ModelNode node = this.modelNode;
        RenderState rs2 = node.getRenderState();
        Insets marginInsets = this.getMarginInsets(rs2);
        if (marginInsets != null) {
            totalWidth -= marginInsets.left + marginInsets.right;
            totalHeight -= marginInsets.top + marginInsets.bottom;
            startX += marginInsets.left;
            startY += marginInsets.top;
        }
        if ((borderInsets = this.borderInsets) != null) {
            int bleft = borderInsets.left;
            int newStartX = startX + bleft;
            int btop = borderInsets.top;
            int newStartY = startY + btop;
            int bright = borderInsets.right;
            int newTotalWidth = totalWidth - (bleft + bright);
            int bbottom = borderInsets.bottom;
            int newTotalHeight = totalHeight - (btop + bbottom);
            Rectangle clientRegion = new Rectangle(newStartX, newStartY, newTotalWidth, newTotalHeight);
            Rectangle clipBounds = g10.getClipBounds();
            if (!clientRegion.contains(clipBounds)) {
                int i10;
                int i11;
                if (btop > 0) {
                    g10.setColor(this.getBorderTopColor());
                    for (i11 = 0; i11 < btop; ++i11) {
                        int leftOffset = i11 * bleft / btop;
                        int rightOffset = i11 * bright / btop;
                        g10.drawLine(startX + leftOffset, startY + i11, startX + totalWidth - rightOffset - 1, startY + i11);
                    }
                }
                if (bright > 0) {
                    g10.setColor(this.getBorderRightColor());
                    int lastX = startX + totalWidth - 1;
                    for (i10 = 0; i10 < bright; ++i10) {
                        int topOffset = i10 * btop / bright;
                        int bottomOffset = i10 * bbottom / bright;
                        g10.drawLine(lastX - i10, startY + topOffset, lastX - i10, startY + totalHeight - bottomOffset - 1);
                    }
                }
                if (bleft > 0) {
                    g10.setColor(this.getBorderLeftColor());
                    for (i11 = 0; i11 < bleft; ++i11) {
                        int topOffset = i11 * btop / bleft;
                        int bottomOffset = i11 * bbottom / bleft;
                        g10.drawLine(startX + i11, startY + topOffset, startX + i11, startY + totalHeight - bottomOffset - 1);
                    }
                }
                if (bbottom > 0) {
                    g10.setColor(this.getBorderBottomColor());
                    int lastY = startY + totalHeight - 1;
                    for (i10 = 0; i10 < bbottom; ++i10) {
                        int leftOffset = i10 * bleft / bbottom;
                        int rightOffset = i10 * bright / bbottom;
                        g10.drawLine(startX + leftOffset, lastY - i10, startX + totalWidth - rightOffset - 1, lastY - i10);
                    }
                }
            }
            totalWidth = newTotalWidth;
            totalHeight = newTotalHeight;
            startX = newStartX;
            startY = newStartY;
        }
        Graphics clientG = g10.create(startX, startY, totalWidth, totalHeight);
        try {
            Rectangle bkgBounds = null;
            if (node == null) return;
            Color bkg = this.backgroundColor;
            if (bkg != null && bkg.getAlpha() > 0) {
                clientG.setColor(bkg);
                bkgBounds = clientG.getClipBounds();
                clientG.fillRect(bkgBounds.x, bkgBounds.y, bkgBounds.width, bkgBounds.height);
            }
            BackgroundInfo binfo = rs2 == null ? null : rs2.getBackgroundInfo();
            Image image = this.backgroundImage;
            if (image == null) return;
            if (bkgBounds == null) {
                bkgBounds = clientG.getClipBounds();
            }
            int w10 = image.getWidth(this);
            int h10 = image.getHeight(this);
            if (w10 == -1 || h10 == -1) return;
            switch (binfo == null ? 0 : binfo.backgroundRepeat) {
                case 1: {
                    int imageX = binfo.backgroundXPositionAbsolute ? binfo.backgroundXPosition : binfo.backgroundXPosition * (totalWidth - w10) / 100;
                    int imageY = binfo.backgroundYPositionAbsolute ? binfo.backgroundYPosition : binfo.backgroundYPosition * (totalHeight - h10) / 100;
                    clientG.drawImage(image, imageX, imageY, w10, h10, this);
                    return;
                }
                case 2: {
                    int imageY = binfo.backgroundYPositionAbsolute ? binfo.backgroundYPosition : binfo.backgroundYPosition * (totalHeight - h10) / 100;
                    int topX = bkgBounds.x + bkgBounds.width;
                    for (int x10 = bkgBounds.x / w10 * w10; x10 < topX; x10 += w10) {
                        clientG.drawImage(image, x10, imageY, w10, h10, this);
                    }
                    return;
                }
                case 3: {
                    int imageX = binfo.backgroundXPositionAbsolute ? binfo.backgroundXPosition : binfo.backgroundXPosition * (totalWidth - w10) / 100;
                    int topY = bkgBounds.y + bkgBounds.height;
                    for (int y10 = bkgBounds.y / h10 * h10; y10 < topY; y10 += h10) {
                        clientG.drawImage(image, imageX, y10, w10, h10, this);
                    }
                    return;
                }
                default: {
                    int baseX = bkgBounds.x / w10 * w10;
                    int baseY = bkgBounds.y / h10 * h10;
                    int topX = bkgBounds.x + bkgBounds.width;
                    int topY = bkgBounds.y + bkgBounds.height;
                    for (int x11 = baseX; x11 < topX; x11 += w10) {
                        for (int y11 = baseY; y11 < topY; y11 += h10) {
                            clientG.drawImage(image, x11, y11, w10, h10, this);
                        }
                    }
                    return;
                }
            }
        }
        finally {
            clientG.dispose();
        }
    }

    void clearStyle() {
        this.borderInsets = null;
        this.borderTopColor = null;
        this.borderLeftColor = null;
        this.borderBottomColor = null;
        this.borderRightColor = null;
        this.zIndex = 0;
    }

    protected final Insets getMarginInsets(RenderState rs2) {
        Insets mi2 = rs2.getMarginInsets();
        if (mi2 == null) {
            return this.defaultMarginInsets;
        }
        return mi2;
    }

    public boolean imageUpdate(Image img, int infoflags, int x10, int y10, int w10, int h10) {
        if ((infoflags & 0x20) != 0 || (infoflags & 0x10) != 0) {
            this.repaint();
        }
        return true;
    }

    public Insets getInsets(boolean hscroll, boolean vscroll) {
        RenderState rs2 = this.modelNode.getRenderState();
        Insets mi2 = this.getMarginInsets(rs2);
        Insets bi2 = this.borderInsets;
        int top = 0;
        int bottom = 0;
        int left = 0;
        int right = 0;
        if (mi2 != null) {
            top += mi2.top;
            left += mi2.left;
            bottom += mi2.bottom;
            right += mi2.right;
        }
        if (bi2 != null) {
            top += bi2.top;
            left += bi2.left;
            bottom += bi2.bottom;
            right += bi2.right;
        }
        if (hscroll) {
            bottom += 16;
        }
        if (vscroll) {
            right += 16;
        }
        return new Insets(top, left, bottom, right);
    }

    protected final void sendDelayedPairsToParent() {
        Collection gc2 = this.delayedPairs;
        if (gc2 != null) {
            RenderableContainer rc2 = this.container;
            Iterator i10 = gc2.iterator();
            while (i10.hasNext()) {
                DelayedPair pair = (DelayedPair)i10.next();
                if (pair.targetParent == this) continue;
                rc2.addDelayedPair(pair);
            }
        }
    }

    public final void clearDelayedPairs() {
        Collection gc2 = this.delayedPairs;
        if (gc2 != null) {
            gc2.clear();
        }
    }

    public final Collection getDelayedPairs() {
        return this.delayedPairs;
    }

    public void addDelayedPair(DelayedPair pair) {
        LinkedList<DelayedPair> gc2 = this.delayedPairs;
        if (gc2 == null) {
            this.delayedPairs = gc2 = new LinkedList<DelayedPair>();
        }
        gc2.add(pair);
    }

    public RenderableContainer getParentContainer() {
        return this.container;
    }
}

