/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.domimpl;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.lobobrowser.html.HtmlRendererContext;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.domimpl.ChildHTMLCollection;
import org.lobobrowser.html.domimpl.HTMLDocumentImpl;
import org.lobobrowser.html.domimpl.HTMLElementImpl;
import org.lobobrowser.html.domimpl.ModelNode;
import org.lobobrowser.html.domimpl.NodeFilter;
import org.lobobrowser.html.domimpl.NodeListImpl;
import org.lobobrowser.html.domimpl.NodeVisitor;
import org.lobobrowser.html.domimpl.SkipVisitorException;
import org.lobobrowser.html.domimpl.StopVisitorException;
import org.lobobrowser.html.domimpl.TextFilter;
import org.lobobrowser.html.domimpl.TextImpl;
import org.lobobrowser.html.domimpl.UINode;
import org.lobobrowser.html.style.RenderState;
import org.lobobrowser.html.style.StyleSheetRenderState;
import org.lobobrowser.util.Objects;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.UserDataHandler;

public abstract class NodeImpl
implements Node,
ModelNode {
    private static final NodeImpl[] EMPTY_ARRAY = new NodeImpl[0];
    private static final RenderState INVALID_RENDER_STATE = new StyleSheetRenderState(null, null);
    protected static final Logger logger = Logger.getLogger((class$org$lobobrowser$html$domimpl$NodeImpl == null ? (class$org$lobobrowser$html$domimpl$NodeImpl = NodeImpl.class$("org.lobobrowser.html.domimpl.NodeImpl")) : class$org$lobobrowser$html$domimpl$NodeImpl).getName());
    protected UINode uiNode;
    protected ArrayList nodeList;
    protected volatile Document document;
    protected volatile Object treeLock = this;
    private ChildHTMLCollection childrenCollection;
    private Map userData;
    private List userDataHandlers;
    protected volatile boolean notificationsSuspended = false;
    private volatile String prefix;
    protected volatile Node parentNode;
    private RenderState renderState = INVALID_RENDER_STATE;
    static /* synthetic */ Class class$org$lobobrowser$html$domimpl$NodeImpl;

    public void setUINode(UINode uiNode) {
        this.uiNode = uiNode;
    }

    public UINode getUINode() {
        return this.uiNode;
    }

    public UINode findUINode() {
        UINode uiNode = this.uiNode;
        if (uiNode != null) {
            return uiNode;
        }
        NodeImpl parentNode = (NodeImpl)this.getParentNode();
        return parentNode == null ? null : parentNode.findUINode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node appendChild(Node newChild) throws DOMException {
        Object object = this.treeLock;
        synchronized (object) {
            ArrayList<Node> nl2 = this.nodeList;
            if (nl2 == null) {
                this.nodeList = nl2 = new ArrayList<Node>(3);
            }
            nl2.add(newChild);
            if (newChild instanceof NodeImpl) {
                ((NodeImpl)newChild).setParentImpl(this);
            }
        }
        if (!this.notificationsSuspended) {
            this.informInvalid();
        }
        return newChild;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeAllChildren() {
        Object object = this.treeLock;
        synchronized (object) {
            this.removeAllChildrenImpl();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeAllChildrenImpl() {
        Object object = this.treeLock;
        synchronized (object) {
            ArrayList nl2 = this.nodeList;
            if (nl2 != null) {
                nl2.clear();
            }
        }
        if (!this.notificationsSuspended) {
            this.informInvalid();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NodeList getNodeList(NodeFilter filter) {
        ArrayList collection = new ArrayList();
        Object object = this.treeLock;
        synchronized (object) {
            this.appendChildrenToCollectionImpl(filter, collection);
        }
        return new NodeListImpl(collection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeImpl[] getChildrenArray() {
        ArrayList nl2 = this.nodeList;
        Object object = this.treeLock;
        synchronized (object) {
            return nl2 == null ? null : nl2.toArray(EMPTY_ARRAY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getChildCount() {
        ArrayList nl2 = this.nodeList;
        Object object = this.treeLock;
        synchronized (object) {
            return nl2 == null ? 0 : nl2.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChildHTMLCollection getChildren() {
        NodeImpl nodeImpl = this;
        synchronized (nodeImpl) {
            ChildHTMLCollection collection = this.childrenCollection;
            if (collection == null) {
                this.childrenCollection = collection = new ChildHTMLCollection(this);
            }
            return collection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getDescendents(NodeFilter filter) {
        ArrayList al2 = new ArrayList();
        Object object = this.treeLock;
        synchronized (object) {
            this.extractDescendentsArrayImpl(filter, al2);
        }
        return al2;
    }

    private void extractDescendentsArrayImpl(NodeFilter filter, ArrayList al2) {
        ArrayList nl2 = this.nodeList;
        if (nl2 != null) {
            Iterator i10 = nl2.iterator();
            while (i10.hasNext()) {
                NodeImpl n10 = (NodeImpl)i10.next();
                if (filter.accept(n10)) {
                    al2.add(n10);
                    continue;
                }
                if (n10.getNodeType() != 1) continue;
                n10.extractDescendentsArrayImpl(filter, al2);
            }
        }
    }

    private void appendChildrenToCollectionImpl(NodeFilter filter, Collection collection) {
        ArrayList nl2 = this.nodeList;
        if (nl2 != null) {
            Iterator i10 = nl2.iterator();
            while (i10.hasNext()) {
                NodeImpl node = (NodeImpl)i10.next();
                if (filter.accept(node)) {
                    collection.add(node);
                }
                node.appendChildrenToCollectionImpl(filter, collection);
            }
        }
    }

    protected abstract Node createSimilarNode();

    public Node cloneNode(boolean deep) {
        try {
            Node newNode = this.createSimilarNode();
            NodeList children = this.getChildNodes();
            int length = children.getLength();
            for (int i10 = 0; i10 < length; ++i10) {
                Node child = children.item(i10);
                Node newChild = deep ? child.cloneNode(deep) : child;
                newNode.appendChild(newChild);
            }
            if (newNode instanceof Element) {
                Element elem = (Element)newNode;
                NamedNodeMap nnmap = this.getAttributes();
                if (nnmap != null) {
                    int nnlength = nnmap.getLength();
                    for (int i11 = 0; i11 < nnlength; ++i11) {
                        Attr attr = (Attr)nnmap.item(i11);
                        elem.setAttributeNode((Attr)attr.cloneNode(true));
                    }
                }
            }
            return newNode;
        }
        catch (Exception err) {
            throw new IllegalStateException(err.getMessage());
        }
    }

    private int getNodeIndex() {
        NodeImpl parent = (NodeImpl)this.getParentNode();
        return parent == null ? -1 : parent.getChildIndex(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getChildIndex(Node child) {
        Object object = this.treeLock;
        synchronized (object) {
            ArrayList nl2 = this.nodeList;
            return nl2 == null ? -1 : nl2.indexOf(child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Node getChildAtIndex(int index) {
        Object object = this.treeLock;
        synchronized (object) {
            ArrayList nl2 = this.nodeList;
            try {
                return nl2 == null ? null : (Node)nl2.get(index);
            }
            catch (IndexOutOfBoundsException iob2) {
                this.warn("getChildAtIndex(): Bad index=" + index + " for node=" + this + ".");
                return null;
            }
        }
    }

    private boolean isAncestorOf(Node other) {
        NodeImpl parent = (NodeImpl)other.getParentNode();
        if (parent == this) {
            return true;
        }
        if (parent == null) {
            return false;
        }
        return this.isAncestorOf(parent);
    }

    public short compareDocumentPosition(Node other) throws DOMException {
        Node parent = this.getParentNode();
        if (!(other instanceof NodeImpl)) {
            throw new DOMException(9, "Unknwon node implementation");
        }
        if (parent != null && parent == other.getParentNode()) {
            int thisIndex = this.getNodeIndex();
            int otherIndex = ((NodeImpl)other).getNodeIndex();
            if (thisIndex == -1 || otherIndex == -1) {
                return 32;
            }
            if (thisIndex < otherIndex) {
                return 4;
            }
            return 2;
        }
        if (this.isAncestorOf(other)) {
            return 16;
        }
        if (((NodeImpl)other).isAncestorOf(this)) {
            return 8;
        }
        return 1;
    }

    public NamedNodeMap getAttributes() {
        return null;
    }

    public Document getOwnerDocument() {
        return this.document;
    }

    void setOwnerDocument(Document value) {
        this.document = value;
        this.treeLock = value == null ? this : value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setOwnerDocument(Document value, boolean deep) {
        this.document = value;
        Object object = this.treeLock = value == null ? this : value;
        if (deep) {
            Object object2 = this.treeLock;
            synchronized (object2) {
                ArrayList nl2 = this.nodeList;
                if (nl2 != null) {
                    Iterator i10 = nl2.iterator();
                    while (i10.hasNext()) {
                        NodeImpl child = (NodeImpl)i10.next();
                        child.setOwnerDocument(value, deep);
                    }
                }
            }
        }
    }

    void visitImpl(NodeVisitor visitor) {
        try {
            visitor.visit(this);
        }
        catch (SkipVisitorException sve) {
            return;
        }
        catch (StopVisitorException sve) {
            throw sve;
        }
        ArrayList nl2 = this.nodeList;
        if (nl2 != null) {
            Iterator i10 = nl2.iterator();
            while (i10.hasNext()) {
                NodeImpl child = (NodeImpl)i10.next();
                child.visit(visitor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void visit(NodeVisitor visitor) {
        Object object = this.treeLock;
        synchronized (object) {
            this.visitImpl(visitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        Object object = this.treeLock;
        synchronized (object) {
            int idx;
            ArrayList nl2 = this.nodeList;
            int n10 = idx = nl2 == null ? -1 : nl2.indexOf(refChild);
            if (idx == -1) {
                throw new DOMException(8, "refChild not found");
            }
            nl2.add(idx, newChild);
            if (newChild instanceof NodeImpl) {
                ((NodeImpl)newChild).setParentImpl(this);
            }
        }
        if (!this.notificationsSuspended) {
            this.informInvalid();
        }
        return newChild;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Node insertAt(Node newChild, int idx) throws DOMException {
        Object object = this.treeLock;
        synchronized (object) {
            ArrayList<Node> nl2 = this.nodeList;
            if (nl2 == null) {
                this.nodeList = nl2 = new ArrayList<Node>();
            }
            nl2.add(idx, newChild);
            if (newChild instanceof NodeImpl) {
                ((NodeImpl)newChild).setParentImpl(this);
            }
        }
        if (!this.notificationsSuspended) {
            this.informInvalid();
        }
        return newChild;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        Object object = this.treeLock;
        synchronized (object) {
            int idx;
            ArrayList nl2 = this.nodeList;
            int n10 = idx = nl2 == null ? -1 : nl2.indexOf(oldChild);
            if (idx == -1) {
                throw new DOMException(8, "oldChild not found");
            }
            nl2.set(idx, newChild);
        }
        if (!this.notificationsSuspended) {
            this.informInvalid();
        }
        return newChild;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node removeChild(Node oldChild) throws DOMException {
        Object object = this.treeLock;
        synchronized (object) {
            ArrayList nl2 = this.nodeList;
            if (nl2 == null || !nl2.remove(oldChild)) {
                throw new DOMException(8, "oldChild not found");
            }
        }
        if (!this.notificationsSuspended) {
            this.informInvalid();
        }
        return oldChild;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node removeChildAt(int index) throws DOMException {
        try {
            Object object = this.treeLock;
            synchronized (object) {
                ArrayList nl2 = this.nodeList;
                if (nl2 == null) {
                    throw new DOMException(1, "Empty list of children");
                }
                Node n10 = (Node)nl2.remove(index);
                if (n10 == null) {
                    throw new DOMException(1, "No node with that index");
                }
                Node node = n10;
                return node;
            }
        }
        finally {
            if (!this.notificationsSuspended) {
                this.informInvalid();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasChildNodes() {
        Object object = this.treeLock;
        synchronized (object) {
            ArrayList nl2 = this.nodeList;
            return nl2 != null && !nl2.isEmpty();
        }
    }

    public String getBaseURI() {
        Document document = this.document;
        return document == null ? null : document.getBaseURI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeList getChildNodes() {
        Object object = this.treeLock;
        synchronized (object) {
            ArrayList nl2 = this.nodeList;
            return new NodeListImpl(nl2 == null ? Collections.EMPTY_LIST : nl2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node getFirstChild() {
        Object object = this.treeLock;
        synchronized (object) {
            ArrayList nl2 = this.nodeList;
            try {
                return nl2 == null ? null : (Node)nl2.get(0);
            }
            catch (IndexOutOfBoundsException iob2) {
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node getLastChild() {
        Object object = this.treeLock;
        synchronized (object) {
            ArrayList nl2 = this.nodeList;
            try {
                return nl2 == null ? null : (Node)nl2.get(nl2.size() - 1);
            }
            catch (IndexOutOfBoundsException iob2) {
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node getPreviousTo(Node node) {
        Object object = this.treeLock;
        synchronized (object) {
            int idx;
            ArrayList nl2 = this.nodeList;
            int n10 = idx = nl2 == null ? -1 : nl2.indexOf(node);
            if (idx == -1) {
                throw new DOMException(8, "node not found");
            }
            try {
                return (Node)nl2.get(idx - 1);
            }
            catch (IndexOutOfBoundsException iob2) {
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node getNextTo(Node node) {
        Object object = this.treeLock;
        synchronized (object) {
            int idx;
            ArrayList nl2 = this.nodeList;
            int n10 = idx = nl2 == null ? -1 : nl2.indexOf(node);
            if (idx == -1) {
                throw new DOMException(8, "node not found");
            }
            try {
                return (Node)nl2.get(idx + 1);
            }
            catch (IndexOutOfBoundsException iob2) {
                return null;
            }
        }
    }

    public Node getPreviousSibling() {
        NodeImpl parent = (NodeImpl)this.getParentNode();
        return parent == null ? null : parent.getPreviousTo(this);
    }

    public Node getNextSibling() {
        NodeImpl parent = (NodeImpl)this.getParentNode();
        return parent == null ? null : parent.getNextTo(this);
    }

    public Object getFeature(String feature, String version) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object setUserData(String key, Object data, UserDataHandler handler) {
        if ("cobra.suspend".equals(key)) {
            boolean ns2;
            this.notificationsSuspended = ns2 = Boolean.TRUE == data;
            if (!ns2) {
                this.informNodeLoaded();
            }
        }
        NodeImpl nodeImpl = this;
        synchronized (nodeImpl) {
            HashMap<String, Object> userData;
            if (handler != null) {
                if (this.userDataHandlers == null) {
                    this.userDataHandlers = new LinkedList();
                }
                this.userDataHandlers.add(handler);
            }
            if ((userData = this.userData) == null) {
                this.userData = userData = new HashMap<String, Object>();
            }
            return userData.put(key, data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getUserData(String key) {
        NodeImpl nodeImpl = this;
        synchronized (nodeImpl) {
            Map ud2 = this.userData;
            return ud2 == null ? null : ud2.get(key);
        }
    }

    public abstract String getLocalName();

    public boolean hasAttributes() {
        return false;
    }

    public String getNamespaceURI() {
        return null;
    }

    public abstract String getNodeName();

    public abstract String getNodeValue() throws DOMException;

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) throws DOMException {
        this.prefix = prefix;
    }

    public abstract void setNodeValue(String var1) throws DOMException;

    public abstract short getNodeType();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTextContent() throws DOMException {
        StringBuffer sb2 = new StringBuffer();
        Object object = this.treeLock;
        synchronized (object) {
            ArrayList nl2 = this.nodeList;
            if (nl2 != null) {
                Iterator i10 = nl2.iterator();
                while (i10.hasNext()) {
                    Node node = (Node)i10.next();
                    short type = node.getNodeType();
                    switch (type) {
                        case 1: 
                        case 3: 
                        case 4: {
                            String textContent = node.getTextContent();
                            if (textContent == null) break;
                            sb2.append(textContent);
                            break;
                        }
                    }
                }
            }
        }
        return sb2.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTextContent(String textContent) throws DOMException {
        Object object = this.treeLock;
        synchronized (object) {
            this.removeChildrenImpl(new TextFilter());
            if (textContent != null && !"".equals(textContent)) {
                TextImpl t10 = new TextImpl(textContent);
                t10.setOwnerDocument(this.document);
                t10.setParentImpl(this);
                ArrayList<TextImpl> nl2 = this.nodeList;
                if (nl2 == null) {
                    this.nodeList = nl2 = new ArrayList<TextImpl>();
                }
                nl2.add(t10);
            }
        }
        if (!this.notificationsSuspended) {
            this.informInvalid();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeChildren(NodeFilter filter) {
        Object object = this.treeLock;
        synchronized (object) {
            this.removeChildrenImpl(filter);
        }
        if (!this.notificationsSuspended) {
            this.informInvalid();
        }
    }

    protected void removeChildrenImpl(NodeFilter filter) {
        ArrayList nl2 = this.nodeList;
        if (nl2 != null) {
            int len;
            int i10 = len = nl2.size();
            while (--i10 >= 0) {
                Node node = (Node)nl2.get(i10);
                if (!filter.accept(node)) continue;
                nl2.remove(i10);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node insertAfter(Node newChild, Node refChild) {
        Object object = this.treeLock;
        synchronized (object) {
            int idx;
            ArrayList nl2 = this.nodeList;
            int n10 = idx = nl2 == null ? -1 : nl2.indexOf(refChild);
            if (idx == -1) {
                throw new DOMException(8, "refChild not found");
            }
            nl2.add(idx + 1, newChild);
            if (newChild instanceof NodeImpl) {
                ((NodeImpl)newChild).setParentImpl(this);
            }
        }
        if (!this.notificationsSuspended) {
            this.informInvalid();
        }
        return newChild;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Text replaceAdjacentTextNodes(Text node, String textContent) {
        try {
            Object object = this.treeLock;
            synchronized (object) {
                ArrayList nl2 = this.nodeList;
                if (nl2 == null) {
                    throw new DOMException(8, "Node not a child");
                }
                int idx = nl2.indexOf(node);
                if (idx == -1) {
                    throw new DOMException(8, "Node not a child");
                }
                int firstIdx = idx;
                LinkedList toDelete = new LinkedList();
                int adjIdx = idx;
                while (--adjIdx >= 0) {
                    Object child = this.nodeList.get(adjIdx);
                    if (!(child instanceof Text)) continue;
                    firstIdx = adjIdx;
                    toDelete.add(child);
                }
                int length = this.nodeList.size();
                int adjIdx2 = idx;
                while (++adjIdx2 < length) {
                    Object child = this.nodeList.get(adjIdx2);
                    if (!(child instanceof Text)) continue;
                    toDelete.add(child);
                }
                this.nodeList.removeAll(toDelete);
                TextImpl textNode = new TextImpl(textContent);
                textNode.setOwnerDocument(this.document);
                textNode.setParentImpl(this);
                this.nodeList.add(firstIdx, textNode);
                TextImpl textImpl = textNode;
                return textImpl;
            }
        }
        finally {
            if (!this.notificationsSuspended) {
                this.informInvalid();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Text replaceAdjacentTextNodes(Text node) {
        try {
            Object object = this.treeLock;
            synchronized (object) {
                ArrayList nl2 = this.nodeList;
                if (nl2 == null) {
                    throw new DOMException(8, "Node not a child");
                }
                int idx = nl2.indexOf(node);
                if (idx == -1) {
                    throw new DOMException(8, "Node not a child");
                }
                StringBuffer textBuffer = new StringBuffer();
                int firstIdx = idx;
                LinkedList toDelete = new LinkedList();
                int adjIdx = idx;
                while (--adjIdx >= 0) {
                    Object child = this.nodeList.get(adjIdx);
                    if (!(child instanceof Text)) continue;
                    firstIdx = adjIdx;
                    toDelete.add(child);
                    textBuffer.append(((Text)child).getNodeValue());
                }
                int length = this.nodeList.size();
                int adjIdx2 = idx;
                while (++adjIdx2 < length) {
                    Object child = this.nodeList.get(adjIdx2);
                    if (!(child instanceof Text)) continue;
                    toDelete.add(child);
                    textBuffer.append(((Text)child).getNodeValue());
                }
                this.nodeList.removeAll(toDelete);
                TextImpl textNode = new TextImpl(textBuffer.toString());
                textNode.setOwnerDocument(this.document);
                textNode.setParentImpl(this);
                this.nodeList.add(firstIdx, textNode);
                TextImpl textImpl = textNode;
                return textImpl;
            }
        }
        finally {
            if (!this.notificationsSuspended) {
                this.informInvalid();
            }
        }
    }

    public Node getParentNode() {
        return this.parentNode;
    }

    public boolean isSameNode(Node other) {
        return this == other;
    }

    public boolean isSupported(String feature, String version) {
        return "HTML".equals(feature) && version.compareTo("4.01") <= 0;
    }

    public String lookupNamespaceURI(String prefix) {
        return null;
    }

    public boolean equalAttributes(Node arg) {
        return false;
    }

    public boolean isEqualNode(Node arg) {
        return arg instanceof NodeImpl && this.getNodeType() == arg.getNodeType() && Objects.equals(this.getNodeName(), arg.getNodeName()) && Objects.equals(this.getNodeValue(), arg.getNodeValue()) && Objects.equals(this.getLocalName(), arg.getLocalName()) && Objects.equals(this.nodeList, ((NodeImpl)arg).nodeList) && this.equalAttributes(arg);
    }

    public boolean isDefaultNamespace(String namespaceURI) {
        return namespaceURI == null;
    }

    public String lookupPrefix(String namespaceURI) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void normalize() {
        Object object = this.treeLock;
        synchronized (object) {
            ArrayList nl2 = this.nodeList;
            if (nl2 != null) {
                Iterator i10 = nl2.iterator();
                LinkedList<Node> textNodes = new LinkedList<Node>();
                boolean prevText = false;
                while (i10.hasNext()) {
                    Node child = (Node)i10.next();
                    if (child.getNodeType() == 3) {
                        if (prevText) continue;
                        prevText = true;
                        textNodes.add(child);
                        continue;
                    }
                    prevText = false;
                }
                i10 = textNodes.iterator();
                while (i10.hasNext()) {
                    Text text = (Text)i10.next();
                    this.replaceAdjacentTextNodes(text);
                }
            }
        }
        if (!this.notificationsSuspended) {
            this.informInvalid();
        }
    }

    public String toString() {
        return this.getNodeName();
    }

    public UserAgentContext getUserAgentContext() {
        Document doc = this.document;
        if (doc instanceof HTMLDocumentImpl) {
            return ((HTMLDocumentImpl)doc).getUserAgentContext();
        }
        return null;
    }

    public HtmlRendererContext getHtmlRendererContext() {
        Document doc = this.document;
        if (doc instanceof HTMLDocumentImpl) {
            return ((HTMLDocumentImpl)doc).getHtmlRendererContext();
        }
        return null;
    }

    final void setParentImpl(Node parent) {
        this.parentNode = parent;
    }

    public float getAlignmentX() {
        return 0.5f;
    }

    public float getAlignmentY() {
        return 0.5f;
    }

    public URL getFullURL(String spec) throws MalformedURLException {
        Document doc = this.document;
        if (doc instanceof HTMLDocumentImpl) {
            return ((HTMLDocumentImpl)doc).getFullURL(spec);
        }
        return new URL(spec);
    }

    public URL getDocumentURL() {
        Document doc = this.document;
        if (doc instanceof HTMLDocumentImpl) {
            return ((HTMLDocumentImpl)doc).getDocumentURL();
        }
        return null;
    }

    public Object getDocumentItem(String name) {
        Document document = this.document;
        return document == null ? null : document.getUserData(name);
    }

    public void setDocumentItem(String name, Object value) {
        Document document = this.document;
        if (document == null) {
            return;
        }
        document.setUserData(name, value, null);
    }

    public final boolean isEqualOrDescendentOf(ModelNode otherContext) {
        if (otherContext == this) {
            return true;
        }
        Node parent = this.getParentNode();
        if (parent instanceof HTMLElementImpl) {
            return ((HTMLElementImpl)parent).isEqualOrDescendentOf(otherContext);
        }
        return false;
    }

    public final ModelNode getParentModelNode() {
        return (ModelNode)((Object)this.parentNode);
    }

    public void warn(String message, Throwable err) {
    }

    public void warn(String message) {
    }

    public void informSizeInvalid() {
        HTMLDocumentImpl doc = (HTMLDocumentImpl)this.document;
        if (doc != null) {
            doc.sizeInvalidated(this);
        }
    }

    public void informLookInvalid() {
        this.forgetRenderState();
        HTMLDocumentImpl doc = (HTMLDocumentImpl)this.document;
        if (doc != null) {
            doc.lookInvalidated(this);
        }
    }

    public void informPositionInvalid() {
        HTMLDocumentImpl doc = (HTMLDocumentImpl)this.document;
        if (doc != null) {
            doc.positionInParentInvalidated(this);
        }
    }

    public void informInvalid() {
        this.forgetRenderState();
        HTMLDocumentImpl doc = (HTMLDocumentImpl)this.document;
        if (doc != null) {
            doc.invalidated(this);
        }
    }

    protected void informNodeLoaded() {
        this.forgetRenderState();
        HTMLDocumentImpl doc = (HTMLDocumentImpl)this.document;
        if (doc != null) {
            doc.nodeLoaded(this);
        }
    }

    public void informLayoutInvalid() {
        this.forgetRenderState();
        HTMLDocumentImpl doc = (HTMLDocumentImpl)this.document;
        if (doc != null) {
            doc.invalidated(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RenderState getRenderState() {
        Object object = this.treeLock;
        synchronized (object) {
            RenderState rs2 = this.renderState;
            if (rs2 != INVALID_RENDER_STATE) {
                return rs2;
            }
            Node parent = this.parentNode;
            if (parent != null || this instanceof Document) {
                RenderState prs = this.getParentRenderState(parent);
                this.renderState = rs2 = this.createRenderState(prs);
                return rs2;
            }
            return null;
        }
    }

    protected final RenderState getParentRenderState(Object parent) {
        if (parent instanceof NodeImpl) {
            return ((NodeImpl)parent).getRenderState();
        }
        return null;
    }

    protected RenderState createRenderState(RenderState prevRenderState) {
        return prevRenderState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void forgetRenderState() {
        Object object = this.treeLock;
        synchronized (object) {
            if (this.renderState != INVALID_RENDER_STATE) {
                this.renderState = INVALID_RENDER_STATE;
                ArrayList nl2 = this.nodeList;
                if (nl2 != null) {
                    Iterator i10 = nl2.iterator();
                    while (i10.hasNext()) {
                        ((NodeImpl)i10.next()).forgetRenderState();
                    }
                }
            }
        }
    }

    static /* synthetic */ Class class$(String x02) {
        try {
            return Class.forName(x02);
        }
        catch (ClassNotFoundException x12) {
            throw new NoClassDefFoundError(x12.getMessage());
        }
    }
}

