/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.util;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;

public final class URLEncoder {
    public static String charset = "UTF8";

    private URLEncoder() {
    }

    public static String encode(String s10) {
        try {
            return URLEncoder.encode(s10, charset);
        }
        catch (UnsupportedEncodingException ex2) {
            throw new IllegalArgumentException(charset);
        }
    }

    public static String encode(String s10, String enc) throws UnsupportedEncodingException {
        if (!URLEncoder.needsEncoding(s10)) {
            return s10;
        }
        int length = s10.length();
        StringBuffer out = new StringBuffer(length);
        ByteArrayOutputStream buf = new ByteArrayOutputStream(10);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)buf, enc));
        for (int i10 = 0; i10 < length; ++i10) {
            int c10 = s10.charAt(i10);
            if (c10 >= 97 && c10 <= 122 || c10 >= 65 && c10 <= 90 || c10 >= 48 && c10 <= 57 || c10 == 32) {
                if (c10 == 32) {
                    c10 = 43;
                }
                URLEncoder.toHex(out, buf.toByteArray());
                buf.reset();
                out.append((char)c10);
                continue;
            }
            try {
                char d10;
                writer.write(c10);
                if (c10 >= 55296 && c10 <= 56319 && i10 < length - 1 && (d10 = s10.charAt(i10 + 1)) >= '\udc00' && d10 <= '\udfff') {
                    writer.write(d10);
                    ++i10;
                }
                writer.flush();
                continue;
            }
            catch (IOException ex2) {
                throw new IllegalArgumentException(s10);
            }
        }
        try {
            writer.close();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        URLEncoder.toHex(out, buf.toByteArray());
        return out.toString();
    }

    private static void toHex(StringBuffer buffer, byte[] b10) {
        for (int i10 = 0; i10 < b10.length; ++i10) {
            buffer.append('%');
            char ch2 = Character.forDigit(b10[i10] >> 4 & 0xF, 16);
            if (Character.isLetter(ch2)) {
                ch2 = (char)(ch2 - 32);
            }
            buffer.append(ch2);
            ch2 = Character.forDigit(b10[i10] & 0xF, 16);
            if (Character.isLetter(ch2)) {
                ch2 = (char)(ch2 - 32);
            }
            buffer.append(ch2);
        }
    }

    private static boolean needsEncoding(String s10) {
        if (s10 == null) {
            return false;
        }
        int length = s10.length();
        for (int i10 = 0; i10 < length; ++i10) {
            char c10 = s10.charAt(i10);
            if (c10 >= 'a' && c10 <= 'z' || c10 >= 'A' && c10 <= 'Z' || c10 >= '0' && c10 <= '9') continue;
            return true;
        }
        return false;
    }
}

