/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.util;

import java.io.UnsupportedEncodingException;

public final class URLDecoder {
    public static String decode(String s10) {
        try {
            return URLDecoder.decode(s10, "UTF8");
        }
        catch (UnsupportedEncodingException ex2) {
            throw new IllegalArgumentException("UTF8");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String decode(String s10, String enc) throws UnsupportedEncodingException {
        if (!URLDecoder.needsDecoding(s10)) {
            return s10;
        }
        int length = s10.length();
        byte[] bytes = new byte[length];
        s10.getBytes(0, length, bytes, 0);
        int k10 = 0;
        length = bytes.length;
        for (int i10 = 0; i10 < length; ++i10) {
            if (bytes[i10] == 37) {
                while (bytes[i10 + 1] == 37) {
                    ++i10;
                }
                if (i10 >= length - 2) throw new IllegalArgumentException(s10);
                bytes[k10] = URLDecoder.x2c(bytes, i10);
                i10 += 2;
            } else {
                bytes[k10] = bytes[i10] == 43 ? 32 : bytes[i10];
            }
            ++k10;
        }
        return new String(bytes, 0, k10, enc);
    }

    private static boolean needsDecoding(String s10) {
        if (s10 == null) {
            return false;
        }
        int length = s10.length();
        for (int i10 = 0; i10 < length; ++i10) {
            char c10 = s10.charAt(i10);
            if (c10 != '+' && c10 != '%') continue;
            return true;
        }
        return false;
    }

    private static byte x2c(byte[] b10, int i10) {
        byte b12 = b10[i10 + 1];
        byte b22 = b10[i10 + 2];
        if (b12 < 48 || b12 > 70 && b12 < 97 || b12 > 102 || b22 < 48 || b22 > 70 && b22 < 97 || b22 > 102) {
            throw new IllegalArgumentException("%" + (char)b12 + (char)b22);
        }
        int result = b12 >= 65 ? (b12 & 0xDF) - 65 + 10 : b12 - 48;
        result *= 16;
        return (byte)(result += b22 >= 65 ? (b22 & 0xDF) - 65 + 10 : b22 - 48);
    }
}

