/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.endpoints;

import flex.messaging.FlexContext;
import flex.messaging.FlexSession;
import flex.messaging.MessageException;
import flex.messaging.client.EndpointPushNotifier;
import flex.messaging.client.FlexClient;
import flex.messaging.client.FlushResult;
import flex.messaging.client.UserAgentSettings;
import flex.messaging.config.ConfigMap;
import flex.messaging.endpoints.BaseHTTPEndpoint;
import flex.messaging.log.Log;
import flex.messaging.messages.AcknowledgeMessage;
import flex.messaging.messages.CommandMessage;
import flex.messaging.messages.Message;
import flex.messaging.messages.MessagePerformanceInfo;
import flex.messaging.messages.MessagePerformanceUtils;
import flex.messaging.util.TimeoutManager;
import flex.messaging.util.UserAgentManager;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class BaseStreamingHTTPEndpoint
extends BaseHTTPEndpoint {
    private static final byte[] CRLF_BYTES = new byte[]{13, 10};
    private static final byte ZERO_BYTE = 48;
    private static final byte NULL_BYTE = 0;
    private static final String COMMAND_PARAM_NAME = "command";
    private static final String OPEN_COMMAND = "open";
    private static final String CLOSE_COMMAND = "close";
    private static final String STREAM_ID_PARAM_NAME = "streamId";
    private static final String VERSION_PARAM_NAME = "version";
    private static final String HTTP_1_0 = "HTTP/1.0";
    private static final String STREAMING_THREAD_NAME_EXTENSION = "-in-streaming-mode";
    private static final String IDLE_TIMEOUT_MINUTES = "idle-timeout-minutes";
    private static final String MAX_STREAMING_CLIENTS = "max-streaming-clients";
    private static final String SERVER_TO_CLIENT_HEARTBEAT_MILLIS = "server-to-client-heartbeat-millis";
    private static final int DEFAULT_SERVER_TO_CLIENT_HEARTBEAT_MILLIS = 5000;
    private static final int DEFAULT_IDLE_TIMEOUT_MINUTES = 0;
    private static final int DEFAULT_MAX_STREAMING_CLIENTS = 10;
    public static final String POLL_NOT_SUPPORTED_CODE = "Server.PollNotSupported";
    public static final int POLL_NOT_SUPPORTED_MESSAGE = 10034;
    protected final Object lock = new Object();
    protected UserAgentManager userAgentManager = new UserAgentManager();
    private volatile boolean canStream = true;
    private volatile TimeoutManager pushNotifierTimeoutManager;
    private ConcurrentHashMap currentStreamingRequests;
    private long serverToClientHeartbeatMillis = 5000L;
    private int idleTimeoutMinutes = 0;
    private int maxStreamingClients = 10;
    protected int streamingClientsCount;

    public BaseStreamingHTTPEndpoint() {
        this(false);
    }

    public BaseStreamingHTTPEndpoint(boolean enableManagement) {
        super(enableManagement);
        this.setIdleTimeoutMinutes(this.idleTimeoutMinutes);
    }

    public void initialize(String id2, ConfigMap properties) {
        super.initialize(id2, properties);
        if (properties == null || properties.size() == 0) {
            return;
        }
        this.serverToClientHeartbeatMillis = properties.getPropertyAsLong(SERVER_TO_CLIENT_HEARTBEAT_MILLIS, 5000L);
        this.setServerToClientHeartbeatMillis(this.serverToClientHeartbeatMillis);
        int idleTimeoutMinutes = properties.getPropertyAsInt(IDLE_TIMEOUT_MINUTES, 0);
        this.setIdleTimeoutMinutes(idleTimeoutMinutes);
        UserAgentManager.setupUserAgentManager(properties, this.userAgentManager);
        this.maxStreamingClients = properties.getPropertyAsInt(MAX_STREAMING_CLIENTS, 10);
        this.canStream = this.maxStreamingClients > 0;
    }

    public void start() {
        if (this.isStarted()) {
            return;
        }
        super.start();
        if (this.idleTimeoutMinutes > 0) {
            this.pushNotifierTimeoutManager = new TimeoutManager();
        }
        this.currentStreamingRequests = new ConcurrentHashMap();
    }

    public void stop() {
        if (!this.isStarted()) {
            return;
        }
        if (this.pushNotifierTimeoutManager != null) {
            this.pushNotifierTimeoutManager.shutdown();
            this.pushNotifierTimeoutManager = null;
        }
        for (EndpointPushNotifier notifier : this.currentStreamingRequests.values()) {
            notifier.close();
        }
        this.currentStreamingRequests = null;
        super.stop();
    }

    public long getServerToClientHeartbeatMillis() {
        return this.serverToClientHeartbeatMillis;
    }

    public void setServerToClientHeartbeatMillis(long serverToClientHeartbeatMillis) {
        if (serverToClientHeartbeatMillis < 0L) {
            serverToClientHeartbeatMillis = 0L;
        }
        this.serverToClientHeartbeatMillis = serverToClientHeartbeatMillis;
    }

    public int getIdleTimeoutMinutes() {
        return this.idleTimeoutMinutes;
    }

    public void setIdleTimeoutMinutes(int idleTimeoutMinutes) {
        this.idleTimeoutMinutes = idleTimeoutMinutes;
    }

    public int getMaxStreamingClients() {
        return this.maxStreamingClients;
    }

    public void setMaxStreamingClients(int maxStreamingClients) {
        this.maxStreamingClients = maxStreamingClients;
        this.canStream = this.streamingClientsCount < maxStreamingClients;
    }

    public int getStreamingClientsCount() {
        return this.streamingClientsCount;
    }

    public ConfigMap describeEndpoint() {
        return super.describeEndpoint();
    }

    public void service(HttpServletRequest req, HttpServletResponse res) {
        String command = req.getParameter(COMMAND_PARAM_NAME);
        if (command != null) {
            this.serviceStreamingRequest(req, res);
        } else {
            super.service(req, res);
        }
    }

    protected void addPerformanceInfo(Message message) {
        MessagePerformanceInfo mpip;
        MessagePerformanceInfo mpiOriginal;
        block8: {
            mpiOriginal = MessagePerformanceUtils.getMPII(message);
            if (mpiOriginal == null) {
                return;
            }
            mpip = (MessagePerformanceInfo)mpiOriginal.clone();
            try {
                MessagePerformanceUtils.setMPIP(message, mpip);
                MessagePerformanceUtils.setMPII(message, null);
            }
            catch (Exception e10) {
                if (!Log.isDebug()) break block8;
                this.log.debug("MPI exception while streaming the message: " + e10.toString());
            }
        }
        MessagePerformanceInfo mpio = new MessagePerformanceInfo();
        if (mpip.recordMessageTimes) {
            mpio.sendTime = System.currentTimeMillis();
            mpio.infoType = "OUT";
        }
        mpio.pushedFlag = true;
        MessagePerformanceUtils.setMPIO(message, mpio);
        if (mpip.recordMessageSizes) {
            try {
                long serializationOverhead = System.currentTimeMillis();
                mpio.messageSize = this.getMessageSizeForPerformanceInfo(message);
                if (mpip.recordMessageTimes) {
                    serializationOverhead = System.currentTimeMillis() - serializationOverhead;
                    mpip.addToOverhead(serializationOverhead);
                    mpiOriginal.addToOverhead(serializationOverhead);
                    mpio.sendTime = System.currentTimeMillis();
                }
            }
            catch (Exception e11) {
                this.log.debug("MPI exception while streaming the message: " + e11.toString());
            }
        }
    }

    protected long getMessageSizeForPerformanceInfo(Message message) {
        return 0L;
    }

    protected FlushResult handleFlexClientPoll(FlexClient flexClient, CommandMessage pollCommand) {
        MessageException me2 = new MessageException();
        me2.setMessage(10034);
        me2.setDetails(10034);
        me2.setCode(POLL_NOT_SUPPORTED_CODE);
        throw me2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void handleFlexClientStreamingOpenRequest(HttpServletRequest req, HttpServletResponse res, FlexClient flexClient) {
        FlexSession session = FlexContext.getFlexSession();
        if (this.canStream && session.canStream) {
            boolean thisThreadCanStream;
            Object object2 = this.lock;
            // MONITORENTER : object2
            ++this.streamingClientsCount;
            if (this.streamingClientsCount == this.maxStreamingClients) {
                thisThreadCanStream = true;
                this.canStream = false;
            } else if (this.streamingClientsCount > this.maxStreamingClients) {
                thisThreadCanStream = false;
                --this.streamingClientsCount;
            } else {
                thisThreadCanStream = true;
            }
            // MONITOREXIT : object2
            if (!thisThreadCanStream) {
                if (Log.isError()) {
                    this.log.error("Endpoint with id '" + this.getId() + "' cannot grant streaming connection to FlexClient with id '" + flexClient.getId() + "' because " + MAX_STREAMING_CLIENTS + " limit of '" + this.maxStreamingClients + "' has been reached.");
                }
                try {
                    res.sendError(400);
                    return;
                }
                catch (IOException ignore) {
                    // empty catch block
                }
                return;
            }
            byte[] kickStartBytesToStream = null;
            String userAgentValue = req.getHeader("User-Agent");
            UserAgentSettings agentSettings = this.userAgentManager.match(userAgentValue);
            if (agentSettings != null) {
                FlexSession flexSession = session;
                // MONITORENTER : flexSession
                session.maxConnectionsPerSession = agentSettings.getMaxStreamingConnectionsPerSession();
                // MONITOREXIT : flexSession
                int kickStartBytes = agentSettings.getKickstartBytes();
                if (kickStartBytes > 0) {
                    try {
                        int chunkLengthHeaderSize = Integer.toHexString(kickStartBytes).getBytes("ASCII").length;
                        int chunkOverhead = chunkLengthHeaderSize + 4;
                        int minimumKickstartBytes = kickStartBytes - chunkOverhead;
                        kickStartBytesToStream = new byte[minimumKickstartBytes > 0 ? minimumKickstartBytes : kickStartBytes];
                    }
                    catch (UnsupportedEncodingException ignore) {
                        kickStartBytesToStream = new byte[kickStartBytes];
                    }
                    Arrays.fill(kickStartBytesToStream, (byte)0);
                }
            }
            FlexSession kickStartBytes = session;
            // MONITORENTER : kickStartBytes
            ++session.streamingConnectionsCount;
            if (session.streamingConnectionsCount == session.maxConnectionsPerSession) {
                thisThreadCanStream = true;
                session.canStream = false;
            } else if (session.streamingConnectionsCount > session.maxConnectionsPerSession) {
                thisThreadCanStream = false;
                --session.streamingConnectionsCount;
                Object ignore = this.lock;
                // MONITORENTER : ignore
                --this.streamingClientsCount;
                // MONITOREXIT : ignore
            } else {
                thisThreadCanStream = true;
            }
            // MONITOREXIT : kickStartBytes
            if (!thisThreadCanStream) {
                if (Log.isInfo()) {
                    this.log.info("Endpoint with id '" + this.getId() + "' cannot grant streaming connection to FlexClient with id '" + flexClient.getId() + "' because " + "max-streaming-connections-per-session" + " limit of '" + session.maxConnectionsPerSession + (agentSettings != null ? "' for user-agent '" + agentSettings.getMatchOn() + "'" : "") + " has been reached.");
                }
                try {
                    res.sendError(400);
                    return;
                }
                catch (IOException ignore) {
                    // empty catch block
                }
                return;
            }
            Thread currentThread = Thread.currentThread();
            String threadName = currentThread.getName();
            EndpointPushNotifier notifier = null;
            boolean suppressIOExceptionLogging = false;
            try {
                try {
                    ServletOutputStream os2;
                    block84: {
                        currentThread.setName(threadName + STREAMING_THREAD_NAME_EXTENSION);
                        if (this.addNoCacheHeaders) {
                            BaseStreamingHTTPEndpoint.addNoCacheHeaders(req, res);
                        }
                        res.setContentType(this.getResponseContentType());
                        res.setHeader("Connection", CLOSE_COMMAND);
                        res.setHeader("Transfer-Encoding", "chunked");
                        os2 = res.getOutputStream();
                        res.flushBuffer();
                        if (kickStartBytesToStream != null) {
                            if (Log.isDebug()) {
                                this.log.debug("Endpoint with id '" + this.getId() + "' is streaming " + kickStartBytesToStream.length + " bytes (not counting chunk encoding overhead) to kick-start the streaming connection for FlexClient with id '" + flexClient.getId() + "'.");
                            }
                            this.streamChunk(kickStartBytesToStream, os2, res);
                        }
                        this.setThreadLocals();
                        try {
                            notifier = new EndpointPushNotifier(this, flexClient);
                        }
                        catch (MessageException me2) {
                            if (me2.getNumber() != 10033) break block84;
                            if (Log.isWarn()) {
                                this.log.warn("Endpoint with id '" + this.getId() + "' received a duplicate streaming connection request from, FlexClient with id '" + flexClient.getId() + "'. Faulting request.");
                            }
                            Object object = this.lock;
                            // MONITORENTER : object
                            --this.streamingClientsCount;
                            this.canStream = this.streamingClientsCount < this.maxStreamingClients;
                            FlexSession flexSession = session;
                            // MONITORENTER : flexSession
                            --session.streamingConnectionsCount;
                            session.canStream = session.streamingConnectionsCount < session.maxConnectionsPerSession;
                            // MONITOREXIT : flexSession
                            // MONITOREXIT : object
                            try {
                                res.sendError(400);
                            }
                            catch (IOException ignore) {
                            }
                            Object var21_32 = null;
                            currentThread.setName(threadName);
                            Object object3 = this.lock;
                            // MONITORENTER : object3
                            --this.streamingClientsCount;
                            this.canStream = this.streamingClientsCount < this.maxStreamingClients;
                            FlexSession flexSession2 = session;
                            // MONITORENTER : flexSession2
                            --session.streamingConnectionsCount;
                            session.canStream = session.streamingConnectionsCount < session.maxConnectionsPerSession;
                            // MONITOREXIT : flexSession2
                            // MONITOREXIT : object3
                            if (notifier != null && this.currentStreamingRequests != null) {
                                this.currentStreamingRequests.remove(notifier.getNotifierId());
                                notifier.close();
                            }
                            if (Log.isDebug()) {
                                Log.getLogger("Endpoint.FlexSession").info("Number of streaming clients for FlexSession with id '" + session.getId() + "' is " + session.streamingConnectionsCount + ".");
                            }
                            if (!Log.isDebug()) return;
                            this.log.debug("Number of streaming clients for endpoint with id '" + this.getId() + "' is " + this.streamingClientsCount + ".");
                            return;
                        }
                    }
                    notifier.setIdleTimeoutMinutes(this.idleTimeoutMinutes);
                    notifier.setLogCategory(this.getLogCategory());
                    this.monitorTimeout(notifier);
                    this.currentStreamingRequests.put(notifier.getNotifierId(), notifier);
                    AcknowledgeMessage connectAck = new AcknowledgeMessage();
                    connectAck.setBody(notifier.getNotifierId());
                    connectAck.setCorrelationId(OPEN_COMMAND);
                    ArrayList<AcknowledgeMessage> toPush = new ArrayList<AcknowledgeMessage>(1);
                    toPush.add(connectAck);
                    this.streamMessages(toPush, os2, res);
                    if (Log.isDebug()) {
                        Log.getLogger("Endpoint.FlexSession").info("Number of streaming clients for FlexSession with id '" + session.getId() + "' is " + session.streamingConnectionsCount + ".");
                    }
                    if (Log.isDebug()) {
                        this.log.debug("Number of streaming clients for endpoint with id '" + this.getId() + "' is " + this.streamingClientsCount + ".");
                    }
                    while (!notifier.isClosed()) {
                        block85: {
                            Object object = notifier.pushNeeded;
                            // MONITORENTER : object
                            try {
                                this.streamMessages(notifier.drainMessages(), os2, res);
                                notifier.pushNeeded.wait(this.serverToClientHeartbeatMillis);
                                List messages = notifier.drainMessages();
                                if (messages == null && this.serverToClientHeartbeatMillis > 0L) {
                                    try {
                                        os2.write(0);
                                        res.flushBuffer();
                                        break block85;
                                    }
                                    catch (IOException e10) {
                                        if (Log.isWarn()) {
                                            this.log.warn("Endpoint with id '" + this.getId() + "' is closing the streaming connection to FlexClient with id '" + flexClient.getId() + "' because endpoint encountered a socket write error" + ", possibly due to an unresponsive FlexClient.");
                                        }
                                        // MONITOREXIT : object
                                        break;
                                    }
                                }
                                notifier.updateLastUse();
                                this.streamMessages(messages, os2, res);
                            }
                            catch (InterruptedException e11) {
                                if (Log.isWarn()) {
                                    this.log.warn("Streaming thread '" + threadName + "' for endpoint with id '" + this.getId() + "' has been interrupted and the streaming connection will be closed.");
                                }
                                os2.close();
                                // MONITOREXIT : object
                                break;
                            }
                        }
                        // MONITOREXIT : object
                        flexClient.updateLastUse();
                    }
                    if (Log.isDebug()) {
                        this.log.debug("Streaming thread '" + threadName + "' for endpoint with id '" + this.getId() + "' is releasing connection and returning to the request handler pool.");
                    }
                    suppressIOExceptionLogging = true;
                    this.streamChunk(null, os2, res);
                }
                catch (IOException e12) {
                    if (Log.isWarn() && !suppressIOExceptionLogging) {
                        this.log.warn("Streaming thread '" + threadName + "' for endpoint with id '" + this.getId() + "' is closing connection due to an IO error.", e12);
                    }
                    Object var21_34 = null;
                    currentThread.setName(threadName);
                    Object object = this.lock;
                    // MONITORENTER : object
                    --this.streamingClientsCount;
                    this.canStream = this.streamingClientsCount < this.maxStreamingClients;
                    FlexSession flexSession = session;
                    // MONITORENTER : flexSession
                    --session.streamingConnectionsCount;
                    session.canStream = session.streamingConnectionsCount < session.maxConnectionsPerSession;
                    // MONITOREXIT : flexSession
                    // MONITOREXIT : object
                    if (notifier != null && this.currentStreamingRequests != null) {
                        this.currentStreamingRequests.remove(notifier.getNotifierId());
                        notifier.close();
                    }
                    if (Log.isDebug()) {
                        Log.getLogger("Endpoint.FlexSession").info("Number of streaming clients for FlexSession with id '" + session.getId() + "' is " + session.streamingConnectionsCount + ".");
                    }
                    if (!Log.isDebug()) return;
                    this.log.debug("Number of streaming clients for endpoint with id '" + this.getId() + "' is " + this.streamingClientsCount + ".");
                    return;
                }
                Object var21_33 = null;
                currentThread.setName(threadName);
                Object object = this.lock;
                // MONITORENTER : object
                --this.streamingClientsCount;
                this.canStream = this.streamingClientsCount < this.maxStreamingClients;
                FlexSession flexSession = session;
                // MONITORENTER : flexSession
                --session.streamingConnectionsCount;
                session.canStream = session.streamingConnectionsCount < session.maxConnectionsPerSession;
                // MONITOREXIT : flexSession
                // MONITOREXIT : object
                if (notifier != null && this.currentStreamingRequests != null) {
                    this.currentStreamingRequests.remove(notifier.getNotifierId());
                    notifier.close();
                }
                if (Log.isDebug()) {
                    Log.getLogger("Endpoint.FlexSession").info("Number of streaming clients for FlexSession with id '" + session.getId() + "' is " + session.streamingConnectionsCount + ".");
                }
                if (!Log.isDebug()) return;
                this.log.debug("Number of streaming clients for endpoint with id '" + this.getId() + "' is " + this.streamingClientsCount + ".");
                return;
            }
            catch (Throwable throwable) {
                Object var21_35 = null;
                currentThread.setName(threadName);
                Object object = this.lock;
                // MONITORENTER : object
                --this.streamingClientsCount;
                this.canStream = this.streamingClientsCount < this.maxStreamingClients;
                FlexSession flexSession = session;
                // MONITORENTER : flexSession
                --session.streamingConnectionsCount;
                session.canStream = session.streamingConnectionsCount < session.maxConnectionsPerSession;
                // MONITOREXIT : flexSession
                // MONITOREXIT : object
                if (notifier != null && this.currentStreamingRequests != null) {
                    this.currentStreamingRequests.remove(notifier.getNotifierId());
                    notifier.close();
                }
                if (Log.isDebug()) {
                    Log.getLogger("Endpoint.FlexSession").info("Number of streaming clients for FlexSession with id '" + session.getId() + "' is " + session.streamingConnectionsCount + ".");
                }
                if (!Log.isDebug()) throw throwable;
                this.log.debug("Number of streaming clients for endpoint with id '" + this.getId() + "' is " + this.streamingClientsCount + ".");
                throw throwable;
            }
        }
        if (Log.isError()) {
            String logString = null;
            if (!this.canStream) {
                logString = "Endpoint with id '" + this.getId() + "' cannot grant streaming connection to FlexClient with id '" + flexClient.getId() + "' because " + MAX_STREAMING_CLIENTS + " limit of '" + this.maxStreamingClients + "' has been reached.";
            } else if (!session.canStream) {
                logString = "Endpoint with id '" + this.getId() + "' cannot grant streaming connection to FlexClient with id '" + flexClient.getId() + "' because " + "max-streaming-connections-per-session" + " limit of '" + session.maxConnectionsPerSession + "' has been reached.";
            }
            if (logString != null) {
                this.log.error(logString);
            }
        }
        try {
            res.sendError(400);
            return;
        }
        catch (IOException ignore) {
            // empty catch block
        }
    }

    protected void handleFlexClientStreamingCloseRequest(HttpServletRequest req, HttpServletResponse res, FlexClient flexClient, String streamId) {
        EndpointPushNotifier notifier;
        if (streamId != null && (notifier = (EndpointPushNotifier)flexClient.getEndpointPushHandler(this.getId())) != null && notifier.getNotifierId().equals(streamId)) {
            notifier.close();
        }
    }

    protected void serviceStreamingRequest(HttpServletRequest req, HttpServletResponse res) {
        String command = req.getParameter(COMMAND_PARAM_NAME);
        if (req.getProtocol().equals(HTTP_1_0)) {
            if (Log.isError()) {
                this.log.error("Endpoint with id '" + this.getId() + "' cannot service the streaming request made with " + " HTTP 1.0. Only HTTP 1.1 is supported.");
            }
            try {
                res.sendError(400);
            }
            catch (IOException ignore) {
                // empty catch block
            }
            return;
        }
        if (!command.equals(OPEN_COMMAND) && !command.equals(CLOSE_COMMAND)) {
            if (Log.isError()) {
                this.log.error("Endpoint with id '" + this.getId() + "' cannot service the streaming request as the supplied command '" + command + "' is invalid.");
            }
            try {
                res.sendError(400);
            }
            catch (IOException ignore) {
                // empty catch block
            }
            return;
        }
        String flexClientId = req.getParameter("DSId");
        if (flexClientId == null) {
            if (Log.isError()) {
                this.log.error("Endpoint with id '" + this.getId() + "' cannot service the streaming request as no FlexClient id" + " has been supplied in the request.");
            }
            try {
                res.sendError(400);
            }
            catch (IOException ignore) {
                // empty catch block
            }
            return;
        }
        FlexClient flexClient2 = null;
        List<FlexClient> flexClients = FlexContext.getFlexSession().getFlexClients();
        boolean validFlexClientId = false;
        for (FlexClient flexClient2 : flexClients) {
            if (!flexClient2.getId().equals(flexClientId) || !flexClient2.isValid()) continue;
            validFlexClientId = true;
            break;
        }
        if (!command.equals(CLOSE_COMMAND) && !validFlexClientId) {
            if (Log.isError()) {
                this.log.error("Endpoint with id '" + this.getId() + "' cannot service the streaming request as either the supplied" + " FlexClient id '" + flexClientId + " is not valid, or the FlexClient with that id is not valid.");
            }
            try {
                res.sendError(400);
            }
            catch (IOException ignore) {
                // empty catch block
            }
            return;
        }
        if (flexClient2 != null) {
            if (command.equals(OPEN_COMMAND)) {
                this.handleFlexClientStreamingOpenRequest(req, res, flexClient2);
            } else if (command.equals(CLOSE_COMMAND)) {
                this.handleFlexClientStreamingCloseRequest(req, res, flexClient2, req.getParameter(STREAM_ID_PARAM_NAME));
            }
        }
    }

    protected void streamChunk(byte[] bytes, ServletOutputStream os2, HttpServletResponse response) throws IOException {
        if (bytes != null && bytes.length > 0) {
            byte[] chunkLength = Integer.toHexString(bytes.length).getBytes("ASCII");
            os2.write(chunkLength);
            os2.write(CRLF_BYTES);
            os2.write(bytes);
            os2.write(CRLF_BYTES);
            response.flushBuffer();
        } else {
            os2.write(48);
            os2.write(CRLF_BYTES);
            response.flushBuffer();
        }
    }

    protected abstract void streamMessages(List var1, ServletOutputStream var2, HttpServletResponse var3) throws IOException;

    private void monitorTimeout(EndpointPushNotifier notifier) {
        if (this.pushNotifierTimeoutManager != null) {
            this.pushNotifierTimeoutManager.scheduleTimeout(notifier);
        }
    }
}

