/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.config;

import flex.messaging.config.AbstractConfigurationParser;
import flex.messaging.config.ChannelSettings;
import flex.messaging.config.ClientConfiguration;
import flex.messaging.config.ClusterSettings;
import flex.messaging.config.ConfigMap;
import flex.messaging.config.ConfigurationException;
import flex.messaging.config.DestinationSettings;
import flex.messaging.config.LocalFileResolver;
import flex.messaging.config.ServiceSettings;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class ClientConfigurationParser
extends AbstractConfigurationParser {
    protected void parseTopLevelConfig(Document doc) {
        Node root = this.selectSingleNode(doc, "/services-config");
        if (root != null) {
            this.allowedChildElements(root, SERVICES_CONFIG_CHILDREN);
            this.channelsSection(root);
            this.services(root);
            this.clusters(root);
        }
    }

    private void channelsSection(Node root) {
        Node channelsNode = this.selectSingleNode(root, "channels");
        if (channelsNode != null) {
            this.allowedAttributesOrElements(channelsNode, CHANNELS_CHILDREN);
            NodeList channels = this.selectNodeList(channelsNode, "channel-definition");
            for (int i10 = 0; i10 < channels.getLength(); ++i10) {
                Node channel = channels.item(i10);
                this.channelDefinition(channel);
            }
        }
    }

    private void channelDefinition(Node channel) {
        this.requiredAttributesOrElements(channel, CHANNEL_DEFINITION_REQ_CHILDREN);
        this.allowedAttributesOrElements(channel, CHANNEL_DEFINITION_CHILDREN);
        String id2 = this.getAttributeOrChildElement(channel, "id").trim();
        if (ClientConfigurationParser.isValidID(id2)) {
            String enableSmallMessages;
            ConfigMap serialization;
            ConfigMap map;
            NodeList properties;
            if (this.config.getChannelSettings(id2) != null) {
                ConfigurationException e10 = new ConfigurationException();
                e10.setMessage(11127, new Object[]{id2});
                throw e10;
            }
            ChannelSettings channelSettings = new ChannelSettings(id2);
            String clientType = this.getAttributeOrChildElement(channel, "class");
            channelSettings.setClientType(clientType);
            Node endpoint = this.selectSingleNode(channel, "endpoint");
            if (endpoint != null) {
                this.allowedAttributesOrElements(endpoint, ENDPOINT_CHILDREN);
                String uri = this.getAttributeOrChildElement(endpoint, "url");
                if (uri == null || "".equals(uri)) {
                    uri = this.getAttributeOrChildElement(endpoint, "uri");
                }
                channelSettings.setUri(uri);
                this.config.addChannelSettings(id2, channelSettings);
            }
            if ((properties = this.selectNodeList(channel, "properties/polling-enabled")).getLength() > 0) {
                map = this.properties(properties, this.getSourceFileOf(channel));
                channelSettings.addProperties(map);
            }
            if ((properties = this.selectNodeList(channel, "properties/polling-interval-millis")).getLength() > 0) {
                map = this.properties(properties, this.getSourceFileOf(channel));
                channelSettings.addProperties(map);
            }
            if ((properties = this.selectNodeList(channel, "properties/piggybacking-enabled")).getLength() > 0) {
                map = this.properties(properties, this.getSourceFileOf(channel));
                channelSettings.addProperties(map);
            }
            if ((properties = this.selectNodeList(channel, "properties/login-after-disconnect")).getLength() > 0) {
                map = this.properties(properties, this.getSourceFileOf(channel));
                channelSettings.addProperties(map);
            }
            if ((properties = this.selectNodeList(channel, "properties/serialization")).getLength() > 0 && (serialization = (map = this.properties(properties, this.getSourceFileOf(channel))).getPropertyAsMap("serialization", null)) != null && (enableSmallMessages = serialization.getProperty("enable-small-messages")) != null) {
                ConfigMap clientMap = new ConfigMap();
                clientMap.addProperty("enable-small-messages", enableSmallMessages);
                channelSettings.addProperty("serialization", clientMap);
            }
            if ((properties = this.selectNodeList(channel, "properties/record-message-sizes")).getLength() > 0) {
                map = this.properties(properties, this.getSourceFileOf(channel));
                channelSettings.addProperties(map);
            }
            if ((properties = this.selectNodeList(channel, "properties/record-message-times")).getLength() > 0) {
                map = this.properties(properties, this.getSourceFileOf(channel));
                channelSettings.addProperties(map);
            }
            if ((properties = this.selectNodeList(channel, "properties/polling-interval-seconds")).getLength() > 0) {
                map = this.properties(properties, this.getSourceFileOf(channel));
                channelSettings.addProperties(map);
            }
            if ((properties = this.selectNodeList(channel, "properties/connect-timeout-seconds")).getLength() > 0) {
                map = this.properties(properties, this.getSourceFileOf(channel));
                channelSettings.addProperties(map);
            }
        } else {
            ConfigurationException ex2 = new ConfigurationException();
            ex2.setMessage(10110, new Object[]{"channel-definition", id2});
            String details = "An id must be non-empty and not contain any list delimiter characters, i.e. commas, semi-colons or colons.";
            ex2.setDetails(details);
            throw ex2;
        }
    }

    private void services(Node root) {
        Node servicesNode = this.selectSingleNode(root, "services");
        if (servicesNode != null) {
            Node service;
            int i10;
            this.allowedChildElements(servicesNode, SERVICES_CHILDREN);
            Node defaultChannels = this.selectSingleNode(servicesNode, "default-channels");
            if (defaultChannels != null) {
                this.allowedChildElements(defaultChannels, DEFAULT_CHANNELS_CHILDREN);
                NodeList channels = this.selectNodeList(defaultChannels, "channel");
                for (int c10 = 0; c10 < channels.getLength(); ++c10) {
                    Node chan = channels.item(c10);
                    this.allowedAttributes(chan, new String[]{"ref"});
                    this.defaultChannel(chan);
                }
            }
            NodeList services = this.selectNodeList(servicesNode, "service-include");
            for (i10 = 0; i10 < services.getLength(); ++i10) {
                service = services.item(i10);
                this.serviceInclude(service);
            }
            services = this.selectNodeList(servicesNode, "service");
            for (i10 = 0; i10 < services.getLength(); ++i10) {
                service = services.item(i10);
                this.service(service);
            }
        }
    }

    private void clusters(Node root) {
        Node clusteringNode = this.selectSingleNode(root, "clusters");
        if (clusteringNode != null) {
            this.allowedAttributesOrElements(clusteringNode, CLUSTERING_CHILDREN);
            NodeList clusters = this.selectNodeList(clusteringNode, "cluster");
            for (int i10 = 0; i10 < clusters.getLength(); ++i10) {
                String ulb2;
                Node cluster = clusters.item(i10);
                this.requiredAttributesOrElements(cluster, CLUSTER_DEFINITION_CHILDREN);
                String clusterName = this.getAttributeOrChildElement(cluster, "id");
                if (!ClientConfigurationParser.isValidID(clusterName)) continue;
                String propsFileName = this.getAttributeOrChildElement(cluster, "properties");
                ClusterSettings clusterSettings = new ClusterSettings();
                clusterSettings.setClusterName(clusterName);
                clusterSettings.setPropsFileName(propsFileName);
                String defaultValue = this.getAttributeOrChildElement(cluster, "default");
                if (defaultValue != null && defaultValue.length() > 0) {
                    if (defaultValue.equalsIgnoreCase("true")) {
                        clusterSettings.setDefault(true);
                    } else if (!defaultValue.equalsIgnoreCase("false")) {
                        ConfigurationException e10 = new ConfigurationException();
                        e10.setMessage(10215, new Object[]{clusterName, defaultValue});
                        throw e10;
                    }
                }
                if ((ulb2 = this.getAttributeOrChildElement(cluster, "url-load-balancing")) != null && ulb2.length() > 0) {
                    if (ulb2.equalsIgnoreCase("false")) {
                        clusterSettings.setURLLoadBalancing(false);
                    } else if (!ulb2.equalsIgnoreCase("true")) {
                        ConfigurationException e11 = new ConfigurationException();
                        e11.setMessage(10216, new Object[]{clusterName, ulb2});
                        throw e11;
                    }
                }
                ((ClientConfiguration)this.config).addClusterSettings(clusterSettings);
            }
        }
    }

    private void serviceInclude(Node serviceInclude) {
        this.requiredAttributesOrElements(serviceInclude, SERVICE_INCLUDE_CHILDREN);
        String src = this.getAttributeOrChildElement(serviceInclude, "file-path");
        if (src.length() > 0) {
            Document doc = this.loadDocument(src, this.fileResolver.getIncludedFile(src));
            if (this.fileResolver instanceof LocalFileResolver) {
                LocalFileResolver local = (LocalFileResolver)this.fileResolver;
                ((ClientConfiguration)this.config).addConfigPath(local.getIncludedPath(src), local.getIncludedLastModified(src));
            }
            doc.getDocumentElement().normalize();
            Node service = this.selectSingleNode(doc, "/service");
            if (service != null) {
                this.service(service);
                this.fileResolver.popIncludedFile();
            } else {
                ConfigurationException ex2 = new ConfigurationException();
                ex2.setMessage(10112, new Object[]{"service"});
                throw ex2;
            }
        }
    }

    private void service(Node service) {
        this.requiredAttributesOrElements(service, SERVICE_REQ_CHILDREN);
        this.allowedAttributesOrElements(service, SERVICE_CHILDREN);
        String id2 = this.getAttributeOrChildElement(service, "id");
        if (ClientConfigurationParser.isValidID(id2)) {
            Node dest;
            int i10;
            ServiceSettings serviceSettings = this.config.getServiceSettings(id2);
            if (serviceSettings == null) {
                serviceSettings = new ServiceSettings(id2);
                NodeList properties = this.selectNodeList(service, "properties/*");
                if (properties.getLength() > 0) {
                    ConfigMap map = this.properties(properties, this.getSourceFileOf(service));
                    serviceSettings.addProperties(map);
                }
            } else {
                ConfigurationException e10 = new ConfigurationException();
                e10.setMessage(10113, new Object[]{id2});
                throw e10;
            }
            this.config.addServiceSettings(serviceSettings);
            Node defaultChannels = this.selectSingleNode(service, "default-channels");
            if (defaultChannels != null) {
                this.allowedChildElements(defaultChannels, DEFAULT_CHANNELS_CHILDREN);
                NodeList channels = this.selectNodeList(defaultChannels, "channel");
                for (int c10 = 0; c10 < channels.getLength(); ++c10) {
                    Node chan = channels.item(c10);
                    this.allowedAttributes(chan, new String[]{"ref"});
                    this.defaultChannel(chan, serviceSettings);
                }
            } else if (this.config.getDefaultChannels().size() > 0) {
                Iterator iter = this.config.getDefaultChannels().iterator();
                while (iter.hasNext()) {
                    String channelId = (String)iter.next();
                    ChannelSettings channel = this.config.getChannelSettings(channelId);
                    serviceSettings.addDefaultChannel(channel);
                }
            }
            NodeList list = this.selectNodeList(service, "destination");
            for (i10 = 0; i10 < list.getLength(); ++i10) {
                dest = list.item(i10);
                this.destination(dest, serviceSettings);
            }
            list = this.selectNodeList(service, "destination-include");
            for (i10 = 0; i10 < list.getLength(); ++i10) {
                dest = list.item(i10);
                this.destinationInclude(dest, serviceSettings);
            }
        } else {
            ConfigurationException ex2 = new ConfigurationException();
            ex2.setMessage(10110, new Object[]{"service", id2});
            throw ex2;
        }
    }

    private void defaultChannel(Node chan) {
        ChannelSettings channel;
        String ref = this.getAttributeOrChildElement(chan, "ref");
        if (ref.length() > 0) {
            channel = this.config.getChannelSettings(ref);
            if (channel == null) {
                ConfigurationException e10 = new ConfigurationException();
                e10.setMessage(10109, new Object[]{"channel", ref});
                throw e10;
            }
        } else {
            ConfigurationException ex2 = new ConfigurationException();
            ex2.setMessage(10116, new Object[]{"MessageBroker"});
            throw ex2;
        }
        this.config.addDefaultChannel(channel.getId());
    }

    private void defaultChannel(Node chan, ServiceSettings serviceSettings) {
        ChannelSettings channel;
        String ref = this.getAttributeOrChildElement(chan, "ref").trim();
        if (ref.length() > 0) {
            channel = this.config.getChannelSettings(ref);
            if (channel == null) {
                ConfigurationException e10 = new ConfigurationException();
                e10.setMessage(10109, new Object[]{"channel", ref});
                throw e10;
            }
        } else {
            ConfigurationException ex2 = new ConfigurationException();
            ex2.setMessage(10116, new Object[]{serviceSettings.getId()});
            throw ex2;
        }
        serviceSettings.addDefaultChannel(channel);
    }

    private void destinationInclude(Node destInclude, ServiceSettings serviceSettings) {
        this.requiredAttributesOrElements(destInclude, DESTINATION_INCLUDE_CHILDREN);
        String src = this.getAttributeOrChildElement(destInclude, "file-path");
        if (src.length() > 0) {
            Document doc = this.loadDocument(src, this.fileResolver.getIncludedFile(src));
            if (this.fileResolver instanceof LocalFileResolver) {
                LocalFileResolver local = (LocalFileResolver)this.fileResolver;
                ((ClientConfiguration)this.config).addConfigPath(local.getIncludedPath(src), local.getIncludedLastModified(src));
            }
            doc.getDocumentElement().normalize();
            Node dest = this.selectSingleNode(doc, "/destination");
            if (dest != null) {
                this.destination(dest, serviceSettings);
                this.fileResolver.popIncludedFile();
            } else {
                ConfigurationException ex2 = new ConfigurationException();
                ex2.setMessage(10118, new Object[]{"destination"});
                throw ex2;
            }
        }
    }

    private void destination(Node dest, ServiceSettings serviceSettings) {
        this.requiredAttributesOrElements(dest, DESTINATION_REQ_CHILDREN);
        this.allowedAttributes(dest, DESTINATION_ATTR);
        this.allowedChildElements(dest, DESTINATION_CHILDREN);
        String serviceId = serviceSettings.getId();
        DestinationSettings destinationSettings = null;
        String id2 = this.getAttributeOrChildElement(dest, "id");
        if (ClientConfigurationParser.isValidID(id2)) {
            destinationSettings = (DestinationSettings)serviceSettings.getDestinationSettings().get(id2);
            if (destinationSettings != null) {
                ConfigurationException e10 = new ConfigurationException();
                e10.setMessage(10122, new Object[]{id2, serviceId});
                throw e10;
            }
        } else {
            ConfigurationException ex2 = new ConfigurationException();
            ex2.setMessage(10119, new Object[]{"destination", id2, serviceId});
            throw ex2;
        }
        destinationSettings = new DestinationSettings(id2);
        serviceSettings.addDestinationSettings(destinationSettings);
        NodeList properties = this.selectNodeList(dest, "properties/*");
        if (properties.getLength() > 0) {
            ConfigMap map = this.properties(properties, this.getSourceFileOf(dest));
            destinationSettings.addProperties(map);
        }
        this.destinationChannels(dest, destinationSettings, serviceSettings);
    }

    private void destinationChannels(Node dest, DestinationSettings destinationSettings, ServiceSettings serviceSettings) {
        String destId = destinationSettings.getId();
        String channelsList = this.evaluateExpression(dest, "@channels").toString().trim();
        if (channelsList.length() > 0) {
            StringTokenizer st2 = new StringTokenizer(channelsList, ",;:");
            while (st2.hasMoreTokens()) {
                String ref = st2.nextToken().trim();
                ChannelSettings channel = this.config.getChannelSettings(ref);
                if (channel != null) {
                    destinationSettings.addChannelSettings(channel);
                    continue;
                }
                ConfigurationException ex2 = new ConfigurationException();
                ex2.setMessage(10120, new Object[]{"channel", ref, destId});
                throw ex2;
            }
        } else {
            Node channelsNode = this.selectSingleNode(dest, "channels");
            if (channelsNode != null) {
                this.allowedChildElements(channelsNode, DESTINATION_CHANNELS_CHILDREN);
                NodeList channels = this.selectNodeList(channelsNode, "channel");
                if (channels.getLength() > 0) {
                    for (int c10 = 0; c10 < channels.getLength(); ++c10) {
                        ChannelSettings channel;
                        Node chan = channels.item(c10);
                        this.requiredAttributesOrElements(chan, DESTINATION_CHANNEL_REQ_CHILDREN);
                        String ref = this.getAttributeOrChildElement(chan, "ref").trim();
                        if (ref.length() > 0) {
                            channel = this.config.getChannelSettings(ref);
                            if (channel == null) {
                                ConfigurationException ex3 = new ConfigurationException();
                                ex3.setMessage(10120, new Object[]{"channel", ref, destId});
                                throw ex3;
                            }
                        } else {
                            ConfigurationException ex4 = new ConfigurationException();
                            ex4.setMessage(10121, new Object[]{"channel", ref, destId});
                            throw ex4;
                        }
                        destinationSettings.addChannelSettings(channel);
                    }
                }
            } else {
                List defaultChannels = serviceSettings.getDefaultChannels();
                Iterator it2 = defaultChannels.iterator();
                while (it2.hasNext()) {
                    ChannelSettings channel = (ChannelSettings)it2.next();
                    destinationSettings.addChannelSettings(channel);
                }
            }
        }
        if (destinationSettings.getChannelSettings().size() <= 0) {
            ConfigurationException ex5 = new ConfigurationException();
            ex5.setMessage(10123, new Object[]{destId});
            throw ex5;
        }
    }
}

