/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.cluster;

import flex.messaging.FlexContext;
import flex.messaging.cluster.BroadcastHandler;
import flex.messaging.cluster.Cluster;
import flex.messaging.cluster.ClusterException;
import flex.messaging.cluster.ClusterManager;
import flex.messaging.cluster.ClusterMembershipListener;
import flex.messaging.cluster.ClusterNode;
import flex.messaging.log.Log;
import flex.messaging.services.Service;
import flex.messaging.util.ExceptionUtil;
import flex.messaging.util.StringUtils;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.ChannelException;
import org.jgroups.JChannel;
import org.jgroups.JChannelFactory;
import org.jgroups.MembershipListener;
import org.jgroups.Message;
import org.jgroups.blocks.MessageDispatcher;
import org.jgroups.blocks.RequestHandler;
import org.w3c.dom.Element;

public class JGroupsCluster
extends Cluster
implements RequestHandler {
    private final MessageDispatcher broadcastDispatcher;
    private final List broadcastHandlers = new ArrayList();
    private final JChannel clusterChannel;
    private final ClusterManager clusterManager;
    private final ClusterMembershipListener clusterMembershipListener;
    private final Map clusterNodes;
    private final String clusterId;

    public JGroupsCluster(ClusterManager clusterManager, String clusterId, Element props) {
        this.clusterManager = clusterManager;
        this.clusterMembershipListener = new ClusterMembershipListener(this);
        this.clusterNodes = Collections.synchronizedMap(new HashMap());
        this.clusterId = clusterId;
        if (Log.isDebug()) {
            Log.getLogger("Service.Cluster").debug("Joining cluster with id: " + clusterId);
        }
        this.configureBroadcastHandlers();
        try {
            JChannelFactory channelFactory = new JChannelFactory(props);
            this.clusterChannel = (JChannel)channelFactory.createChannel();
            this.clusterChannel.setOpt(3, (Object)Boolean.FALSE);
            this.broadcastDispatcher = new MessageDispatcher((Channel)this.clusterChannel, null, (MembershipListener)this.clusterMembershipListener, (RequestHandler)this);
            this.clusterChannel.connect(clusterId);
        }
        catch (ChannelException cex) {
            ClusterException cx2 = new ClusterException();
            cx2.setMessage(10200, new Object[]{clusterId, props});
            cx2.setRootCause(cex);
            throw cx2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getAllEndpoints(String serviceType, String destName) {
        ArrayList<Map> channelToEndpointMaps = new ArrayList<Map>();
        Map map = this.clusterNodes;
        synchronized (map) {
            Iterator iter = this.clusterNodes.keySet().iterator();
            while (iter.hasNext()) {
                ClusterNode node;
                Map nodeEndpoints;
                Address addr = (Address)iter.next();
                if (this.clusterMembershipListener.isZombie(addr) || (nodeEndpoints = (node = (ClusterNode)this.clusterNodes.get(addr)).getEndpoints(serviceType, destName)).size() <= 0) continue;
                Iterator iter1 = channelToEndpointMaps.iterator();
                while (iter1.hasNext()) {
                    Map nodeEndpoints2 = (Map)iter1.next();
                    Iterator iter2 = nodeEndpoints2.values().iterator();
                    while (iter2.hasNext()) {
                        String endpointUrl = (String)iter2.next();
                        if (!nodeEndpoints.containsValue(endpointUrl)) continue;
                        Iterator iter3 = nodeEndpoints.values().iterator();
                        while (iter3.hasNext()) {
                            String endpointUrl2 = (String)iter3.next();
                            if (!endpointUrl2.equals(endpointUrl)) continue;
                            iter3.remove();
                        }
                    }
                }
                if (nodeEndpoints.size() <= 0) continue;
                channelToEndpointMaps.add(nodeEndpoints);
            }
        }
        return channelToEndpointMaps;
    }

    public void destroy() {
        try {
            this.clusterChannel.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void configureBroadcastHandlers() {
        this.broadcastHandlers.add(new RemoteEndpointHandler());
        this.broadcastHandlers.add(new ServiceOperationHandler());
    }

    void addClusterNode(Address address) {
        if (Log.isDebug()) {
            Log.getLogger("Service.Cluster").debug("Cluster node from address " + address + " joined the cluster for " + this.clusterId);
        }
    }

    void removeClusterNode(Address address) {
        this.clusterNodes.remove(address);
        this.sendRemoveNodeListener(address);
        if (Log.isDebug()) {
            Log.getLogger("Service.Cluster").debug("Cluster node from address " + address + " abandoned the cluster for " + this.clusterId);
        }
    }

    Address getJGroupsLocalAddress() {
        return this.clusterChannel.getLocalAddress();
    }

    public Object getLocalAddress() {
        return this.getJGroupsLocalAddress();
    }

    public void addLocalEndpointForChannel(String serviceType, String destName, String channelId, String endpointUrl, int endpointPort) {
        if (Log.isDebug()) {
            Log.getLogger("Service.Cluster").debug("Adding clustered destination endpoint. cluster-id=" + this.clusterId + " destination=" + destName + " channelId=" + channelId + " endpoint url=" + endpointUrl + " endpointPort=" + endpointPort);
        }
        Address myAddr = this.getJGroupsLocalAddress();
        ClusterNode myNode = this.getNodeForAddress(myAddr);
        endpointUrl = this.canonicalizeUrl(channelId, endpointUrl, endpointPort, myNode);
        myNode.addEndpoint(serviceType, destName, channelId, endpointUrl);
        this.broadcastClusterOperation("addEndpointForChannel", serviceType, destName, channelId, endpointUrl, null);
    }

    void addEndpointForChannel(Address address, String serviceType, String destName, String channelId, String endpointUrl) {
        ClusterNode node = this.getNodeForAddress(address);
        if (!node.containsEndpoint(serviceType, destName, channelId, endpointUrl)) {
            node.addEndpoint(serviceType, destName, channelId, endpointUrl);
            this.broadcastMyEndpoints(address);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void broadcastMyEndpoints(Address address) {
        Map destKeyToChannelMap;
        Vector<Address> destination = new Vector<Address>();
        destination.add(address);
        ClusterNode myNode = this.getNodeForAddress(this.clusterChannel.getLocalAddress());
        Map map = destKeyToChannelMap = myNode.getDestKeyToChannelMap();
        synchronized (map) {
            Iterator destIt = destKeyToChannelMap.keySet().iterator();
            while (destIt.hasNext()) {
                String destKey = (String)destIt.next();
                int ix2 = destKey.indexOf(":");
                String serviceType = destKey.substring(0, ix2);
                String destName = destKey.substring(ix2 + 1);
                Map channelEndpoints = myNode.getEndpoints(serviceType, destName);
                Iterator iter = channelEndpoints.keySet().iterator();
                while (iter.hasNext()) {
                    String channelId = (String)iter.next();
                    String endpointUrl = (String)channelEndpoints.get(channelId);
                    this.broadcastClusterOperation("addEndpointForChannel", serviceType, destName, channelId, endpointUrl, destination);
                }
            }
        }
    }

    void broadcastClusterOperation(String clusterOperation, String serviceType, String destName, String channelId, String endpointUrl, Vector destinations) {
        ArrayList<String> operationInfo = new ArrayList<String>();
        operationInfo.add(serviceType);
        operationInfo.add(destName);
        operationInfo.add(channelId);
        operationInfo.add(endpointUrl);
        this.broadcastOperation(RemoteEndpointHandler.class.getName(), clusterOperation, operationInfo, destinations);
    }

    public void broadcastServiceOperation(String serviceOperation, Object[] params) {
        ArrayList<Object> operationInfo = new ArrayList<Object>();
        operationInfo.addAll(Arrays.asList(params));
        this.broadcastOperation(ServiceOperationHandler.class.getName(), serviceOperation, operationInfo, null);
    }

    public void sendPointToPointServiceOperation(String serviceOperation, Object[] params, Object targetAddress) {
        ArrayList<Object> operationInfo = new ArrayList<Object>();
        operationInfo.addAll(Arrays.asList(params));
        operationInfo.add(this.getJGroupsLocalAddress());
        Vector<Object> targetDestination = new Vector<Object>();
        if (targetAddress != null) {
            targetDestination.add(targetAddress);
        } else {
            for (int i10 = 0; i10 < this.clusterChannel.getView().getMembers().size(); ++i10) {
                Address a10 = (Address)this.clusterChannel.getView().getMembers().get(i10);
                if (a10.equals(this.getJGroupsLocalAddress())) continue;
                targetDestination.add(a10);
                break;
            }
        }
        this.broadcastOperation(ServiceOperationHandler.class.getName(), serviceOperation, operationInfo, targetDestination);
    }

    public List getMemberAddresses() {
        return this.clusterChannel.getView().getMembers();
    }

    private void broadcastOperation(String handlerClass, String operationName, List operationParams, Vector destinations) {
        try {
            operationParams.add(0, handlerClass);
            operationParams.add(1, operationName);
            Message operationMessage = new Message(null, this.getJGroupsLocalAddress(), (Serializable)((Object)operationParams));
            this.broadcastDispatcher.castMessage(destinations, operationMessage, 6, 0L);
        }
        catch (IllegalArgumentException iae) {
            String message = iae.getMessage();
            String notSerializableType = null;
            if (message != null && message.startsWith("java.io.NotSerializableException")) {
                notSerializableType = message.substring(message.indexOf(": ") + 2);
            }
            if (notSerializableType != null) {
                ClusterException cx2 = new ClusterException();
                cx2.setMessage(10212, new Object[]{this.clusterId, notSerializableType});
                cx2.setRootCause(iae);
                throw cx2;
            }
            ClusterException cx3 = new ClusterException();
            cx3.setMessage(10204, new Object[]{this.clusterId});
            cx3.setRootCause(iae);
            throw cx3;
        }
        catch (Exception e10) {
            ClusterException cx4 = new ClusterException();
            cx4.setMessage(10204, new Object[]{this.clusterId});
            cx4.setRootCause(e10);
            throw cx4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object handle(Message msg) {
        if (msg.getSrc() != this.getJGroupsLocalAddress()) {
            List operationInfo = (List)msg.getObject();
            String handlerClass = (String)operationInfo.get(0);
            String operationName = (String)operationInfo.get(1);
            try {
                FlexContext.setThreadLocalObjects(null, null, this.clusterManager.getMessageBroker(), null, null, null);
                Iterator iter = this.broadcastHandlers.iterator();
                while (iter.hasNext()) {
                    BroadcastHandler handler = (BroadcastHandler)iter.next();
                    if (!handler.getClass().getName().equals(handlerClass) || !handler.isSupportedOperation(operationName)) continue;
                    handler.handleBroadcast(msg.getSrc(), operationInfo.subList(1, operationInfo.size()));
                    break;
                }
            }
            finally {
                FlexContext.clearThreadLocalObjects();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClusterNode getNodeForAddress(Address addr) {
        Map map = this.clusterNodes;
        synchronized (map) {
            ClusterNode node = (ClusterNode)this.clusterNodes.get(addr);
            if (node == null) {
                node = new ClusterNode(addr);
                this.clusterNodes.put(addr, node);
            }
            return node;
        }
    }

    private String canonicalizeUrl(String channelId, String endpointUrl, int endpointPort, ClusterNode myNode) {
        if (endpointUrl.startsWith("/")) {
            ClusterException cx2 = new ClusterException();
            cx2.setMessage(10203, new Object[]{channelId});
            throw cx2;
        }
        if (endpointUrl.indexOf(":///") != -1) {
            endpointUrl = StringUtils.substitute(endpointUrl, ":///", "://" + myNode.getHost() + "/");
        }
        if (endpointPort != 0 && endpointUrl.indexOf("" + endpointPort) == -1) {
            StringBuffer sb2 = new StringBuffer(endpointUrl);
            sb2.insert(endpointUrl.indexOf("/", endpointUrl.indexOf("://") + 3), ":" + endpointPort);
            endpointUrl = sb2.toString();
        }
        return endpointUrl;
    }

    class ServiceOperationHandler
    implements BroadcastHandler {
        String[] supportedOperations = new String[]{"pushMessageFromPeer", "peerSyncAndPush", "requestAdapterState", "receiveAdapterState", "sendSubscriptions", "receiveSubscriptions", "subscribeFromPeer", "pushMessageFromPeerToPeer", "peerSyncAndPushOneToPeer"};

        ServiceOperationHandler() {
        }

        public void handleBroadcast(Object sender, List params) {
            block6: {
                try {
                    String serviceType = (String)params.get(1);
                    Service svc = JGroupsCluster.this.clusterManager.getMessageBroker().getServiceByType(serviceType);
                    if (svc == null) break block6;
                    String methodName = (String)params.get(0);
                    Object[] paramValues = params.subList(3, params.size()).toArray();
                    Method[] svcMethods = svc.getClass().getMethods();
                    for (int i10 = 0; i10 < svcMethods.length; ++i10) {
                        if (!svcMethods[i10].getName().equals(methodName)) continue;
                        svcMethods[i10].invoke((Object)svc, paramValues);
                        break;
                    }
                }
                catch (InvocationTargetException ite) {
                    Throwable th2 = ite.getCause();
                    if (Log.isError()) {
                        Log.getLogger("Service.Cluster").error("Error handling message pushed from cluster: " + th2 + StringUtils.NEWLINE + "Exception=" + ExceptionUtil.toString(th2));
                    }
                    ClusterException cx2 = new ClusterException();
                    cx2.setMessage(10205, new Object[]{JGroupsCluster.this.clusterId});
                    cx2.setRootCause(th2);
                    throw cx2;
                }
                catch (Exception e10) {
                    if (Log.isError()) {
                        Log.getLogger("Service.Cluster").error("Error handling message pushed from cluster: " + e10 + StringUtils.NEWLINE + "Exception=" + ExceptionUtil.toString(e10));
                    }
                    ClusterException cx3 = new ClusterException();
                    cx3.setMessage(10205, new Object[]{JGroupsCluster.this.clusterId});
                    cx3.setRootCause(e10);
                    throw cx3;
                }
            }
        }

        public boolean isSupportedOperation(String name) {
            for (int i10 = 0; i10 < this.supportedOperations.length; ++i10) {
                if (!name.equals(this.supportedOperations[i10])) continue;
                return true;
            }
            return false;
        }
    }

    class RemoteEndpointHandler
    implements BroadcastHandler {
        RemoteEndpointHandler() {
        }

        public void handleBroadcast(Object sender, List params) {
            JGroupsCluster.this.addEndpointForChannel((Address)sender, (String)params.get(1), (String)params.get(2), (String)params.get(3), (String)params.get(4));
        }

        public boolean isSupportedOperation(String name) {
            return name.equals("addEndpointForChannel");
        }
    }
}

