/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.cluster;

import flex.messaging.Destination;
import flex.messaging.MessageBroker;
import flex.messaging.cluster.Cluster;
import flex.messaging.cluster.ClusterException;
import flex.messaging.config.ClusterSettings;
import flex.messaging.endpoints.Endpoint;
import flex.messaging.util.ClassUtil;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ClusterManager {
    private MessageBroker broker;
    private Map clusters;
    private Map clustersForDestination;
    private Map clusterConfig;
    private Map clusterSettings;
    private Map backendSharedForDestination;
    private Cluster defaultCluster;
    private String defaultClusterId;

    public ClusterManager(MessageBroker broker) {
        this.broker = broker;
        this.clusters = new HashMap();
        this.clusterConfig = new HashMap();
        this.clusterSettings = new HashMap();
        this.clustersForDestination = new HashMap();
        this.backendSharedForDestination = new HashMap();
    }

    public MessageBroker getMessageBroker() {
        return this.broker;
    }

    public Cluster getDefaultCluster() {
        return this.defaultCluster;
    }

    public String getDefaultClusterId() {
        return this.defaultClusterId;
    }

    public void invokeServiceOperation(String serviceType, String destinationName, String operationName, Object[] params) {
        Cluster c10 = this.getCluster(serviceType, destinationName);
        ArrayList<Object> newParams = new ArrayList<Object>(Arrays.asList(params));
        newParams.add(0, serviceType);
        newParams.add(1, destinationName);
        c10.broadcastServiceOperation(operationName, newParams.toArray());
    }

    public void invokePeerToPeerOperation(String serviceType, String destinationName, String operationName, Object[] params, Object targetAddress) {
        Cluster c10 = this.getCluster(serviceType, destinationName);
        ArrayList<Object> newParams = new ArrayList<Object>(Arrays.asList(params));
        newParams.add(0, serviceType);
        newParams.add(1, destinationName);
        c10.sendPointToPointServiceOperation(operationName, newParams.toArray(), targetAddress);
    }

    public boolean isDestinationClustered(String serviceType, String destinationName) {
        return this.getCluster(serviceType, destinationName) != null;
    }

    public boolean isBackendShared(String serviceType, String destinationName) {
        String destKey = Cluster.getClusterDestinationKey(serviceType, destinationName);
        Boolean shared = (Boolean)this.backendSharedForDestination.get(destKey);
        if (shared == null) {
            return false;
        }
        return shared;
    }

    public List getClusterMemberAddresses(String serviceType, String destinationName) {
        Cluster c10 = this.getCluster(serviceType, destinationName);
        if (c10 == null) {
            return Collections.EMPTY_LIST;
        }
        return c10.getMemberAddresses();
    }

    public void prepareCluster(ClusterSettings settings) {
        InputStream propsFile;
        if (settings.getPropsFileName() == null) {
            ClusterException cx2 = new ClusterException();
            cx2.setMessage(10201, new Object[]{settings.getClusterName(), settings.getPropsFileName()});
            throw cx2;
        }
        try {
            propsFile = this.broker.resolveInternalPath(settings.getPropsFileName());
        }
        catch (Throwable t10) {
            ClusterException cx3 = new ClusterException();
            cx3.setMessage(10208, new Object[]{settings.getPropsFileName()});
            cx3.setRootCause(t10);
            throw cx3;
        }
        if (propsFile == null) {
            ClusterException cx4 = new ClusterException();
            cx4.setMessage(10208, new Object[]{settings.getPropsFileName()});
            throw cx4;
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(false);
            factory.setValidating(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(propsFile);
            if (settings.isDefault()) {
                this.defaultClusterId = settings.getClusterName();
            }
            this.clusterConfig.put(settings.getClusterName(), doc.getDocumentElement());
            this.clusterSettings.put(settings.getClusterName(), settings);
        }
        catch (Exception ex2) {
            ClusterException cx5 = new ClusterException();
            cx5.setMessage(10213);
            cx5.setRootCause(ex2);
            throw cx5;
        }
    }

    public Object getLocalAddress(String serviceType, String destinationName) {
        Cluster c10 = this.getCluster(serviceType, destinationName);
        if (c10 == null) {
            return null;
        }
        return c10.getLocalAddress();
    }

    public Cluster getClusterById(String clusterId) {
        return (Cluster)this.clusters.get(clusterId);
    }

    public Cluster getCluster(String serviceType, String destinationName) {
        Cluster cluster = null;
        try {
            String destKey = Cluster.getClusterDestinationKey(serviceType, destinationName);
            cluster = (Cluster)this.clustersForDestination.get(destKey);
            if (cluster == null) {
                cluster = this.defaultCluster;
            }
        }
        catch (NoClassDefFoundError nex) {
            ClusterException cx2 = new ClusterException();
            cx2.setMessage(10202, new Object[]{destinationName});
            cx2.setRootCause(nex);
            throw cx2;
        }
        return cluster;
    }

    public void destroyClusters() {
        Iterator iter = this.clusters.keySet().iterator();
        while (iter.hasNext()) {
            Cluster cluster = (Cluster)this.clusters.get(iter.next());
            cluster.destroy();
            iter.remove();
        }
    }

    public void clusterDestinationChannel(String clusterId, String serviceType, String destinationName, String channelId, String endpointUrl, int endpointPort, boolean sharedBackend) {
        Cluster cluster = this.getClusterById(clusterId);
        String destKey = Cluster.getClusterDestinationKey(serviceType, destinationName);
        if (cluster == null) {
            if (!this.clusterConfig.containsKey(clusterId)) {
                ClusterException cx2 = new ClusterException();
                cx2.setMessage(10207, new Object[]{destinationName, clusterId});
                throw cx2;
            }
            cluster = this.createCluster(clusterId, serviceType, destinationName);
        } else {
            this.clustersForDestination.put(destKey, cluster);
        }
        this.backendSharedForDestination.put(destKey, sharedBackend ? Boolean.TRUE : Boolean.FALSE);
        if (cluster.getURLLoadBalancing()) {
            cluster.addLocalEndpointForChannel(serviceType, destinationName, channelId, endpointUrl, endpointPort);
        }
    }

    public void clusterDestination(Destination destination) {
        ClusterSettings cls;
        String clusterId = destination.getNetworkSettings().getClusterId();
        String serviceType = destination.getServiceType();
        String destinationName = destination.getId();
        boolean sharedBackend = destination.getNetworkSettings().isSharedBackend();
        List channelIds = destination.getChannels();
        if (clusterId == null) {
            clusterId = this.getDefaultClusterId();
        }
        if ((cls = (ClusterSettings)this.clusterSettings.get(clusterId)) == null) {
            ClusterException ce2 = new ClusterException();
            ce2.setMessage(10217, new Object[]{destination.getId(), clusterId});
            throw ce2;
        }
        for (String channelId : channelIds) {
            int tokenStart;
            Endpoint endpoint = this.broker.getEndpoint(channelId);
            String endpointUrl = endpoint.getUrl();
            int endpointPort = endpoint.getPort();
            if (cls.getURLLoadBalancing() && (tokenStart = endpointUrl.indexOf("{")) != -1) {
                int tokenEnd = endpointUrl.indexOf("}", tokenStart);
                tokenEnd = tokenEnd == -1 ? endpointUrl.length() : ++tokenEnd;
                ClusterException ce3 = new ClusterException();
                ce3.setMessage(10209, new Object[]{destination.getId(), channelId, endpointUrl.substring(tokenStart, tokenEnd)});
                throw ce3;
            }
            this.clusterDestinationChannel(clusterId, serviceType, destinationName, channelId, endpointUrl, endpointPort, sharedBackend);
        }
    }

    public List getEndpointsForDestination(String serviceType, String destinationName) {
        Cluster c10 = this.getCluster(serviceType, destinationName);
        if (c10 != null) {
            return c10.getAllEndpoints(serviceType, destinationName);
        }
        return null;
    }

    private Cluster createCluster(String clusterId, String serviceType, String destinationName) {
        String destKey = Cluster.getClusterDestinationKey(serviceType, destinationName);
        Element propsFile = (Element)this.clusterConfig.get(clusterId);
        ClusterSettings cls = (ClusterSettings)this.clusterSettings.get(clusterId);
        Cluster cluster = null;
        Class clusterClass = ClassUtil.createClass(cls.getImplementationClass());
        Constructor clusterConstructor = null;
        try {
            clusterConstructor = clusterClass.getConstructor(ClusterManager.class, String.class, Element.class);
        }
        catch (Exception e10) {
            ClusterException cx2 = new ClusterException();
            cx2.setMessage(10210);
            cx2.setRootCause(e10);
            throw cx2;
        }
        try {
            cluster = (Cluster)clusterConstructor.newInstance(this, clusterId, propsFile);
            cluster.setURLLoadBalancing(cls.getURLLoadBalancing());
        }
        catch (Exception e11) {
            ClusterException cx3 = new ClusterException();
            cx3.setMessage(10211);
            cx3.setRootCause(e11);
            throw cx3;
        }
        this.clustersForDestination.put(destKey, cluster);
        this.clusters.put(clusterId, cluster);
        if (this.defaultClusterId != null && this.defaultClusterId.equals(clusterId)) {
            this.defaultCluster = cluster;
        }
        return cluster;
    }
}

