/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging;

import flex.messaging.MessageRoutedEvent;
import flex.messaging.MessageRoutedListener;
import flex.messaging.messages.Message;
import java.util.ArrayList;

public class MessageRoutedNotifier {
    private final Message message;
    private ArrayList listeners;

    public MessageRoutedNotifier(Message message) {
        this.message = message;
    }

    public void addMessageRoutedListener(MessageRoutedListener listener) {
        if (listener != null) {
            if (this.listeners == null) {
                this.listeners = new ArrayList();
            }
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }
    }

    public void removeMessageRoutedListener(MessageRoutedListener listener) {
        if (listener != null && this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    public void notifyMessageRouted() {
        if (this.listeners != null && !this.listeners.isEmpty()) {
            MessageRoutedEvent event = new MessageRoutedEvent(this.message);
            int n10 = this.listeners.size();
            for (int i10 = 0; i10 < n10; ++i10) {
                ((MessageRoutedListener)this.listeners.get(i10)).messageRouted(event);
            }
        }
    }
}

