/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging;

import flex.management.runtime.messaging.MessageDestinationControl;
import flex.management.runtime.messaging.services.messaging.SubscriptionManagerControl;
import flex.management.runtime.messaging.services.messaging.ThrottleManagerControl;
import flex.messaging.Destination;
import flex.messaging.FactoryDestination;
import flex.messaging.config.ConfigMap;
import flex.messaging.config.ConfigurationException;
import flex.messaging.config.NetworkSettings;
import flex.messaging.config.ServerSettings;
import flex.messaging.config.ThrottleSettings;
import flex.messaging.log.Log;
import flex.messaging.services.MessageService;
import flex.messaging.services.Service;
import flex.messaging.services.messaging.RemoteSubscriptionManager;
import flex.messaging.services.messaging.SubscriptionManager;
import flex.messaging.services.messaging.ThrottleManager;

public class MessageDestination
extends FactoryDestination {
    static final long serialVersionUID = -2016911808141319012L;
    public static final String LOG_CATEGORY = "Service.Message";
    private static final int UNSUPPORTED_POLICY = 10124;
    private ServerSettings serverSettings = new ServerSettings();
    private SubscriptionManager subscriptionManager = new SubscriptionManager(this);
    private RemoteSubscriptionManager remoteSubscriptionManager = new RemoteSubscriptionManager(this);
    private ThrottleManager throttleManager = new ThrottleManager();
    private MessageDestinationControl controller;

    public MessageDestination() {
        this(false);
    }

    public MessageDestination(boolean enableManagement) {
        super(enableManagement);
    }

    public void initialize(String id2, ConfigMap properties) {
        super.initialize(id2, properties);
        if (properties == null || properties.size() == 0) {
            return;
        }
        this.network(properties);
        this.server(properties);
    }

    public void stop() {
        this.subscriptionManager.stop();
        this.remoteSubscriptionManager.stop();
        this.throttleManager.stop();
        super.stop();
    }

    public void setNetworkSettings(NetworkSettings networkSettings) {
        super.setNetworkSettings(networkSettings);
        if (networkSettings.getThrottleSettings() != null) {
            ThrottleSettings settings = networkSettings.getThrottleSettings();
            settings.setDestinationName(this.getId());
            this.throttleManager.setThrottleSettings(settings);
        }
        if (networkSettings.getSubscriptionTimeoutMinutes() > 0) {
            long subscriptionTimeoutMillis = networkSettings.getSubscriptionTimeoutMinutes() * 60 * 1000;
            this.subscriptionManager.setSubscriptionTimeoutMillis(subscriptionTimeoutMillis);
        }
    }

    public ServerSettings getServerSettings() {
        return this.serverSettings;
    }

    public void setServerSettings(ServerSettings serverSettings) {
        this.serverSettings = serverSettings;
    }

    public void setService(Service service) {
        MessageService messageService = (MessageService)service;
        super.setService(messageService);
    }

    public SubscriptionManager getSubscriptionManager() {
        return this.subscriptionManager;
    }

    public RemoteSubscriptionManager getRemoteSubscriptionManager() {
        return this.remoteSubscriptionManager;
    }

    public ThrottleManager getThrottleManager() {
        return this.throttleManager;
    }

    public boolean equals(Object o10) {
        Destination d10;
        return o10 instanceof Destination && (d10 = (Destination)o10) != null && d10.getServiceType().equals(this.getServiceType()) && d10.getId().equals(this.getId());
    }

    public int hashCode() {
        return (this.getServiceType() == null ? 0 : this.getServiceType().hashCode()) * 100003 + (this.getId() == null ? 0 : this.getId().hashCode());
    }

    public String toString() {
        return this.getServiceType() + "#" + this.getId();
    }

    protected void network(ConfigMap properties) {
        ConfigMap network = properties.getPropertyAsMap("network", null);
        if (network != null) {
            NetworkSettings ns2 = this.getNetworkSettings();
            int useLegacyPropertyToken = -999999;
            int subscriptionTimeoutMinutes = network.getPropertyAsInt("subscription-timeout-minutes", useLegacyPropertyToken);
            if (subscriptionTimeoutMinutes == useLegacyPropertyToken) {
                subscriptionTimeoutMinutes = network.getPropertyAsInt("session-timeout", 0);
            }
            ns2.setSubscriptionTimeoutMinutes(subscriptionTimeoutMinutes);
            this.throttle(ns2.getThrottleSettings(), network);
            this.setNetworkSettings(ns2);
        }
    }

    protected void throttle(ThrottleSettings ts2, ConfigMap network) {
        ConfigMap outbound;
        ConfigMap inbound = network.getPropertyAsMap("throttle-inbound", null);
        if (inbound != null) {
            int policy = this.getPolicyFromThrottleSettings(inbound);
            ts2.setInboundPolicy(policy);
            int destFreq = inbound.getPropertyAsInt("max-frequency", 0);
            ts2.setIncomingDestinationFrequency(destFreq);
            int clientFreq = inbound.getPropertyAsInt("max-client-frequency", 0);
            ts2.setIncomingClientFrequency(clientFreq);
        }
        if ((outbound = network.getPropertyAsMap("throttle-outbound", null)) != null) {
            int policy = this.getPolicyFromThrottleSettings(outbound);
            ts2.setOutboundPolicy(policy);
            int destFreq = outbound.getPropertyAsInt("max-frequency", 0);
            ts2.setOutgoingDestinationFrequency(destFreq);
            int clientFreq = outbound.getPropertyAsInt("max-client-frequency", 0);
            ts2.setOutgoingClientFrequency(clientFreq);
        }
    }

    private int getPolicyFromThrottleSettings(ConfigMap settings) {
        String policyString = settings.getPropertyAsString("policy", null);
        int policy = 0;
        if (policyString == null) {
            return policy;
        }
        try {
            policy = ThrottleSettings.parsePolicy(policyString);
            if (policy == 3 && Log.isWarn()) {
                Log.getLogger(this.getLogCategory()).warn("Throttle outbound policy '{0}' found on message destination '{1}'. The '{0}' throttle outbound policy has been deprecated. Please remove it from your configuration file.", new Object[]{"REPLACE", this.id});
            }
        }
        catch (ConfigurationException exception) {
            ConfigurationException ce2 = new ConfigurationException();
            ce2.setMessage(10124, new Object[]{this.getId(), policyString});
            throw ce2;
        }
        return policy;
    }

    protected void server(ConfigMap properties) {
        ConfigMap server = properties.getPropertyAsMap("server", null);
        if (server != null) {
            int max = server.getPropertyAsInt("max-cache-size", 0);
            this.serverSettings.setMaxCacheSize(max);
            long ttl = server.getPropertyAsLong("message-time-to-live", -1L);
            this.serverSettings.setMessageTTL(ttl);
            boolean durable = server.getPropertyAsBoolean("durable", false);
            this.serverSettings.setDurable(durable);
            boolean allowSubtopics = server.getPropertyAsBoolean("allow-subtopics", false);
            this.serverSettings.setAllowSubtopics(allowSubtopics);
            String subtopicSeparator = server.getPropertyAsString("subtopic-separator", ".");
            this.serverSettings.setSubtopicSeparator(subtopicSeparator);
            String routingMode = server.getPropertyAsString("cluster-message-routing", "server-to-server");
            this.serverSettings.setBroadcastRoutingMode(routingMode);
        }
    }

    protected String getLogCategory() {
        return LOG_CATEGORY;
    }

    protected void setupDestinationControl(Service service) {
        this.controller = new MessageDestinationControl(this, service.getControl());
        this.controller.register();
        this.setControl(this.controller);
        this.setupThrottleManagerControl(this.controller);
        this.setupSubscriptionManagerControl(this.controller);
    }

    private void setupThrottleManagerControl(MessageDestinationControl destinationControl) {
        ThrottleManagerControl throttleManagerControl = new ThrottleManagerControl(this.getThrottleManager(), destinationControl);
        throttleManagerControl.register();
        this.getThrottleManager().setControl(throttleManagerControl);
        this.getThrottleManager().setManaged(true);
        destinationControl.setThrottleManager(throttleManagerControl.getObjectName());
    }

    private void setupSubscriptionManagerControl(MessageDestinationControl destinationControl) {
        SubscriptionManagerControl subscriptionManagerControl = new SubscriptionManagerControl(this.getSubscriptionManager(), destinationControl);
        subscriptionManagerControl.register();
        this.getSubscriptionManager().setControl(subscriptionManagerControl);
        this.getSubscriptionManager().setManaged(true);
        destinationControl.setSubscriptionManager(subscriptionManagerControl.getObjectName());
    }
}

