/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import flex.management.MBeanLifecycleManager;
import flex.management.MBeanServerLocatorFactory;
import flex.messaging.FlexContext;
import flex.messaging.HttpFlexSession;
import flex.messaging.MessageBroker;
import flex.messaging.MessageException;
import flex.messaging.VersionInfo;
import flex.messaging.config.ConfigurationManager;
import flex.messaging.config.FlexConfigurationManager;
import flex.messaging.config.MessagingConfiguration;
import flex.messaging.endpoints.Endpoint;
import flex.messaging.io.SerializationContext;
import flex.messaging.io.TypeMarshallingContext;
import flex.messaging.log.Log;
import flex.messaging.log.Logger;
import flex.messaging.log.ServletLogTarget;
import flex.messaging.services.AuthenticationService;
import flex.messaging.util.ClassUtil;
import flex.messaging.util.ExceptionUtil;
import flex.messaging.util.Trace;
import java.io.IOException;
import java.io.InputStream;
import java.security.Principal;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class MessageBrokerServlet
extends HttpServlet {
    static final long serialVersionUID = -5293855229461612246L;
    public static final String LOG_CATEGORY_STARTUP_BROKER = "Startup.MessageBroker";
    private MessageBroker broker;
    private static String FLEXDIR = "/WEB-INF/flex/";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(ServletConfig servletConfig) throws ServletException, UnavailableException {
        super.init(servletConfig);
        this.createThreadLocals();
        FlexContext.setThreadLocalObjects(null, null, null, null, null, servletConfig);
        ServletLogTarget.setServletContext(servletConfig.getServletContext());
        ClassLoader loader = this.getClassLoader();
        String useCCLoader = servletConfig.getInitParameter("useContextClassLoader");
        if (useCCLoader != null && useCCLoader.equalsIgnoreCase("true")) {
            loader = Thread.currentThread().getContextClassLoader();
        }
        try {
            ConfigurationManager configManager = this.loadMessagingConfiguration(servletConfig);
            MessagingConfiguration config = configManager.getMessagingConfiguration(servletConfig);
            config.createLogAndTargets();
            this.broker = config.createBroker(servletConfig.getInitParameter("messageBrokerId"), loader);
            FlexContext.setThreadLocalObjects(null, null, this.broker, null, null, servletConfig);
            this.setupInternalPathResolver();
            this.broker.setInitServletContext(servletConfig.getServletContext());
            Logger logger = Log.getLogger("Configuration");
            if (Log.isInfo()) {
                logger.info(VersionInfo.buildMessage());
            }
            config.configureBroker(this.broker);
            long timeBeforeStartup = 0L;
            if (Log.isDebug()) {
                timeBeforeStartup = System.currentTimeMillis();
                Log.getLogger(LOG_CATEGORY_STARTUP_BROKER).debug("MessageBroker with id '{0}' is starting.", new Object[]{this.broker.getId()});
            }
            Object object = HttpFlexSession.mapLock;
            synchronized (object) {
                if (servletConfig.getServletContext().getAttribute("LCDS_HTTP_TO_FLEX_SESSION_MAP") == null) {
                    servletConfig.getServletContext().setAttribute("LCDS_HTTP_TO_FLEX_SESSION_MAP", (Object)new ConcurrentHashMap());
                }
            }
            this.broker.start();
            if (Log.isDebug()) {
                long timeAfterStartup = System.currentTimeMillis();
                Long diffMillis = new Long(timeAfterStartup - timeBeforeStartup);
                Log.getLogger(LOG_CATEGORY_STARTUP_BROKER).debug("MessageBroker with id '{0}' is ready (startup time: '{1}' ms)", new Object[]{this.broker.getId(), diffMillis});
            }
            configManager.reportTokens();
            config.reportUnusedProperties();
            FlexContext.clearThreadLocalObjects();
        }
        catch (Throwable t10) {
            System.err.println("**** MessageBrokerServlet failed to initialize due to runtime exception: " + ExceptionUtil.exceptionFollowedByRootCausesToString(t10));
            this.destroy();
            throw new UnavailableException(t10.getMessage());
        }
    }

    private void setupInternalPathResolver() {
        this.broker.setInternalPathResolver(new MessageBroker.InternalPathResolver(){

            public InputStream resolve(String filename) {
                InputStream is2 = MessageBrokerServlet.this.getServletContext().getResourceAsStream(FLEXDIR + filename);
                return is2;
            }
        });
    }

    private ConfigurationManager loadMessagingConfiguration(ServletConfig servletConfig) {
        ConfigurationManager manager;
        block4: {
            String p10;
            manager = null;
            Class managerClass = null;
            String className = null;
            if (servletConfig != null && (p10 = servletConfig.getInitParameter("services.configuration.manager")) != null) {
                className = p10.trim();
                try {
                    managerClass = ClassUtil.createClass(className);
                    manager = (ConfigurationManager)managerClass.newInstance();
                }
                catch (Throwable t10) {
                    if (!Trace.config) break block4;
                    Trace.trace("Could not load configuration manager as: " + className);
                }
            }
        }
        if (manager == null) {
            manager = new FlexConfigurationManager();
        }
        return manager;
    }

    public void destroy() {
        if (this.broker != null) {
            this.broker.stop();
            if (this.broker.isManaged()) {
                MBeanLifecycleManager.unregisterRuntimeMBeans(this.broker);
            }
            this.destroyThreadLocals();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(HttpServletRequest req, HttpServletResponse res) {
        try {
            block19: {
                block18: {
                    String encoded;
                    this.broker.initThreadLocals();
                    FlexContext.setThreadLocalObjects(null, null, this.broker, req, res, this.getServletConfig());
                    HttpFlexSession fs2 = HttpFlexSession.getFlexSession(req);
                    Principal principal = null;
                    principal = FlexContext.isPerClientAuthentication() ? FlexContext.getUserPrincipal() : fs2.getUserPrincipal();
                    if (principal == null && req.getHeader("Authorization") != null && (encoded = req.getHeader("Authorization")).indexOf("Basic") > -1) {
                        encoded = encoded.substring(6);
                        try {
                            AuthenticationService.decodeAndLogin(encoded, this.broker.getLoginManager());
                        }
                        catch (Exception e10) {
                            if (!Log.isDebug()) break block18;
                            Log.getLogger("Security").info("Authentication service could not decode and login: " + e10.getMessage());
                        }
                    }
                }
                String contextPath = req.getContextPath();
                String pathInfo = req.getPathInfo();
                String endpointPath = req.getServletPath();
                if (pathInfo != null) {
                    endpointPath = endpointPath + pathInfo;
                }
                Endpoint endpoint = null;
                try {
                    endpoint = this.broker.getEndpoint(endpointPath, contextPath);
                }
                catch (MessageException me2) {
                    if (Log.isInfo()) {
                        Log.getLogger("Endpoint.General").info("Received invalid request for endpoint path '{0}'.", new Object[]{endpointPath});
                    }
                    if (!res.isCommitted()) {
                        try {
                            res.sendError(404);
                        }
                        catch (IOException ignore) {
                        }
                    }
                    Object var12_14 = null;
                    FlexContext.clearThreadLocalObjects();
                    return;
                }
                try {
                    if (Log.isInfo()) {
                        Log.getLogger("Endpoint.General").info("Channel endpoint {0} received request.", new Object[]{endpoint.getId()});
                    }
                    endpoint.service(req, res);
                }
                catch (UnsupportedOperationException ue2) {
                    if (Log.isInfo()) {
                        Log.getLogger("Endpoint.General").info("Channel endpoint {0} received request for an unsupported operation.", new Object[]{endpoint.getId()}, ue2);
                    }
                    if (res.isCommitted()) break block19;
                    try {
                        res.sendError(405);
                    }
                    catch (IOException ignore) {
                    }
                }
            }
            Object var12_15 = null;
        }
        catch (Throwable throwable) {
            Object var12_16 = null;
            FlexContext.clearThreadLocalObjects();
            throw throwable;
        }
        FlexContext.clearThreadLocalObjects();
    }

    protected ClassLoader getClassLoader() {
        return ((Object)((Object)this)).getClass().getClassLoader();
    }

    public void createThreadLocals() {
        MessageBroker.createThreadLocalObjects();
        FlexContext.createThreadLocalObjects();
        SerializationContext.createThreadLocalObjects();
        TypeMarshallingContext.createThreadLocalObjects();
    }

    protected void destroyThreadLocals() {
        Log.clear();
        MBeanServerLocatorFactory.clear();
        MessageBroker.releaseThreadLocalObjects();
        FlexContext.releaseThreadLocalObjects();
        SerializationContext.releaseThreadLocalObjects();
        TypeMarshallingContext.releaseThreadLocalObjects();
    }
}

