/*
 * Decompiled with CFR 0.152.
 */
package flex.management.jmx;

import flex.management.MBeanServerLocatorFactory;
import flex.management.ManagementException;
import flex.management.jmx.Attribute;
import flex.management.jmx.MBeanInfo;
import flex.management.jmx.ObjectInstance;
import flex.management.jmx.ObjectName;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;

public class MBeanServerGateway {
    private static final int MALFORMED_OBJECTNAME = 10400;
    private static final int GETINFO_INTROSPECTION_ERR = 10406;
    private static final int MBEAN_NOTFOUND = 10407;
    private static final int GETINFO_REFLECT_ERR = 10408;
    private static final int ATTRIB_NOTFOUND = 10409;
    private static final int GETATTRIB_EXCEPTION = 10410;
    private static final int GETATTRIB_REFLECT_ERR = 10411;
    private static final int GETATTRIB_NULL_ARGUMENT = 10412;
    private static final int GETATTRIBS_REFLECT_ERR = 10413;
    private static final int GETATTRIBS_NULL_ARGUMENT = 10414;
    private static final int INVOKE_REFLECT_ERR = 10415;
    private static final int INVOKE_ERR = 10416;
    private static final int CREATE_ERR = 10417;
    private static final int INSTANCE_EXISTS = 10418;
    private static final int NOT_COMPLIANT = 10419;
    private static final int MBEAN_PREREG_ERR = 10420;
    private static final int MBEAN_PREDEREG_ERR = 10421;
    private static final int SETATTRIB_REFLECT_ERR = 10422;
    private static final int SETATTRIB_EXCEPTION = 10423;
    private static final int INVALID_ATTRIB_VALUE = 10424;
    private static final int SETATTRIBS_REFLECT_ERR = 10425;
    private MBeanServer server = MBeanServerLocatorFactory.getMBeanServerLocator().getMBeanServer();

    public ObjectInstance createMBean(String className, String objectName) {
        javax.management.ObjectName name = null;
        if (objectName != null) {
            name = this.validateObjectName(objectName);
        }
        try {
            return new ObjectInstance(this.server.createMBean(className, name));
        }
        catch (ReflectionException re2) {
            ManagementException me2 = new ManagementException();
            me2.setMessage(10417, new Object[]{name});
            me2.setRootCause(re2);
            throw me2;
        }
        catch (InstanceAlreadyExistsException iaee) {
            ManagementException me3 = new ManagementException();
            me3.setMessage(10418, new Object[]{name});
            me3.setRootCause(iaee);
            throw me3;
        }
        catch (MBeanException mbe) {
            ManagementException me4 = new ManagementException();
            me4.setMessage(10417, new Object[]{name});
            me4.setRootCause(mbe);
            throw me4;
        }
        catch (NotCompliantMBeanException ncmbe) {
            ManagementException me5 = new ManagementException();
            me5.setMessage(10419, new Object[]{className});
            me5.setRootCause(ncmbe);
            throw me5;
        }
    }

    public ObjectInstance createMBean(String className, String objectName, String loaderName) {
        javax.management.ObjectName name = null;
        javax.management.ObjectName loader = null;
        if (objectName != null) {
            name = this.validateObjectName(objectName);
        }
        if (loaderName != null) {
            loader = this.validateObjectName(loaderName);
        }
        try {
            return new ObjectInstance(this.server.createMBean(className, name, loader));
        }
        catch (ReflectionException re2) {
            ManagementException me2 = new ManagementException();
            me2.setMessage(10417, new Object[]{name});
            me2.setRootCause(re2);
            throw me2;
        }
        catch (InstanceAlreadyExistsException iaee) {
            ManagementException me3 = new ManagementException();
            me3.setMessage(10418, new Object[]{name});
            me3.setRootCause(iaee);
            throw me3;
        }
        catch (MBeanException mbe) {
            ManagementException me4 = new ManagementException();
            me4.setMessage(10417, new Object[]{name});
            me4.setRootCause(mbe);
            throw me4;
        }
        catch (NotCompliantMBeanException ncmbe) {
            ManagementException me5 = new ManagementException();
            me5.setMessage(10419, new Object[]{className});
            me5.setRootCause(ncmbe);
            throw me5;
        }
        catch (InstanceNotFoundException infe) {
            ManagementException me6 = new ManagementException();
            me6.setMessage(10407, new Object[]{name});
            me6.setRootCause(infe);
            throw me6;
        }
    }

    public ObjectInstance createMBean(String className, String objectName, Object[] params, String[] signature) {
        javax.management.ObjectName name = null;
        if (objectName != null) {
            name = this.validateObjectName(objectName);
        }
        try {
            return new ObjectInstance(this.server.createMBean(className, name, params, signature));
        }
        catch (ReflectionException re2) {
            ManagementException me2 = new ManagementException();
            me2.setMessage(10417, new Object[]{name});
            me2.setRootCause(re2);
            throw me2;
        }
        catch (InstanceAlreadyExistsException iaee) {
            ManagementException me3 = new ManagementException();
            me3.setMessage(10418, new Object[]{name});
            me3.setRootCause(iaee);
            throw me3;
        }
        catch (MBeanException mbe) {
            ManagementException me4 = new ManagementException();
            me4.setMessage(10417, new Object[]{name});
            me4.setRootCause(mbe);
            throw me4;
        }
        catch (NotCompliantMBeanException ncmbe) {
            ManagementException me5 = new ManagementException();
            me5.setMessage(10419, new Object[]{className});
            me5.setRootCause(ncmbe);
            throw me5;
        }
    }

    public ObjectInstance createMBean(String className, String objectName, String loaderName, Object[] params, String[] signature) {
        javax.management.ObjectName name = null;
        javax.management.ObjectName loader = null;
        if (objectName != null) {
            name = this.validateObjectName(objectName);
        }
        if (loaderName != null) {
            loader = this.validateObjectName(loaderName);
        }
        try {
            return new ObjectInstance(this.server.createMBean(className, name, loader, params, signature));
        }
        catch (ReflectionException re2) {
            ManagementException me2 = new ManagementException();
            me2.setMessage(10417, new Object[]{name});
            me2.setRootCause(re2);
            throw me2;
        }
        catch (InstanceAlreadyExistsException iaee) {
            ManagementException me3 = new ManagementException();
            me3.setMessage(10418, new Object[]{name});
            me3.setRootCause(iaee);
            throw me3;
        }
        catch (MBeanException mbe) {
            ManagementException me4 = new ManagementException();
            me4.setMessage(10417, new Object[]{name});
            me4.setRootCause(mbe);
            throw me4;
        }
        catch (NotCompliantMBeanException ncmbe) {
            ManagementException me5 = new ManagementException();
            me5.setMessage(10419, new Object[]{className});
            me5.setRootCause(ncmbe);
            throw me5;
        }
        catch (InstanceNotFoundException infe) {
            ManagementException me6 = new ManagementException();
            me6.setMessage(10407, new Object[]{name});
            me6.setRootCause(infe);
            throw me6;
        }
    }

    public ObjectInstance registerMBean(Object object, String objectName) {
        javax.management.ObjectName name = null;
        if (objectName != null) {
            name = this.validateObjectName(objectName);
        }
        try {
            return new ObjectInstance(this.server.registerMBean(object, name));
        }
        catch (InstanceAlreadyExistsException iaee) {
            ManagementException me2 = new ManagementException();
            me2.setMessage(10418, new Object[]{name});
            me2.setRootCause(iaee);
            throw me2;
        }
        catch (NotCompliantMBeanException ncmbe) {
            ManagementException me3 = new ManagementException();
            me3.setMessage(10419, new Object[]{object.getClass().getName()});
            me3.setRootCause(ncmbe);
            throw me3;
        }
        catch (MBeanRegistrationException mbre) {
            ManagementException me4 = new ManagementException();
            me4.setMessage(10420, new Object[]{name});
            me4.setRootCause(mbre);
            throw me4;
        }
    }

    public void unregisterMBean(String objectName) {
        javax.management.ObjectName name = this.validateObjectName(objectName);
        try {
            this.server.unregisterMBean(name);
        }
        catch (InstanceNotFoundException infe) {
            ManagementException me2 = new ManagementException();
            me2.setMessage(10407, new Object[]{name});
            me2.setRootCause(infe);
            throw me2;
        }
        catch (MBeanRegistrationException mbre) {
            ManagementException me3 = new ManagementException();
            me3.setMessage(10421, new Object[]{name});
            me3.setRootCause(mbre);
            throw me3;
        }
    }

    public ObjectInstance getObjectInstance(String objectName) {
        javax.management.ObjectName name = this.validateObjectName(objectName);
        try {
            return new ObjectInstance(this.server.getObjectInstance(name));
        }
        catch (InstanceNotFoundException infe) {
            ManagementException me2 = new ManagementException();
            me2.setMessage(10407, new Object[]{name});
            me2.setRootCause(infe);
            throw me2;
        }
    }

    public ObjectInstance[] queryMBeans(String objectName) {
        javax.management.ObjectName name = this.validateObjectName(objectName);
        Set<javax.management.ObjectInstance> result = this.server.queryMBeans(name, null);
        int n10 = result.size();
        if (n10 > 0) {
            ObjectInstance[] toReturn = new ObjectInstance[n10];
            int i10 = 0;
            Iterator<javax.management.ObjectInstance> iter = result.iterator();
            while (iter.hasNext()) {
                toReturn[i10++] = new ObjectInstance(iter.next());
            }
            return toReturn;
        }
        return new ObjectInstance[0];
    }

    public ObjectName[] queryNames(String objectName) {
        javax.management.ObjectName name = this.validateObjectName(objectName);
        Set<javax.management.ObjectName> result = this.server.queryNames(name, null);
        int n10 = result.size();
        if (n10 > 0) {
            ObjectName[] toReturn = new ObjectName[n10];
            int i10 = 0;
            Iterator<javax.management.ObjectName> iter = result.iterator();
            while (iter.hasNext()) {
                toReturn[i10++] = new ObjectName(iter.next());
            }
            return toReturn;
        }
        return new ObjectName[0];
    }

    public boolean isRegistered(String objectName) {
        javax.management.ObjectName name = this.validateObjectName(objectName);
        return this.server.isRegistered(name);
    }

    public Integer getMBeanCount() {
        return this.server.getMBeanCount();
    }

    public Object getAttribute(String objectName, String attribute) {
        javax.management.ObjectName name = this.validateObjectName(objectName);
        try {
            return this.server.getAttribute(name, attribute);
        }
        catch (AttributeNotFoundException anfe) {
            ManagementException me2 = new ManagementException();
            me2.setMessage(10409, new Object[]{attribute, name});
            me2.setRootCause(anfe);
            throw me2;
        }
        catch (MBeanException mbe) {
            ManagementException me3 = new ManagementException();
            me3.setMessage(10410, new Object[]{attribute, name});
            me3.setRootCause(mbe);
            throw me3;
        }
        catch (ReflectionException re2) {
            ManagementException me4 = new ManagementException();
            me4.setMessage(10411, new Object[]{attribute, name});
            me4.setRootCause(re2);
            throw me4;
        }
        catch (InstanceNotFoundException infe) {
            ManagementException me5 = new ManagementException();
            me5.setMessage(10407, new Object[]{name});
            me5.setRootCause(infe);
            throw me5;
        }
        catch (RuntimeOperationsException roe) {
            ManagementException me6 = new ManagementException();
            me6.setMessage(10412);
            me6.setRootCause(roe);
            throw me6;
        }
    }

    public Attribute[] getAttributes(String objectName, String[] attributes) {
        javax.management.ObjectName name = this.validateObjectName(objectName);
        try {
            AttributeList result = this.server.getAttributes(name, attributes);
            Attribute[] values = new Attribute[result.size()];
            for (int i10 = 0; i10 < result.size(); ++i10) {
                values[i10] = new Attribute((javax.management.Attribute)result.get(i10));
            }
            return values;
        }
        catch (ReflectionException re2) {
            ManagementException me2 = new ManagementException();
            me2.setMessage(10413, new Object[]{name});
            me2.setRootCause(re2);
            throw me2;
        }
        catch (InstanceNotFoundException infe) {
            ManagementException me3 = new ManagementException();
            me3.setMessage(10407, new Object[]{name});
            me3.setRootCause(infe);
            throw me3;
        }
        catch (RuntimeOperationsException roe) {
            ManagementException me4 = new ManagementException();
            me4.setMessage(10414);
            me4.setRootCause(roe);
            throw me4;
        }
    }

    public void setAttribute(String objectName, Attribute attribute) {
        javax.management.ObjectName name = this.validateObjectName(objectName);
        javax.management.Attribute attrib = this.validateAttribute(attribute);
        try {
            this.server.setAttribute(name, attrib);
        }
        catch (ReflectionException re2) {
            ManagementException me2 = new ManagementException();
            me2.setMessage(10422, new Object[]{attrib.getName(), name});
            me2.setRootCause(re2);
            throw me2;
        }
        catch (InstanceNotFoundException infe) {
            ManagementException me3 = new ManagementException();
            me3.setMessage(10407, new Object[]{name});
            me3.setRootCause(infe);
            throw me3;
        }
        catch (AttributeNotFoundException anfe) {
            ManagementException me4 = new ManagementException();
            me4.setMessage(10409, new Object[]{attrib.getName(), name});
            me4.setRootCause(anfe);
            throw me4;
        }
        catch (MBeanException mbe) {
            ManagementException me5 = new ManagementException();
            me5.setMessage(10423, new Object[]{attrib.getName(), name});
            me5.setRootCause(mbe);
            throw me5;
        }
        catch (InvalidAttributeValueException iave) {
            ManagementException me6 = new ManagementException();
            me6.setMessage(10424, new Object[]{attrib.getValue(), attrib.getName(), name});
            me6.setRootCause(iave);
            throw me6;
        }
    }

    public Attribute[] setAttributes(String objectName, Attribute[] attributes) {
        javax.management.ObjectName name = this.validateObjectName(objectName);
        AttributeList attribList = new AttributeList();
        for (int i10 = 0; i10 < attributes.length; ++i10) {
            attribList.add(attributes[i10].toAttribute());
        }
        try {
            AttributeList result = this.server.setAttributes(name, attribList);
            Attribute[] values = new Attribute[result.size()];
            for (int i11 = 0; i11 < result.size(); ++i11) {
                values[i11] = new Attribute((javax.management.Attribute)result.get(i11));
            }
            return values;
        }
        catch (InstanceNotFoundException infe) {
            ManagementException me2 = new ManagementException();
            me2.setMessage(10407, new Object[]{name});
            me2.setRootCause(infe);
            throw me2;
        }
        catch (ReflectionException re2) {
            ManagementException me3 = new ManagementException();
            me3.setMessage(10425, new Object[]{name});
            me3.setRootCause(re2);
            throw me3;
        }
    }

    public Object invoke(String objectName, String operationName, Object[] params, String[] signature) {
        javax.management.ObjectName name = this.validateObjectName(objectName);
        try {
            return this.server.invoke(name, operationName, params, signature);
        }
        catch (ReflectionException re2) {
            ManagementException me2 = new ManagementException();
            me2.setMessage(10415, new Object[]{operationName, objectName});
            me2.setRootCause(re2);
            throw me2;
        }
        catch (InstanceNotFoundException infe) {
            ManagementException me3 = new ManagementException();
            me3.setMessage(10407, new Object[]{objectName});
            me3.setRootCause(infe);
            throw me3;
        }
        catch (MBeanException mbe) {
            ManagementException me4 = new ManagementException();
            me4.setMessage(10416, new Object[]{operationName, objectName});
            me4.setRootCause(mbe);
            throw me4;
        }
    }

    public String getDefaultDomain() {
        return this.server.getDefaultDomain();
    }

    public MBeanInfo getMBeanInfo(String objectName) {
        javax.management.ObjectName name = this.validateObjectName(objectName);
        try {
            return new MBeanInfo(this.server.getMBeanInfo(name));
        }
        catch (IntrospectionException ie2) {
            ManagementException me2 = new ManagementException();
            me2.setMessage(10406, new Object[]{objectName});
            me2.setRootCause(ie2);
            throw me2;
        }
        catch (InstanceNotFoundException infe) {
            ManagementException me3 = new ManagementException();
            me3.setMessage(10407, new Object[]{objectName});
            me3.setRootCause(infe);
            throw me3;
        }
        catch (ReflectionException re2) {
            ManagementException me4 = new ManagementException();
            me4.setMessage(10408, new Object[]{objectName});
            me4.setRootCause(re2);
            throw me4;
        }
    }

    public boolean isInstanceOf(String objectName, String className) {
        javax.management.ObjectName name = this.validateObjectName(objectName);
        try {
            return this.server.isInstanceOf(name, className);
        }
        catch (InstanceNotFoundException infe) {
            ManagementException me2 = new ManagementException();
            me2.setMessage(10407, new Object[]{objectName});
            me2.setRootCause(infe);
            throw me2;
        }
    }

    public ObjectName[] getFlexMBeanObjectNames() {
        javax.management.ObjectName pattern = this.validateObjectName("flex.runtime*:*");
        Set<javax.management.ObjectName> result = this.server.queryNames(pattern, null);
        ObjectName[] names = new ObjectName[result.size()];
        int i10 = 0;
        Iterator<javax.management.ObjectName> iter = result.iterator();
        while (iter.hasNext()) {
            names[i10++] = new ObjectName(iter.next());
        }
        return names;
    }

    public Integer getFlexMBeanCount() {
        return new Integer(this.getFlexMBeanObjectNames().length);
    }

    public String[] getFlexDomains() {
        ObjectName[] names = this.getFlexMBeanObjectNames();
        TreeSet<String> domains = new TreeSet<String>();
        if (names.length > 0) {
            for (int i10 = 0; i10 < names.length; ++i10) {
                String name = names[i10].canonicalName;
                String domain = name.substring(0, name.indexOf(58));
                if (domains.contains(domain)) continue;
                domains.add(domain);
            }
        }
        return domains.toArray(new String[domains.size()]);
    }

    private javax.management.ObjectName validateObjectName(String objectName) {
        try {
            return new javax.management.ObjectName(objectName);
        }
        catch (MalformedObjectNameException mone) {
            ManagementException me2 = new ManagementException();
            me2.setMessage(10400, new Object[]{objectName});
            throw me2;
        }
    }

    private javax.management.Attribute validateAttribute(Attribute attribute) {
        return attribute.toAttribute();
    }
}

