/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.renderer;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.lobobrowser.html.domimpl.ModelNode;
import org.lobobrowser.html.renderer.BaseRCollection;
import org.lobobrowser.html.renderer.BoundableRenderable;
import org.lobobrowser.html.renderer.MarkupUtilities;
import org.lobobrowser.html.renderer.OverflowException;
import org.lobobrowser.html.renderer.RBlank;
import org.lobobrowser.html.renderer.RElement;
import org.lobobrowser.html.renderer.RSpacing;
import org.lobobrowser.html.renderer.RStyleChanger;
import org.lobobrowser.html.renderer.RWord;
import org.lobobrowser.html.renderer.Renderable;
import org.lobobrowser.html.renderer.RenderableContainer;
import org.lobobrowser.html.renderer.RenderableSpot;
import org.lobobrowser.html.style.RenderState;

class RLine
extends BaseRCollection {
    private final ArrayList renderables = new ArrayList(8);
    private int baseLineOffset;
    private int desiredMaxWidth;

    public RLine(ModelNode modelNode, RenderableContainer container, int x2, int y2, int desiredMaxWidth, int height) {
        super(container, modelNode);
        this.x = x2;
        this.y = y2;
        this.width = 0;
        this.height = height;
        this.desiredMaxWidth = desiredMaxWidth;
        this.layoutUpTreeCanBeInvalidated = true;
    }

    public int getBaselineOffset() {
        return this.baseLineOffset;
    }

    protected void invalidateLayoutLocal() {
        this.layoutUpTreeCanBeInvalidated = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g2) {
        Iterator i2;
        RenderState rs = this.modelNode.getRenderState();
        if (rs != null) {
            Color textColor = rs.getColor();
            g2.setColor(textColor);
            Font font = rs.getFont();
            g2.setFont(font);
        }
        if ((i2 = this.renderables.iterator()) != null) {
            while (i2.hasNext()) {
                Object r2 = i2.next();
                if (r2 instanceof RElement) {
                    RElement relement = (RElement)r2;
                    Graphics newG = g2.create(relement.getX(), relement.getY(), relement.getWidth(), relement.getHeight());
                    try {
                        relement.paint(newG);
                        continue;
                    }
                    finally {
                        newG.dispose();
                        continue;
                    }
                }
                if (r2 instanceof BoundableRenderable) {
                    BoundableRenderable br = (BoundableRenderable)r2;
                    br.paintTranslated(g2);
                    continue;
                }
                ((Renderable)r2).paint(g2);
            }
        }
    }

    public final void addStyleChanger(RStyleChanger sc2) {
        this.renderables.add(sc2);
    }

    public final void add(Renderable renderable, boolean allowOverflow) throws OverflowException {
        if (renderable instanceof RWord) {
            this.addWord((RWord)renderable, allowOverflow);
        } else if (renderable instanceof RBlank) {
            this.addBlank((RBlank)renderable);
        } else if (renderable instanceof RElement) {
            this.addElement((RElement)renderable, allowOverflow);
        } else if (renderable instanceof RSpacing) {
            this.addSpacing((RSpacing)renderable);
        } else if (renderable instanceof RStyleChanger) {
            this.addStyleChanger((RStyleChanger)renderable);
        } else {
            throw new IllegalArgumentException("Can't add " + renderable);
        }
    }

    public final void addWord(RWord rword, boolean allowOverflow) throws OverflowException {
        int maxAscentPlusLeading;
        int offset = this.width;
        int wiwidth = rword.width;
        if (!allowOverflow && offset != 0 && offset + wiwidth > this.desiredMaxWidth) {
            Renderable renderable;
            ArrayList renderables = this.renderables;
            ArrayList<RWord> overflow = null;
            boolean cancel = false;
            int i2 = renderables.size();
            while (--i2 >= 0 && ((renderable = (Renderable)renderables.get(i2)) instanceof RWord || !(renderable instanceof BoundableRenderable))) {
                if (overflow == null) {
                    overflow = new ArrayList<RWord>();
                }
                if (renderable != rword && renderable instanceof RWord && ((RWord)renderable).getX() == 0) {
                    cancel = true;
                    break;
                }
                if (renderable instanceof RWord) {
                    int newOffset;
                    this.width = newOffset = ((RWord)renderable).getBounds().x;
                }
                overflow.add(0, (RWord)renderable);
                renderables.remove(i2);
            }
            if (!cancel) {
                if (overflow == null) {
                    throw new OverflowException(Collections.singleton(rword));
                }
                overflow.add(rword);
                throw new OverflowException(overflow);
            }
        }
        int extraHeight = 0;
        int maxDescent = this.height - this.baseLineOffset;
        if (rword.descent > maxDescent) {
            extraHeight += rword.descent - maxDescent;
        }
        if (rword.ascentPlusLeading > (maxAscentPlusLeading = this.baseLineOffset)) {
            extraHeight += rword.ascentPlusLeading - maxAscentPlusLeading;
        }
        if (extraHeight > 0) {
            int newHeight = this.height + extraHeight;
            this.adjustHeight(newHeight, newHeight, 4);
        }
        this.renderables.add(rword);
        rword.setParent(this);
        int x2 = offset;
        this.width = offset += wiwidth;
        rword.setOrigin(x2, this.baseLineOffset - rword.ascentPlusLeading);
    }

    public final void addBlank(RBlank rblank) {
        int x2 = this.width;
        int width = rblank.width;
        rblank.setOrigin(x2, this.baseLineOffset - rblank.ascentPlusLeading);
        this.renderables.add(rblank);
        rblank.setParent(this);
        this.width = x2 + width;
    }

    public final void addSpacing(RSpacing rblank) {
        int x2 = this.width;
        int width = rblank.width;
        rblank.setOrigin(x2, (this.height - rblank.height) / 2);
        this.renderables.add(rblank);
        rblank.setParent(this);
        this.width = x2 + width;
    }

    private final void setElementY(RElement relement, int elementHeight, int valign) {
        int yoffset;
        switch (valign) {
            case 4: {
                yoffset = this.height - elementHeight;
                break;
            }
            case 3: {
                yoffset = (this.height - elementHeight) / 2;
                break;
            }
            case 2: 
            case 5: {
                yoffset = this.baseLineOffset - elementHeight;
                break;
            }
            case 1: {
                yoffset = this.baseLineOffset - elementHeight / 2;
                break;
            }
            case 0: {
                yoffset = 0;
                break;
            }
            default: {
                yoffset = this.baseLineOffset - elementHeight;
            }
        }
        relement.setY(yoffset);
    }

    public final void addElement(RElement relement, boolean allowOverflow) throws OverflowException {
        int newX;
        int requiredHeight;
        int boundsw = this.width;
        int desiredMaxWidth = this.desiredMaxWidth;
        int pw = relement.getWidth();
        int offset = boundsw;
        if (!allowOverflow && offset != 0 && offset + pw > desiredMaxWidth) {
            throw new OverflowException(Collections.singleton(relement));
        }
        int boundsh = this.height;
        int ph = relement.getHeight();
        int valign = relement.getVAlign();
        switch (valign) {
            case 2: 
            case 5: {
                requiredHeight = ph + (boundsh - this.baseLineOffset);
                break;
            }
            case 1: {
                requiredHeight = Math.max(ph, ph / 2 + (boundsh - this.baseLineOffset));
                break;
            }
            default: {
                requiredHeight = ph;
            }
        }
        if (requiredHeight > boundsh) {
            this.adjustHeight(requiredHeight, ph, valign);
        }
        this.renderables.add(relement);
        relement.setParent(this);
        relement.setX(offset);
        this.setElementY(relement, ph, valign);
        this.width = newX = offset + pw;
    }

    private void adjustHeight(int newHeight, int elementHeight, int valign) {
        int baseline;
        this.height = newHeight;
        ArrayList renderables = this.renderables;
        FontMetrics firstFm = this.modelNode.getRenderState().getFontMetrics();
        int maxDescent = firstFm.getDescent();
        int maxAscentPlusLeading = firstFm.getAscent() + firstFm.getLeading();
        Iterator i2 = renderables.iterator();
        while (i2.hasNext()) {
            int ascentPlusLeading;
            Object r2 = i2.next();
            if (!(r2 instanceof RStyleChanger)) continue;
            RStyleChanger rstyleChanger = (RStyleChanger)r2;
            FontMetrics fm = rstyleChanger.getModelNode().getRenderState().getFontMetrics();
            int descent = fm.getDescent();
            if (descent > maxDescent) {
                maxDescent = descent;
            }
            if ((ascentPlusLeading = fm.getAscent() + fm.getLeading()) <= maxAscentPlusLeading) continue;
            maxAscentPlusLeading = ascentPlusLeading;
        }
        int textHeight = maxDescent + maxAscentPlusLeading;
        switch (valign) {
            case 4: {
                baseline = newHeight - maxDescent;
                break;
            }
            case 3: {
                baseline = (newHeight + textHeight) / 2 - maxDescent;
                break;
            }
            case 2: 
            case 5: {
                baseline = elementHeight;
                break;
            }
            case 1: {
                baseline = newHeight / 2;
                break;
            }
            case 0: {
                baseline = maxAscentPlusLeading;
                break;
            }
            default: {
                baseline = elementHeight;
            }
        }
        this.baseLineOffset = baseline;
        Iterator i3 = renderables.iterator();
        while (i3.hasNext()) {
            Object r3 = i3.next();
            if (r3 instanceof RWord) {
                RWord rword = (RWord)r3;
                rword.setY(baseline - rword.ascentPlusLeading);
                continue;
            }
            if (r3 instanceof RBlank) {
                RBlank rblank = (RBlank)r3;
                rblank.setY(baseline - rblank.ascentPlusLeading);
                continue;
            }
            if (!(r3 instanceof RElement)) continue;
            RElement relement = (RElement)r3;
            this.setElementY(relement, relement.getHeight(), relement.getVAlign());
        }
    }

    public RenderableSpot getLowestRenderableSpot(int x2, int y2) {
        Renderable[] rarray = this.renderables.toArray(Renderable.EMPTY_ARRAY);
        BoundableRenderable br = MarkupUtilities.findRenderable(rarray, x2, y2, false);
        if (br != null) {
            Rectangle rbounds = br.getBounds();
            return br.getLowestRenderableSpot(x2 - rbounds.x, y2 - rbounds.y);
        }
        return new RenderableSpot(this, x2, y2);
    }

    public Color getBlockBackgroundColor() {
        return this.container.getPaintedBackgroundColor();
    }

    public final void adjustHorizontalBounds(int newX, int newMaxWidth) throws OverflowException {
        this.x = newX;
        this.desiredMaxWidth = newMaxWidth;
        int topX = newX + newMaxWidth;
        ArrayList renderables = this.renderables;
        int size = renderables.size();
        ArrayList overflown = null;
        Rectangle lastInLine = null;
        for (int i2 = 0; i2 < size; ++i2) {
            Object r2 = renderables.get(i2);
            if (overflown == null && r2 instanceof BoundableRenderable) {
                BoundableRenderable br = (BoundableRenderable)r2;
                Rectangle brb = br.getBounds();
                int x2 = brb.x + brb.width;
                if (x2 > topX) {
                    overflown = new ArrayList(1);
                } else {
                    lastInLine = brb;
                }
            }
            if (overflown == null) continue;
            overflown.add(r2);
            renderables.remove(i2--);
            --size;
        }
        if (overflown != null) {
            if (lastInLine != null) {
                this.width = lastInLine.x + lastInLine.width;
            }
            throw new OverflowException(overflown);
        }
    }

    public Iterator getRenderables() {
        return this.renderables.iterator();
    }
}

