/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import org.lobobrowser.html.BrowserFrame;
import org.lobobrowser.html.HtmlRendererContext;
import org.lobobrowser.html.domimpl.FrameNode;
import org.lobobrowser.html.domimpl.HTMLElementImpl;
import org.lobobrowser.html.domimpl.NodeImpl;
import org.lobobrowser.html.gui.DocumentNotification;
import org.lobobrowser.html.renderer.NodeRenderer;
import org.lobobrowser.html.style.HtmlLength;
import org.lobobrowser.util.gui.WrapperLayout;

public class FrameSetPanel
extends JComponent
implements NodeRenderer {
    private static final Logger logger = null;
    private HTMLElementImpl rootNode;
    private HtmlRendererContext htmlContext;
    private Component[] frameComponents;
    private boolean domInvalid = true;

    public FrameSetPanel() {
        this.setLayout(WrapperLayout.getInstance());
        this.setPreferredSize(new Dimension(600, 400));
    }

    private HtmlLength[] getLengths(String spec) {
        if (spec == null) {
            return new HtmlLength[]{new HtmlLength("1*")};
        }
        StringTokenizer tok = new StringTokenizer(spec, ",");
        ArrayList<HtmlLength> lengths = new ArrayList<HtmlLength>();
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken().trim();
            try {
                lengths.add(new HtmlLength(token));
            }
            catch (Exception err) {}
        }
        return lengths.toArray(HtmlLength.EMPTY_ARRAY);
    }

    private HTMLElementImpl[] getSubFrames(HTMLElementImpl parent) {
        NodeImpl[] children = parent.getChildrenArray();
        ArrayList<NodeImpl> subFrames = new ArrayList<NodeImpl>();
        for (int i2 = 0; i2 < children.length; ++i2) {
            String nodeName;
            NodeImpl child = children[i2];
            if (!(child instanceof HTMLElementImpl) || !"FRAME".equalsIgnoreCase(nodeName = child.getNodeName()) && !"FRAMESET".equalsIgnoreCase(nodeName)) continue;
            subFrames.add(child);
        }
        return subFrames.toArray(new HTMLElementImpl[0]);
    }

    public void setRootNode(NodeImpl node) {
        HtmlRendererContext context;
        HTMLElementImpl element;
        if (!(node instanceof HTMLElementImpl)) {
            throw new IllegalArgumentException("node=" + node);
        }
        this.rootNode = element = (HTMLElementImpl)node;
        this.htmlContext = context = element.getHtmlRendererContext();
        this.domInvalid = true;
        this.invalidate();
        this.validateAll();
        this.repaint();
    }

    protected void validateAll() {
        Container parent;
        Container toValidate = this;
        while ((parent = toValidate.getParent()) != null && !parent.isValid()) {
            toValidate = parent;
        }
        ((Component)toValidate).validate();
    }

    public final void processDocumentNotifications(DocumentNotification[] notifications) {
        if (notifications.length > 0) {
            this.domInvalid = true;
            this.invalidate();
            if (this.isVisible()) {
                this.validate();
                this.repaint();
            }
        }
    }

    public void setBounds(int x2, int y2, int w2, int h2) {
        super.setBounds(x2, y2, w2, h2);
    }

    public void doLayout() {
        if (this.domInvalid) {
            this.domInvalid = false;
            this.removeAll();
            HtmlRendererContext context = this.htmlContext;
            if (context != null) {
                HTMLElementImpl element = this.rootNode;
                String rows = element.getAttribute("rows");
                String cols = element.getAttribute("cols");
                HtmlLength[] rowLengths = this.getLengths(rows);
                HtmlLength[] colLengths = this.getLengths(cols);
                HTMLElementImpl[] subframes = this.getSubFrames(element);
                Component[] frameComponents = new Component[subframes.length];
                this.frameComponents = frameComponents;
                for (int i2 = 0; i2 < subframes.length; ++i2) {
                    HTMLElementImpl frameElement = subframes[i2];
                    if (frameElement != null && "FRAMESET".equalsIgnoreCase(frameElement.getTagName())) {
                        FrameSetPanel fsp = new FrameSetPanel();
                        fsp.setRootNode(frameElement);
                        frameComponents[i2] = fsp;
                        continue;
                    }
                    if (frameElement instanceof FrameNode) {
                        BrowserFrame frame = context.createBrowserFrame();
                        ((FrameNode)((Object)frameElement)).setBrowserFrame(frame);
                        String src = frameElement.getAttribute("src");
                        if (src != null) {
                            try {
                                URL url = frameElement.getFullURL(src);
                                if (url != null) {
                                    frame.loadURL(url);
                                }
                            }
                            catch (MalformedURLException mfu) {
                                // empty catch block
                            }
                        }
                        frameComponents[i2] = frame.getComponent();
                        continue;
                    }
                    frameComponents[i2] = new JPanel();
                }
                HtmlLength[] rhl = rowLengths;
                HtmlLength[] chl = colLengths;
                Component[] fc2 = this.frameComponents;
                if (rhl != null && chl != null && fc2 != null) {
                    Dimension size = this.getSize();
                    Insets insets = this.getInsets();
                    int width = size.width - insets.left - insets.right;
                    int height = size.height - insets.left - insets.right;
                    int[] absColLengths = this.getAbsoluteLengths(chl, width);
                    int[] absRowLengths = this.getAbsoluteLengths(rhl, height);
                    this.add(this.getSplitPane(this.htmlContext, absColLengths, 0, absColLengths.length, absRowLengths, 0, absRowLengths.length, fc2));
                }
            }
        }
        super.doLayout();
    }

    private int[] getAbsoluteLengths(HtmlLength[] htmlLengths, int totalSize) {
        int absLength;
        int[] absLengths = new int[htmlLengths.length];
        int totalSizeNonMulti = 0;
        int sumMulti = 0;
        for (int i2 = 0; i2 < htmlLengths.length; ++i2) {
            HtmlLength htmlLength = htmlLengths[i2];
            int lengthType = htmlLength.getLengthType();
            if (lengthType == 1) {
                absLength = htmlLength.getRawValue();
                totalSizeNonMulti += absLength;
                absLengths[i2] = absLength;
                continue;
            }
            if (lengthType == 2) {
                absLength = htmlLength.getLength(totalSize);
                totalSizeNonMulti += absLength;
                absLengths[i2] = absLength;
                continue;
            }
            sumMulti += htmlLength.getRawValue();
        }
        int remaining = totalSize - totalSizeNonMulti;
        if (remaining > 0 && sumMulti > 0) {
            for (int i3 = 0; i3 < htmlLengths.length; ++i3) {
                HtmlLength htmlLength = htmlLengths[i3];
                if (htmlLength.getLengthType() != 0) continue;
                absLengths[i3] = absLength = remaining * htmlLength.getRawValue() / sumMulti;
            }
        }
        return absLengths;
    }

    private Component getSplitPane(HtmlRendererContext context, int[] colLengths, int firstCol, int numCols, int[] rowLengths, int firstRow, int numRows, Component[] frameComponents) {
        if (numCols == 1) {
            Component topComponent;
            int frameindex = colLengths.length * firstRow + firstCol;
            Component component = topComponent = frameindex < frameComponents.length ? frameComponents[frameindex] : null;
            if (numRows == 1) {
                return topComponent;
            }
            Component bottomComponent = this.getSplitPane(context, colLengths, firstCol, numCols, rowLengths, firstRow + 1, numRows - 1, frameComponents);
            JSplitPane sp = new JSplitPane(0, topComponent, bottomComponent);
            sp.setDividerLocation(rowLengths[firstRow]);
            return sp;
        }
        Component rightComponent = this.getSplitPane(context, colLengths, firstCol + 1, numCols - 1, rowLengths, firstRow, numRows, frameComponents);
        Component leftComponent = this.getSplitPane(context, colLengths, firstCol, 1, rowLengths, firstRow, numRows, frameComponents);
        JSplitPane sp = new JSplitPane(1, leftComponent, rightComponent);
        sp.setDividerLocation(colLengths[firstCol]);
        return sp;
    }
}

