/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.domimpl;

import org.lobobrowser.html.FormInput;
import org.lobobrowser.html.domimpl.HTMLBaseInputElement;
import org.lobobrowser.html.domimpl.HTMLOptionsCollectionImpl;
import org.lobobrowser.html.domimpl.InputContext;
import org.w3c.dom.DOMException;
import org.w3c.dom.html2.HTMLElement;
import org.w3c.dom.html2.HTMLOptionsCollection;
import org.w3c.dom.html2.HTMLSelectElement;

public class HTMLSelectElementImpl
extends HTMLBaseInputElement
implements HTMLSelectElement {
    private HTMLOptionsCollection options;

    public HTMLSelectElementImpl(String name) {
        super(name);
    }

    public void add(HTMLElement element, HTMLElement before) throws DOMException {
        this.insertBefore(element, before);
    }

    public int getLength() {
        return this.getOptions().getLength();
    }

    public boolean getMultiple() {
        InputContext ic2 = this.inputContext;
        if (ic2 != null) {
            return ic2.getMultiple();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HTMLOptionsCollection getOptions() {
        HTMLSelectElementImpl hTMLSelectElementImpl = this;
        synchronized (hTMLSelectElementImpl) {
            if (this.options == null) {
                this.options = new HTMLOptionsCollectionImpl(this);
            }
            return this.options;
        }
    }

    public int getSelectedIndex() {
        InputContext ic2 = this.inputContext;
        if (ic2 != null) {
            return ic2.getSelectedIndex();
        }
        return -1;
    }

    public int getSize() {
        InputContext ic2 = this.inputContext;
        if (ic2 != null) {
            return ic2.getVisibleSize();
        }
        return 0;
    }

    public String getType() {
        return this.getMultiple() ? "select-multiple" : "select-one";
    }

    public void remove(int index) {
        try {
            this.removeChild(this.getOptions().item(index));
        }
        catch (DOMException de) {
            this.warn("remove(): Unable to remove option at index " + index + ".", de);
        }
    }

    public void setLength(int length) throws DOMException {
        this.getOptions().setLength(length);
    }

    public void setMultiple(boolean multiple) {
        InputContext ic2 = this.inputContext;
        if (ic2 != null) {
            ic2.setMultiple(multiple);
        }
    }

    public void setSelectedIndex(int selectedIndex) {
        InputContext ic2 = this.inputContext;
        if (ic2 != null) {
            ic2.setSelectedIndex(selectedIndex);
        }
    }

    public void setSize(int size) {
        InputContext ic2 = this.inputContext;
        if (ic2 != null) {
            ic2.setVisibleSize(size);
        }
    }

    protected FormInput[] getFormInputs() {
        String name = this.getName();
        if (name == null) {
            return null;
        }
        return new FormInput[]{new FormInput(name, this.getValue())};
    }

    public void resetInput() {
        InputContext ic2 = this.inputContext;
        if (ic2 != null) {
            ic2.resetInput();
        }
    }
}

