/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.domimpl;

import java.util.HashMap;
import java.util.Map;
import org.lobobrowser.html.domimpl.HTMLDocumentImpl;
import org.lobobrowser.html.domimpl.HTMLElementBuilder;
import org.lobobrowser.html.domimpl.HTMLElementImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.html2.HTMLElement;

class ElementFactory {
    private final Map builders = new HashMap();
    private static ElementFactory instance = new ElementFactory();

    private ElementFactory() {
        Map builders = this.builders;
        builders.put("HTML", new HTMLElementBuilder.Html());
        builders.put("TITLE", new HTMLElementBuilder.Title());
        builders.put("BASE", new HTMLElementBuilder.Base());
        HTMLElementBuilder.Div div = new HTMLElementBuilder.Div();
        builders.put("DIV", div);
        builders.put("DL", div);
        builders.put("BODY", new HTMLElementBuilder.Body());
        builders.put("CENTER", new HTMLElementBuilder.Center());
        builders.put("CAPTION", new HTMLElementBuilder.Center());
        builders.put("PRE", new HTMLElementBuilder.Pre());
        builders.put("P", new HTMLElementBuilder.P());
        HTMLElementBuilder.Blockquote bq = new HTMLElementBuilder.Blockquote();
        builders.put("BLOCKQUOTE", bq);
        builders.put("DD", bq);
        builders.put("SPAN", new HTMLElementBuilder.Span());
        builders.put("IMG", new HTMLElementBuilder.Img());
        builders.put("STYLE", new HTMLElementBuilder.Style());
        builders.put("LINK", new HTMLElementBuilder.Link());
        builders.put("A", new HTMLElementBuilder.Anchor());
        builders.put("ANCHOR", new HTMLElementBuilder.Anchor());
        builders.put("TABLE", new HTMLElementBuilder.Table());
        builders.put("TD", new HTMLElementBuilder.Td());
        builders.put("TH", new HTMLElementBuilder.Th());
        builders.put("TR", new HTMLElementBuilder.Tr());
        builders.put("FORM", new HTMLElementBuilder.Form());
        builders.put("INPUT", new HTMLElementBuilder.Input());
        builders.put("BUTTON", new HTMLElementBuilder.Button());
        builders.put("TEXTAREA", new HTMLElementBuilder.Textarea());
        builders.put("SELECT", new HTMLElementBuilder.Select());
        builders.put("OPTION", new HTMLElementBuilder.Option());
        builders.put("FRAMESET", new HTMLElementBuilder.Frameset());
        builders.put("FRAME", new HTMLElementBuilder.Frame());
        builders.put("IFRAME", new HTMLElementBuilder.IFrame());
        builders.put("UL", new HTMLElementBuilder.Ul());
        builders.put("OL", new HTMLElementBuilder.Ol());
        builders.put("LI", new HTMLElementBuilder.Li());
        builders.put("HR", new HTMLElementBuilder.Hr());
        builders.put("BR", new HTMLElementBuilder.Br());
        builders.put("OBJECT", new HTMLElementBuilder.HtmlObject());
        builders.put("APPLET", new HTMLElementBuilder.Applet());
        builders.put("EMBED", new HTMLElementBuilder.NonStandard());
        builders.put("FONT", new HTMLElementBuilder.Font());
        builders.put("BASEFONT", new HTMLElementBuilder.BaseFont());
        builders.put("TT", new HTMLElementBuilder.Tt());
        builders.put("CODE", new HTMLElementBuilder.Code());
        builders.put("SMALL", new HTMLElementBuilder.Small());
        builders.put("BIG", new HTMLElementBuilder.Big());
        builders.put("B", new HTMLElementBuilder.Strong());
        builders.put("STRONG", new HTMLElementBuilder.Strong());
        builders.put("U", new HTMLElementBuilder.Underline());
        builders.put("STRIKE", new HTMLElementBuilder.Strike());
        HTMLElementBuilder.Em em = new HTMLElementBuilder.Em();
        builders.put("I", em);
        builders.put("EM", em);
        builders.put("CITE", em);
        HTMLElementBuilder.Heading heading = new HTMLElementBuilder.Heading();
        builders.put("H1", heading);
        builders.put("H2", heading);
        builders.put("H3", heading);
        builders.put("H4", heading);
        builders.put("H5", heading);
        builders.put("H6", heading);
    }

    public static ElementFactory getInstance() {
        return instance;
    }

    public final HTMLElement createElement(HTMLDocumentImpl document, String name) throws DOMException {
        String normalName = name.toUpperCase();
        HTMLElementBuilder builder = (HTMLElementBuilder)this.builders.get(normalName);
        if (builder == null) {
            HTMLElementImpl element = new HTMLElementImpl(name);
            element.setOwnerDocument(document);
            return element;
        }
        return builder.create(document, name);
    }
}

