/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.util;

import java.security.SecureRandom;
import java.util.Random;

public class UUIDUtils {
    private static SecureRandom _rand = new SecureRandom();
    private static Random _weakRand = new Random();
    private static final int MAX_IDS_PER_MILLI = 10000;
    private static long lastUsedTOD = 0L;
    private static int numIdsThisMilli = 0;
    private static final String alphaNum = "0123456789ABCDEF";
    private static final int BITS_PER_DIGIT = 4;
    private static final int BITS_PER_INT = 32;
    private static final int BITS_PER_LONG = 64;
    private static final int DIGITS_PER_INT = 8;
    private static final int DIGITS_PER_LONG = 16;
    private static char[] UPPER_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private UUIDUtils() {
    }

    public static String createUUID() {
        return UUIDUtils.createUUID(true);
    }

    public static String createUUID(boolean secure) {
        Random rand = secure ? _rand : _weakRand;
        StringBuffer s2 = new StringBuffer(36);
        UUIDUtils.appendHexString(UUIDUtils.uniqueTOD(), false, 11, s2);
        s2.append(alphaNum.charAt(rand.nextInt(16) | 8));
        UUIDUtils.appendRandomHexChars(32 - s2.length(), rand, s2);
        s2.insert(8, "-");
        s2.insert(13, "-");
        s2.insert(18, "-");
        s2.insert(23, "-");
        return s2.toString();
    }

    public static String fromByteArray(byte[] ba2) {
        if (ba2 != null && ba2.length == 16) {
            StringBuffer result = new StringBuffer(36);
            for (int i2 = 0; i2 < 16; ++i2) {
                if (i2 == 4 || i2 == 6 || i2 == 8 || i2 == 10) {
                    result.append("-");
                }
                result.append(UPPER_DIGITS[(ba2[i2] & 0xF0) >>> 4]);
                result.append(UPPER_DIGITS[ba2[i2] & 0xF]);
            }
            return result.toString();
        }
        return null;
    }

    public static boolean isUID(String uid) {
        if (uid != null && uid.length() == 36) {
            char[] chars = uid.toCharArray();
            for (int i2 = 0; i2 < 36; ++i2) {
                char c2 = chars[i2];
                if (!(i2 == 8 || i2 == 13 || i2 == 18 || i2 == 23 ? c2 != '-' : c2 < '0' || c2 > 'F' || c2 > '9' && c2 < 'A')) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static byte[] toByteArray(String uid) {
        if (UUIDUtils.isUID(uid)) {
            byte[] result = new byte[16];
            char[] chars = uid.toCharArray();
            int r2 = 0;
            for (int i2 = 0; i2 < chars.length; ++i2) {
                if (chars[i2] == '-') continue;
                int h1 = Character.digit(chars[i2], 16);
                int h2 = Character.digit(chars[++i2], 16);
                result[r2++] = (byte)((h1 << 4 | h2) & 0xFF);
            }
            return result;
        }
        return null;
    }

    private static void appendRandomHexChars(int n2, Random rand, StringBuffer result) {
        int digitsPerInt = 8;
        while (n2 > 0) {
            int digitsToUse = Math.min(n2, digitsPerInt);
            n2 -= digitsToUse;
            UUIDUtils.appendHexString(rand.nextInt(), true, digitsToUse, result);
        }
    }

    private static void appendHexString(long value, boolean prependZeroes, int nLeastSignificantDigits, StringBuffer result) {
        int bitsPerDigit = 4;
        long mask = (1L << bitsPerDigit) - 1L;
        if (nLeastSignificantDigits < 16) {
            value &= (1L << bitsPerDigit * nLeastSignificantDigits) - 1L;
        }
        int i2 = 0;
        long reorderedValue = 0L;
        if (value == 0L) {
            ++i2;
        } else {
            do {
                reorderedValue = reorderedValue << bitsPerDigit | value & mask;
                ++i2;
            } while ((value >>>= bitsPerDigit) != 0L);
        }
        if (prependZeroes) {
            for (int j2 = nLeastSignificantDigits - i2; j2 > 0; --j2) {
                result.append('0');
            }
        }
        while (i2 > 0) {
            result.append(alphaNum.charAt((int)(reorderedValue & mask)));
            reorderedValue >>>= bitsPerDigit;
            --i2;
        }
    }

    private static synchronized long uniqueTOD() {
        long currentTOD = System.currentTimeMillis();
        if (currentTOD < lastUsedTOD) {
            lastUsedTOD = currentTOD;
        }
        if (currentTOD == lastUsedTOD) {
            if (++numIdsThisMilli >= 10000) {
                while (currentTOD == lastUsedTOD) {
                    try {
                        Thread.sleep(1L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    currentTOD = System.currentTimeMillis();
                }
                lastUsedTOD = currentTOD;
                numIdsThisMilli = 0;
            }
        } else {
            lastUsedTOD = currentTOD;
            numIdsThisMilli = 0;
        }
        return lastUsedTOD * 10000L + (long)numIdsThisMilli;
    }
}

