/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.util;

import flex.messaging.io.PropertyProxy;
import flex.messaging.io.PropertyProxyRegistry;
import flex.messaging.util.BasicPrettyPrinter;
import flex.messaging.util.PrettyPrintable;
import flex.messaging.util.XMLUtil;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;

public class ToStringPrettyPrinter
extends BasicPrettyPrinter {
    private IdentityHashMap knownObjects;
    private int knownObjectsCount;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String prettify(Object o2) {
        try {
            this.knownObjects = new IdentityHashMap();
            this.knownObjectsCount = 0;
            String string = super.prettify(o2);
            Object var4_3 = null;
            this.knownObjects = null;
            this.knownObjectsCount = 0;
            return string;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.knownObjects = null;
            this.knownObjectsCount = 0;
            throw throwable;
        }
    }

    public Object copy() {
        return new ToStringPrettyPrinter();
    }

    protected void prettifyComplexType(Object o2) {
        if (!this.isKnownObject(o2)) {
            StringBuffer header = new StringBuffer();
            Class<?> c2 = o2.getClass();
            if (this.hasCustomToStringMethod(c2)) {
                this.trace.write(String.valueOf(o2));
            } else if (o2 instanceof Collection) {
                Collection col = (Collection)o2;
                header.append(c2.getName()).append(" (Collection size:").append(col.size()).append(")");
                this.trace.startArray(header.toString());
                Iterator it = col.iterator();
                int i2 = 0;
                while (it.hasNext()) {
                    this.trace.arrayElement(i2);
                    this.internalPrettify(it.next());
                    this.trace.newLine();
                    ++i2;
                }
                this.trace.endArray();
            } else if (c2.isArray()) {
                Class<?> componentType = c2.getComponentType();
                int count = Array.getLength(o2);
                header.append(componentType.getName()).append("[] (Array length:").append(count).append(")");
                this.trace.startArray(header.toString());
                for (int i3 = 0; i3 < count; ++i3) {
                    this.trace.arrayElement(i3);
                    this.internalPrettify(Array.get(o2, i3));
                    this.trace.newLine();
                }
                this.trace.endArray();
            } else if (o2 instanceof Document) {
                try {
                    String xml = XMLUtil.documentToString((Document)o2);
                    this.trace.write(xml);
                }
                catch (IOException ex) {
                    this.trace.write("(Document not printable)");
                }
            } else {
                PropertyProxy proxy = PropertyProxyRegistry.getProxy(o2);
                if (o2 instanceof PrettyPrintable) {
                    PrettyPrintable pp = (PrettyPrintable)o2;
                    header.append(pp.toStringHeader());
                } else {
                    header.append(c2.getName());
                    if (o2 instanceof Map) {
                        header.append(" (Map size:").append(((Map)o2).size()).append(")");
                    }
                }
                this.trace.startObject(header.toString());
                List propertyNames = proxy.getPropertyNames();
                if (propertyNames != null) {
                    for (String propName : propertyNames) {
                        this.trace.namedElement(propName);
                        Object value = null;
                        if (this.trace.nextElementExclude) {
                            this.trace.nextElementExclude = false;
                            value = "** [Value Suppressed] **";
                        } else {
                            String customToString;
                            if (o2 instanceof PrettyPrintable && (customToString = ((PrettyPrintable)o2).toStringCustomProperty(propName)) != null) {
                                value = customToString;
                            }
                            if (value == null) {
                                value = proxy.getValue(propName);
                            }
                        }
                        this.internalPrettify(value);
                        this.trace.newLine();
                    }
                }
                this.trace.endObject();
            }
        }
    }

    private boolean isKnownObject(Object o2) {
        Object ref = this.knownObjects.get(o2);
        if (ref != null) {
            try {
                int refNum = (Integer)ref;
                this.trace.writeRef(refNum);
            }
            catch (ClassCastException classCastException) {}
        } else {
            this.rememberObject(o2);
        }
        return ref != null;
    }

    private void rememberObject(Object o2) {
        this.knownObjects.put(o2, new Integer(this.knownObjectsCount++));
    }
}

