/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.util;

import flex.messaging.util.StringUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class ExceptionUtil {
    public static String[] unwrapMethods = new String[]{"getRootCause", "getTargetException", "getTargetError", "getException", "getCausedByException", "getLinkedException"};

    public static Throwable wrappedException(Throwable t2) {
        if (t2 instanceof InvocationTargetException) {
            return ((InvocationTargetException)t2).getTargetException();
        }
        return ExceptionUtil.getRootCauseWithReflection(t2);
    }

    public static Throwable baseException(Throwable t2) {
        Throwable wrapped = ExceptionUtil.wrappedException(t2);
        if (wrapped != null) {
            return ExceptionUtil.baseException(wrapped);
        }
        return t2;
    }

    public static String toString(Throwable t2) {
        StringWriter strWrt = new StringWriter();
        t2.printStackTrace(new PrintWriter(strWrt));
        return strWrt.toString();
    }

    public static String getStackTraceUpTo(Throwable t2, String prefix) {
        StringTokenizer tokens = new StringTokenizer(ExceptionUtil.toString(t2), "\n\r");
        StringBuffer trace = new StringBuffer();
        boolean done = false;
        String lookingFor = "at " + prefix;
        while (!done && tokens.hasMoreElements()) {
            String token = tokens.nextToken();
            if (token.indexOf(lookingFor) == -1) {
                trace.append(token);
            } else {
                done = true;
            }
            trace.append(StringUtils.NEWLINE);
        }
        return trace.toString();
    }

    public static String getStackTraceLines(Throwable t2, int numLines) {
        StringTokenizer tokens = new StringTokenizer(ExceptionUtil.toString(t2), "\n\r");
        StringBuffer trace = new StringBuffer();
        for (int i2 = 0; i2 < numLines; ++i2) {
            String token = tokens.nextToken();
            trace.append(token);
            trace.append(StringUtils.NEWLINE);
        }
        return trace.toString();
    }

    public static String getCallAt(Throwable t2, int nth) {
        StringTokenizer tokens = new StringTokenizer(ExceptionUtil.toString(t2), "\n\r");
        try {
            for (int i2 = 0; i2 <= nth; ++i2) {
                tokens.nextToken();
            }
            String token = tokens.nextToken();
            int index1 = token.indexOf(32);
            int index2 = token.indexOf(40);
            StringBuffer call = new StringBuffer();
            call.append(token.substring(index1 < 0 ? 0 : index1 + 1, index2 < 0 ? call.length() : index2));
            int index3 = token.indexOf(58, index2 < 0 ? 0 : index2);
            if (index3 >= 0) {
                int index4 = token.indexOf(41, index3);
                call.append(token.substring(index3, index4 < 0 ? token.length() : index4));
            }
            return call.toString();
        }
        catch (NoSuchElementException noSuchElementException) {
            return "unknown";
        }
    }

    public static String exceptionToString(Throwable t2) {
        StringWriter sw = new StringWriter();
        PrintWriter out = new PrintWriter(sw);
        ExceptionUtil.printExceptionStack(t2, out, 0);
        return sw.toString();
    }

    public static String exceptionFollowedByRootCausesToString(Throwable t2) {
        StringBuffer output = new StringBuffer();
        Throwable root = t2;
        while (root != null) {
            output.append(root == t2 ? (root instanceof Exception ? "  Exception: " : "  Error: ") : "  Root cause: ");
            output.append(ExceptionUtil.toString(root));
            Throwable cause = root.getCause();
            if (cause != (root = ExceptionUtil.wrappedException(root))) continue;
            break;
        }
        return output.toString();
    }

    protected static void printExceptionStack(Throwable th, PrintWriter out, int depth) {
        boolean printStackDepth = depth > 0;
        Throwable wrappedException = ExceptionUtil.wrappedException(th);
        if (wrappedException != null) {
            printStackDepth = true;
            ExceptionUtil.printExceptionStack(wrappedException, out, depth + 1);
        }
        if (printStackDepth) {
            out.write("[" + depth + "]");
        }
        th.printStackTrace(out);
    }

    private static Throwable getRootCauseWithReflection(Throwable t2) {
        for (int i2 = 0; i2 < unwrapMethods.length; ++i2) {
            Method m2 = null;
            try {
                m2 = t2.getClass().getMethod(unwrapMethods[i2], null);
                return (Throwable)m2.invoke((Object)t2, null);
            }
            catch (Exception exception) {
                continue;
            }
        }
        return null;
    }
}

