/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.util;

import flex.messaging.util.ObjectTrace;
import flex.messaging.util.PrettyPrintable;
import flex.messaging.util.PrettyPrinter;
import flex.messaging.util.StringUtils;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Map;

public class BasicPrettyPrinter
implements PrettyPrinter {
    protected ObjectTrace trace;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String prettify(Object o2) {
        try {
            this.trace = new ObjectTrace();
            this.internalPrettify(o2);
            String string = this.trace.toString();
            return string;
        }
        catch (Throwable t2) {
            String string = this.trace.toString();
            return string;
        }
        finally {
            this.trace = null;
        }
    }

    protected void internalPrettify(Object o2) {
        if (o2 == null) {
            this.trace.writeNull();
        } else if (o2 instanceof String) {
            String string = (String)o2;
            if (string.startsWith("<?xml")) {
                this.trace.write(StringUtils.prettifyXML(string));
            } else {
                this.trace.write(string);
            }
        } else if (o2 instanceof Number || o2 instanceof Boolean || o2 instanceof Date || o2 instanceof Calendar || o2 instanceof Character) {
            this.trace.write(o2);
        } else {
            this.prettifyComplexType(o2);
        }
    }

    protected void prettifyComplexType(Object o2) {
        StringBuffer header = new StringBuffer();
        if (o2 instanceof PrettyPrintable) {
            PrettyPrintable pp = (PrettyPrintable)o2;
            header.append(pp.toStringHeader());
        }
        Class<?> c2 = o2.getClass();
        String className = c2.getName();
        if (o2 instanceof Collection) {
            header.append(className).append(" (Collection size:").append(((Collection)o2).size()).append(")");
        } else if (o2 instanceof Map) {
            header.append(className).append(" (Map size:").append(((Map)o2).size()).append(")");
        } else if (c2.isArray() && c2.getComponentType() != null) {
            Class<?> componentType = c2.getComponentType();
            className = componentType.getName();
            header.append(className).append("[] (Array length:").append(Array.getLength(o2)).append(")");
        } else {
            header.append(className);
        }
        this.trace.startObject(header.toString());
        this.trace.endObject();
    }

    protected boolean hasCustomToStringMethod(Class c2) {
        try {
            Method toStringMethod = c2.getMethod("toString", null);
            Class<?> declaringClass = toStringMethod.getDeclaringClass();
            if (declaringClass != Object.class && !declaringClass.getName().startsWith("java.util")) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public Object copy() {
        return new BasicPrettyPrinter();
    }
}

