/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.util;

public class Base64 {
    private static final char[] alphabet = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    private static final int[] inverse = new int[]{64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 62, 64, 64, 64, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 64, 64, 64, 64, 64, 64, 64, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 64, 64, 64, 64, 64, 64, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64};

    public static void main(String[] args) {
        boolean printData = false;
        int randomLimit = 500;
        byte[] raw = new byte[(int)(Math.random() * (double)randomLimit)];
        for (int i2 = 0; i2 < raw.length; ++i2) {
            raw[i2] = i2 % 1024 < 256 ? (byte)(i2 % 1024) : (byte)((int)(Math.random() * 255.0) - 128);
        }
        Encoder encoder = new Encoder(100);
        encoder.encode(raw);
        String encoded = encoder.drain();
        Decoder decoder = new Decoder();
        decoder.decode(encoded);
        byte[] check = decoder.flush();
        String mesg = "Success!";
        if (check.length != raw.length) {
            mesg = "***** length mismatch!";
        } else {
            for (int i3 = 0; i3 < check.length; ++i3) {
                if (check[i3] == raw[i3]) continue;
                mesg = "***** data mismatch!";
                break;
            }
        }
        System.out.println(mesg);
        if (printData) {
            System.out.println("Decoded: " + new String(raw));
            System.out.println("Encoded: " + encoded);
            System.out.println("Decoded: " + new String(check));
        }
    }

    public static class Encoder {
        private int[] work = new int[]{0, 0, 0};
        private int count = 0;
        private int line = 0;
        private StringBuffer output;

        public Encoder(int size) {
            this.output = new StringBuffer(size);
        }

        private void encodeBlock() {
            this.output.append(alphabet[(this.work[0] & 0xFF) >> 2]);
            this.output.append(alphabet[(this.work[0] & 3) << 4 | (this.work[1] & 0xF0) >> 4]);
            if (this.count > 1) {
                this.output.append(alphabet[(this.work[1] & 0xF) << 2 | (this.work[2] & 0xC0) >> 6]);
            } else {
                this.output.append('=');
            }
            if (this.count > 2) {
                this.output.append(alphabet[this.work[2] & 0x3F]);
            } else {
                this.output.append('=');
            }
            if ((this.line += 4) == 76) {
                this.output.append('\n');
                this.line = 0;
            }
        }

        public void encode(byte[] data) {
            this.encode(data, 0, data.length);
        }

        public void encode(byte[] data, int offset, int length) {
            for (int plainIndex = offset; plainIndex < offset + length; ++plainIndex) {
                this.work[this.count] = data[plainIndex];
                ++this.count;
                if (this.count != this.work.length && offset + length - plainIndex != 1) continue;
                this.encodeBlock();
                this.count = 0;
                this.work[0] = 0;
                this.work[1] = 0;
                this.work[2] = 0;
            }
        }

        public String drain() {
            String r2 = this.output.toString();
            this.output.setLength(0);
            return r2;
        }

        public String flush() {
            if (this.count > 0) {
                this.encodeBlock();
            }
            String r2 = this.drain();
            this.count = 0;
            this.line = 0;
            this.work[0] = 0;
            this.work[1] = 0;
            this.work[2] = 0;
            return r2;
        }
    }

    public static class Decoder {
        private int filled = 0;
        private byte[] data;
        private int count = 0;
        private int[] work = new int[]{0, 0, 0, 0};

        public Decoder() {
            this.data = new byte[256];
        }

        public void decode(String encoded) {
            int estimate = 1 + encoded.length() * 3 / 4;
            if (this.filled + estimate > this.data.length) {
                int length;
                for (length = this.data.length * 2; length < this.filled + estimate; length *= 2) {
                }
                byte[] newdata = new byte[length];
                System.arraycopy(this.data, 0, newdata, 0, this.filled);
                this.data = newdata;
            }
            for (int i2 = 0; i2 < encoded.length(); ++i2) {
                char c2 = encoded.charAt(i2);
                if (c2 == '=') {
                    this.work[this.count++] = -1;
                } else {
                    if (inverse[c2] == 64) continue;
                    this.work[this.count++] = inverse[c2];
                }
                if (this.count != 4) continue;
                this.count = 0;
                this.data[this.filled++] = (byte)(this.work[0] << 2 | (this.work[1] & 0xFF) >> 4);
                if (this.work[2] == -1) break;
                this.data[this.filled++] = (byte)(this.work[1] << 4 | (this.work[2] & 0xFF) >> 2);
                if (this.work[3] == -1) break;
                this.data[this.filled++] = (byte)(this.work[2] << 6 | this.work[3]);
            }
        }

        public byte[] drain() {
            byte[] r2 = new byte[this.filled];
            System.arraycopy(this.data, 0, r2, 0, this.filled);
            this.filled = 0;
            return r2;
        }

        public byte[] flush() throws IllegalStateException {
            if (this.count > 0) {
                throw new IllegalStateException("a partial block (" + this.count + " of 4 bytes) was dropped, decoded data is probably truncated!");
            }
            return this.drain();
        }

        public void reset() {
            this.count = 0;
            this.filled = 0;
        }
    }
}

